/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.util.TypeUtil;
import jakarta.ejb.MessageDriven;
import jakarta.ejb.Singleton;
import jakarta.ejb.Stateful;
import jakarta.ejb.Stateless;
import jakarta.ejb.Timeout;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ejb.TransactionManagement;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=TransactionAttribute.class)
public class TransactionAttributeHandler
extends AbstractAttributeHandler
implements PostProcessor<EjbContext> {
    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        TransactionAttribute taAn = (TransactionAttribute)ainfo.getAnnotation();
        for (EjbContext ejbContext : ejbContexts) {
            EjbSessionDescriptor sd;
            EjbDescriptor ejbDesc = (EjbDescriptor)ejbContext.getDescriptor();
            ContainerTransaction containerTransaction = this.getContainerTransaction(taAn.value());
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            Set<MethodDescriptor> txBusMethods = ejbDesc.getTxBusinessMethodDescriptors();
            for (MethodDescriptor md : txBusMethods) {
                Method method = md.getMethod(ejbDesc);
                if (!TypeUtil.sameMethodSignature(method, annMethod) || ejbDesc.getContainerTransactionFor(md) != null) continue;
                ejbDesc.setContainerTransactionFor(md, containerTransaction);
            }
            if (!(ejbDesc instanceof EjbSessionDescriptor) || !(sd = (EjbSessionDescriptor)ejbDesc).isStateful() && !sd.isSingleton()) continue;
            ClassLoader loader = ejbDesc.getEjbBundleDescriptor().getClassLoader();
            Set<LifecycleCallbackDescriptor> lcds = ejbDesc.getLifecycleCallbackDescriptors();
            for (LifecycleCallbackDescriptor lcd : lcds) {
                if (!lcd.getLifecycleCallbackClass().equals(ejbDesc.getEjbClassName()) || !lcd.getLifecycleCallbackMethod().equals(annMethod.getName())) continue;
                try {
                    String txAttr;
                    Method m = lcd.getLifecycleCallbackMethodObject(loader);
                    MethodDescriptor md = new MethodDescriptor(m, "LifecycleCallback");
                    if (!TypeUtil.sameMethodSignature(m, annMethod) || ejbDesc.getContainerTransactionFor(md) != null) continue;
                    if (sd.isStateful() && containerTransaction != null && (txAttr = containerTransaction.getTransactionAttribute()) != null && !txAttr.equals("RequiresNew") && !txAttr.equals("NotSupported")) {
                        logger.log(Level.WARNING, MessageFormat.format("Stateful session bean {0} lifecycle callback method {1} has transaction attribute {2} with container-managed transaction demarcation. The transaction attribute should be either REQUIRES_NEW or NOT_SUPPORTED", sd.getName(), m.getName(), txAttr));
                    }
                    ejbDesc.setContainerTransactionFor(md, containerTransaction);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "Found matching callback method " + ejbDesc.getEjbClassName() + "<>" + String.valueOf(md) + " : " + String.valueOf(containerTransaction));
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Transaction attribute for a lifecycle callback annotation processing error", e);
                }
            }
        }
        return this.getDefaultProcessedResult();
    }

    private ContainerTransaction getContainerTransaction(TransactionAttributeType taType) {
        switch (taType) {
            case MANDATORY: {
                return new ContainerTransaction("Mandatory", "Mandatory");
            }
            case REQUIRED: {
                return new ContainerTransaction("Required", "Required");
            }
            case REQUIRES_NEW: {
                return new ContainerTransaction("RequiresNew", "RequiresNew");
            }
            case SUPPORTS: {
                return new ContainerTransaction("Supports", "Supports");
            }
            case NOT_SUPPORTED: {
                return new ContainerTransaction("NotSupported", "NotSupported");
            }
        }
        return new ContainerTransaction("Never", "Never");
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{MessageDriven.class, Stateful.class, Stateless.class, Singleton.class, Timeout.class, TransactionManagement.class};
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    @Override
    public void postProcessAnnotation(AnnotationInfo ainfo, EjbContext ejbContext) throws AnnotationProcessorException {
        EjbDescriptor ejbDesc = (EjbDescriptor)ejbContext.getDescriptor();
        TransactionAttribute taAn = (TransactionAttribute)ainfo.getAnnotation();
        ContainerTransaction containerTransaction = this.getContainerTransaction(taAn.value());
        Class classAn = (Class)ainfo.getAnnotatedElement();
        Set<MethodDescriptor> txBusMethods = ejbDesc.getTxBusinessMethodDescriptors();
        for (MethodDescriptor md : txBusMethods) {
            if (!classAn.equals(ejbContext.getDeclaringClass(md)) || ejbDesc.getContainerTransactionFor(md) != null) continue;
            ejbDesc.setContainerTransactionFor(md, containerTransaction);
        }
    }
}

