/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.InstalledLibrariesResolver;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;

public class DeploymentContextImpl
implements ExtendedDeploymentContext,
PreDestroy {
    @LogMessagesResourceBundle
    private static final String SHARED_LOGMESSAGE_RESOURCE = "org.glassfish.deployment.LogMessages";
    @LoggerInfo(subsystem="DEPLOYMENT", description="Deployment logger for common module", publish=true)
    private static final String DEPLOYMENT_LOGGER = "jakarta.enterprise.system.tools.deployment.common";
    public static final Logger deplLogger = Logger.getLogger("jakarta.enterprise.system.tools.deployment.common", "org.glassfish.deployment.LogMessages");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentContextImpl.class);
    private static final String INTERNAL_DIR_NAME = "__internal";
    private static final String APP_TENANTS_SUBDIR_NAME = "__app-tenants";
    private ReadableArchive source;
    private final ReadableArchive originalSource;
    private final OpsParams parameters;
    private ActionReport actionReport;
    private final ServerEnvironment env;
    private ClassLoader cloader;
    private ArchiveHandler archiveHandler;
    private Properties props;
    private final Map<String, Object> modulesMetaData = new HashMap<String, Object>();
    private ExtendedDeploymentContext.Phase phase = ExtendedDeploymentContext.Phase.UNKNOWN;
    private ClassLoader sharableTemp;
    private Map<String, Properties> modulePropsMap = new HashMap<String, Properties>();
    private final Map<String, Object> transientAppMetaData = new HashMap<String, Object>();
    private final Map<String, ArchiveHandler> moduleArchiveHandlers = new HashMap<String, ArchiveHandler>();
    private final Map<String, ExtendedDeploymentContext> moduleDeploymentContexts = new HashMap<String, ExtendedDeploymentContext>();
    private ExtendedDeploymentContext parentContext;
    private String moduleUri;
    private String tenant;
    private String originalAppName;
    private File tenantDir;

    public DeploymentContextImpl(Deployment.DeploymentContextBuilder builder, ServerEnvironment env) {
        this(builder.report(), builder.sourceAsArchive(), builder.params(), env);
    }

    public DeploymentContextImpl(ActionReport actionReport, Logger logger2, ReadableArchive source, OpsParams params, ServerEnvironment env) {
        this(actionReport, source, params, env);
    }

    public DeploymentContextImpl(ActionReport actionReport, ReadableArchive source, OpsParams params, ServerEnvironment env) {
        this.originalSource = source;
        this.source = source;
        this.actionReport = actionReport;
        this.parameters = params;
        this.env = env;
    }

    @Override
    public ExtendedDeploymentContext.Phase getPhase() {
        return this.phase;
    }

    @Override
    public void setPhase(ExtendedDeploymentContext.Phase newPhase) {
        this.phase = newPhase;
    }

    @Override
    public ReadableArchive getSource() {
        return this.source;
    }

    @Override
    public void setSource(ReadableArchive source) {
        this.source = source;
    }

    @Override
    public <U extends OpsParams> U getCommandParameters(Class<U> commandParametersType) {
        try {
            return (U)((OpsParams)commandParametersType.cast(this.parameters));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public Logger getLogger() {
        return deplLogger;
    }

    @Override
    public synchronized void preDestroy() {
        deplLogger.log(Level.FINEST, "preDestroy()");
        try {
            ((PreDestroy)PreDestroy.class.cast(this.sharableTemp)).preDestroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((PreDestroy)PreDestroy.class.cast(this.cloader)).preDestroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ClassLoader getFinalClassLoader() {
        return this.cloader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClassLoader(true);
    }

    @Override
    public synchronized void setClassLoader(ClassLoader cloader) {
        this.cloader = cloader;
    }

    @Override
    public synchronized void createDeploymentClassLoader(ClassLoaderHierarchy clh, ArchiveHandler handler) throws URISyntaxException, MalformedURLException {
        this.addTransientAppMetaData("isTempClassLoader", Boolean.TRUE);
        this.sharableTemp = this.createClassLoader(clh, handler, null);
    }

    @Override
    public void createApplicationClassLoader(ClassLoaderHierarchy classLoaderHierarchy, ArchiveHandler handler) throws URISyntaxException, MalformedURLException {
        this.addTransientAppMetaData("isTempClassLoader", Boolean.FALSE);
        if (this.cloader == null) {
            this.cloader = this.createClassLoader(classLoaderHierarchy, handler, this.parameters.name());
        }
    }

    private ClassLoader createClassLoader(ClassLoaderHierarchy classLoaderHierarchy, ArchiveHandler handler, String appName) throws URISyntaxException, MalformedURLException {
        ClassLoader applibCL = classLoaderHierarchy.getAppLibClassLoader(appName, this.getAppLibs());
        ClassLoader parentCL = classLoaderHierarchy.createApplicationParentCL(applibCL, this);
        return handler.getClassLoader(parentCL, this);
    }

    public synchronized ClassLoader getClassLoader(boolean sharable) {
        if (this.phase == ExtendedDeploymentContext.Phase.PREPARE) {
            if (sharable) {
                return this.sharableTemp;
            }
            return ((InstrumentableClassLoader)InstrumentableClassLoader.class.cast(this.sharableTemp)).copy();
        }
        if (this.sharableTemp instanceof PreDestroy) {
            try {
                ((PreDestroy)PreDestroy.class.cast(this.sharableTemp)).preDestroy();
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "ClassLoader preDestroy failed for " + String.valueOf(this.sharableTemp), e);
            }
        }
        this.sharableTemp = null;
        return this.cloader;
    }

    @Override
    public File getScratchDir(String subDirName) {
        File rootScratchDir = this.env.getApplicationStubPath();
        if (this.tenant != null && this.originalAppName != null) {
            rootScratchDir = this.getRootScratchTenantDirForApp(this.originalAppName);
            rootScratchDir = new File(rootScratchDir, this.tenant);
            if (subDirName != null) {
                rootScratchDir = new File(rootScratchDir, subDirName);
            }
            return rootScratchDir;
        }
        if (subDirName != null) {
            rootScratchDir = new File(rootScratchDir, subDirName);
        }
        return new File(rootScratchDir, VersioningUtils.getRepositoryName(this.parameters.name()));
    }

    @Override
    public File getSourceDir() {
        return new File(this.getSource().getURI());
    }

    @Override
    public void addModuleMetaData(Object metaData) {
        deplLogger.log(Level.FINEST, "addModuleMetaData(metaData={0})", metaData);
        if (metaData != null) {
            this.modulesMetaData.put(metaData.getClass().getName(), metaData);
        }
    }

    @Override
    public <T> T getModuleMetaData(Class<T> metadataType) {
        Object moduleMetaData = this.modulesMetaData.get(metadataType.getName());
        if (moduleMetaData != null) {
            return metadataType.cast(moduleMetaData);
        }
        for (Object metadata : this.modulesMetaData.values()) {
            try {
                return metadataType.cast(metadata);
            }
            catch (ClassCastException classCastException) {
            }
        }
        return null;
    }

    @Override
    public Collection<Object> getModuleMetadata() {
        return new ArrayList<Object>(this.modulesMetaData.values());
    }

    @Override
    public Map<String, Object> getTransientAppMetadata() {
        return new HashMap<String, Object>(this.transientAppMetaData);
    }

    @Override
    public void addTransientAppMetaData(String metaDataKey, Object metaData) {
        deplLogger.log(Level.FINEST, "addTransientAppMetaData(metaDataKey={0}, metaData)", metaDataKey);
        if (metaData != null) {
            this.transientAppMetaData.put(metaDataKey, metaData);
        }
    }

    @Override
    public <T> T getTransientAppMetaData(String key, Class<T> metadataType) {
        Object metaData = this.transientAppMetaData.get(key);
        if (metaData == null) {
            return null;
        }
        return metadataType.cast(metaData);
    }

    @Override
    public Properties getAppProps() {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props;
    }

    @Override
    public Properties getModuleProps() {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        InstrumentableClassLoader instrumentableClassLoader = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(this.getFinalClassLoader());
        ReentrantClassFileTransformer reentrantTransformer = new ReentrantClassFileTransformer(transformer);
        String isComposite = this.getAppProps().getProperty("isComposite");
        if (Boolean.valueOf(isComposite).booleanValue() && instrumentableClassLoader instanceof URLClassLoader) {
            boolean isAppLevel;
            URLClassLoader urlClassLoader = (URLClassLoader)((Object)instrumentableClassLoader);
            boolean bl = isAppLevel = this.getParentContext() == null;
            if (isAppLevel) {
                instrumentableClassLoader = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(urlClassLoader.getParent().getParent());
            } else {
                ClassLoader libClassLoader = urlClassLoader.getParent().getParent();
                if (!(libClassLoader instanceof InstrumentableClassLoader)) {
                    libClassLoader = libClassLoader.getParent();
                }
                if (libClassLoader instanceof InstrumentableClassLoader) {
                    ((InstrumentableClassLoader)InstrumentableClassLoader.class.cast(libClassLoader)).addTransformer(reentrantTransformer);
                }
            }
        }
        instrumentableClassLoader.addTransformer(reentrantTransformer);
    }

    @Override
    public List<URI> getAppLibs() throws URISyntaxException {
        URL[] extensionListLibraries;
        ArrayList<URI> libURIs = new ArrayList<URI>();
        if (this.parameters.libraries() != null) {
            URL[] urls;
            for (URL url : urls = ASClassLoaderUtil.getDeployParamLibrariesAsURLs(this.parameters.libraries(), this.env)) {
                File file = new File(url.getFile());
                deplLogger.log(Level.FINE, "Specified library jar: " + file.getAbsolutePath());
                if (!file.isFile()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.nonexist.libraries", "Specified library jar {0} does not exist: {1}", file.getName(), file.getAbsolutePath()));
                }
                libURIs.add(url.toURI());
            }
        }
        Set<String> extensionList = null;
        try {
            extensionList = InstalledLibrariesResolver.getInstalledLibraries(this.source);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        for (URL url : extensionListLibraries = ASClassLoaderUtil.getLibrariesAsURLs(extensionList, this.env)) {
            libURIs.add(url.toURI());
            if (!deplLogger.isLoggable(Level.FINEST)) continue;
            deplLogger.log(Level.FINEST, "Detected [EXTENSION_LIST] installed-library [ " + String.valueOf(url) + " ] for archive [ " + this.source.getName() + "]");
        }
        return libURIs;
    }

    @Override
    public void clean() {
        if (this.parameters.origin == OpsParams.Origin.undeploy || this.parameters.origin == OpsParams.Origin.deploy) {
            FileUtils.whack(this.getScratchDir("xml"));
            FileUtils.whack(this.getScratchDir("ejb"));
            FileUtils.whack(this.getScratchDir("jsp"));
            FileUtils.whack(this.getAppInternalDir());
            FileUtils.whack(this.getAppAltDDDir());
            FileUtils.whack(this.getRootTenantDirForApp(this.parameters.name()));
            FileUtils.whack(this.getRootScratchTenantDirForApp(this.parameters.name()));
        } else if (this.parameters.origin == OpsParams.Origin.mt_unprovision) {
            FileUtils.whack(this.tenantDir);
            FileUtils.whack(this.getScratchDir(null));
        }
    }

    @Override
    public ArchiveHandler getArchiveHandler() {
        return this.archiveHandler;
    }

    @Override
    public void setArchiveHandler(ArchiveHandler archiveHandler) {
        this.archiveHandler = archiveHandler;
    }

    @Override
    public ReadableArchive getOriginalSource() {
        return this.originalSource;
    }

    @Override
    public Map<String, Properties> getModulePropsMap() {
        return this.modulePropsMap;
    }

    @Override
    public void setModulePropsMap(Map<String, Properties> modulePropsMap) {
        this.modulePropsMap = modulePropsMap;
    }

    @Override
    public void setParentContext(ExtendedDeploymentContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public ExtendedDeploymentContext getParentContext() {
        return this.parentContext;
    }

    @Override
    public String getModuleUri() {
        return this.moduleUri;
    }

    @Override
    public void setModuleUri(String moduleUri) {
        this.moduleUri = moduleUri;
    }

    @Override
    public Map<String, ArchiveHandler> getModuleArchiveHandlers() {
        return this.moduleArchiveHandlers;
    }

    @Override
    public Map<String, ExtendedDeploymentContext> getModuleDeploymentContexts() {
        return this.moduleDeploymentContexts;
    }

    @Override
    public ActionReport getActionReport() {
        return this.actionReport;
    }

    @Override
    public File getAppInternalDir() {
        File internalDir = new File(this.env.getApplicationRepositoryPath(), INTERNAL_DIR_NAME);
        return new File(internalDir, VersioningUtils.getRepositoryName(this.parameters.name()));
    }

    @Override
    public File getAppAltDDDir() {
        File altDDDir = this.env.getApplicationAltDDPath();
        return new File(altDDDir, VersioningUtils.getRepositoryName(this.parameters.name()));
    }

    @Override
    public void setTenant(String tenant, String appName) {
        this.tenant = tenant;
        this.originalAppName = appName;
        this.tenantDir = this.initTenantDir();
    }

    @Override
    public String getTenant() {
        return this.tenant;
    }

    @Override
    public File getTenantDir() {
        return this.tenantDir;
    }

    @Override
    public void postDeployClean(boolean isFinalClean) {
        deplLogger.log(Level.FINEST, "postDeployClean(isFinalClean={0})", isFinalClean);
        if (this.transientAppMetaData != null) {
            if (isFinalClean) {
                for (Object value : this.transientAppMetaData.values()) {
                    if (!(value instanceof Closeable)) continue;
                    try {
                        ((Closeable)value).close();
                    }
                    catch (IOException e) {
                        deplLogger.log(Level.WARNING, "Close failed for " + String.valueOf(value), e);
                    }
                }
                this.transientAppMetaData.clear();
            } else {
                String[] classNamesToClean;
                for (String className : classNamesToClean = new String[]{Types.class.getName(), Parser.class.getName()}) {
                    this.transientAppMetaData.remove(className);
                }
            }
        }
        this.actionReport = null;
    }

    public String toString() {
        return String.valueOf(this.source == null ? "" : this.source) + " " + String.valueOf(this.originalSource == null ? "" : this.originalSource.getURI());
    }

    @Override
    public void prepareScratchDirs() throws IOException {
        this.prepareScratchDir(this.getScratchDir("ejb"));
        this.prepareScratchDir(this.getScratchDir("xml"));
        this.prepareScratchDir(this.getScratchDir("jsp"));
    }

    private File initTenantDir() {
        if (this.tenant == null || this.originalAppName == null) {
            return null;
        }
        File tenantDirectory = new File(this.getRootTenantDirForApp(this.originalAppName), this.tenant);
        if (!tenantDirectory.exists() && !tenantDirectory.mkdirs()) {
            deplLogger.log(Level.FINEST, "Unable to create directory {0}", tenantDirectory.getAbsolutePath());
        }
        return tenantDirectory;
    }

    private File getRootTenantDirForApp(String appName) {
        return new File(new File(this.env.getApplicationRepositoryPath(), APP_TENANTS_SUBDIR_NAME), appName);
    }

    private File getRootScratchTenantDirForApp(String appName) {
        return new File(new File(this.env.getApplicationStubPath(), APP_TENANTS_SUBDIR_NAME), appName);
    }

    private void prepareScratchDir(File scratchDir) throws IOException {
        if (!scratchDir.isDirectory() && !scratchDir.mkdirs()) {
            throw new IOException("Cannot create scratch directory : " + scratchDir.getAbsolutePath());
        }
    }

    static final class ReentrantClassFileTransformer
    implements ClassFileTransformer {
        private final ThreadLocal<Boolean> bytecodeTransforming = ThreadLocal.withInitial(() -> false);
        private final ClassFileTransformer transformer;

        ReentrantClassFileTransformer(ClassFileTransformer transformer) {
            this.transformer = transformer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (this.bytecodeTransforming.get().booleanValue()) {
                return null;
            }
            this.bytecodeTransforming.set(true);
            try {
                byte[] byArray = this.transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                return byArray;
            }
            finally {
                this.bytecodeTransforming.remove();
            }
        }
    }
}

