/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class AutodeployRetryManager
implements PostConstruct {
    private static final int RETRY_LIMIT_DEFAULT = 4;
    private HashMap<File, Info> invalidFiles = new HashMap();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AutodeployRetryManager.class);
    @Inject
    private DasConfig activeDasConfig;
    private int timeout;
    public static final Logger deplLogger = AutoDeployer.deplLogger;
    @LogMessageInfo(message="Configured timeout value of {0} second{0,choice,0#seconds|1#second|1<seconds} will be used but seems very large")
    private static final String LARGE_TIMEOUT = "NCLS-DEPLOYMENT-02031";
    @LogMessageInfo(message="Configured timeout value of {0} second{0,choice,0#seconds|1#second|1<seconds} is too small; using previous value of {1}second {1,choice,0#seconds|1#second|1<seconds}", level="WARNING")
    private static final String SMALL_TIMEOUT = "NCLS-DEPLOYMENT-02032";
    @LogMessageInfo(message="Could not convert configured timeout value of \"{0}\" to a number; using previous value of {1} second{1,choice,0#seconds|1#second|1<seconds", level="WARNING")
    private static final String INVALID_TIMEOUT = "NCLS-DEPLOYMENT-02033";

    @Override
    public void postConstruct() {
        this.setTimeout();
    }

    Info get(File file) {
        Info info = this.invalidFiles.get(file);
        return info;
    }

    boolean shouldAttemptDeployment(File file) {
        boolean result = true;
        String msg = null;
        boolean loggable = deplLogger.isLoggable(Level.FINE);
        Info info = this.invalidFiles.get(file);
        if (info != null) {
            result = info.shouldOpen();
            if (loggable) {
                msg = result ? localStrings.getLocalString("enterprise.deployment.autodeploy.try_stable_length", "file {0} has stable length so it should open as a JAR", file.getAbsolutePath()) : localStrings.getLocalString("enterprise.deployment.autodeploy.no_try_unstable_length", "file {0} has an unstable length of {1}; do not retry yet", file.getAbsolutePath(), String.valueOf(file.length()));
            }
            info.update();
        } else if (loggable) {
            msg = localStrings.getLocalString("enterprise.deployment.autodeploy.try_not_monitored", "file {0} should be opened as an archive because it is not being monitored as a slowly-growing file", file.getAbsolutePath());
        }
        if (loggable) {
            deplLogger.log(Level.FINE, msg);
        }
        return result;
    }

    AutoDeployer.AutodeploymentStatus chooseAutodeploymentStatus(ActionReport.ExitCode exitCode, File deployablefile) {
        if (exitCode != ActionReport.ExitCode.FAILURE) {
            return AutoDeployer.AutodeploymentStatus.forExitCode(exitCode);
        }
        Info info = this.invalidFiles.get(deployablefile);
        return info == null ? AutoDeployer.AutodeploymentStatus.FAILURE : AutoDeployer.AutodeploymentStatus.PENDING;
    }

    boolean recordFailedDeployment(File file) throws AutoDeploymentException {
        return this.recordFailedOpen(file);
    }

    boolean recordSuccessfulDeployment(File file) {
        return this.recordSuccessfulOpen(file);
    }

    boolean recordSuccessfulUndeployment(File file) {
        return this.endMonitoring(file);
    }

    boolean recordFailedUndeployment(File file) {
        return this.endMonitoring(file);
    }

    boolean endMonitoring(File file) {
        return this.invalidFiles.remove(file) != null;
    }

    private boolean recordFailedOpen(File file) throws AutoDeploymentException {
        Info info = this.get(file);
        boolean fileAlreadyPresent = info != null;
        if (!fileAlreadyPresent) {
            info = this.createInfo(file);
            this.invalidFiles.put(file, info);
            if (deplLogger.isLoggable(Level.FINE)) {
                String msg = localStrings.getLocalString("enterprise.deployment.autodeploy.begin_monitoring", "will monitor {0} waiting for its size to be stable size until {1}", file.getAbsolutePath(), new Date(info.retryExpiration).toString());
                deplLogger.log(Level.FINE, msg);
            }
        } else {
            info.update();
            boolean loggable = deplLogger.isLoggable(Level.FINE);
            if (!info.hasRetryPeriodExpired()) {
                if (loggable) {
                    String msg = localStrings.getLocalString("enterprise.deployment.autodeploy.continue_monitoring", "file {0} remains eligible for monitoring until {1}", file.getAbsolutePath(), new Date(info.retryExpiration).toString());
                    deplLogger.log(Level.FINE, msg);
                }
            } else {
                String msg = localStrings.getLocalString("enterprise.deployment.autodeploy.abort_monitoring", "File {0} is no longer eligible for retry; its size has been stable for {1} second{1,choice,0#s|1#|1<s} but it is still unrecognized as an archive", file.getAbsolutePath(), this.timeout);
                if (loggable) {
                    deplLogger.log(Level.FINE, msg);
                }
                this.invalidFiles.remove(file);
                throw new AutoDeploymentException(msg);
            }
        }
        return fileAlreadyPresent;
    }

    private boolean recordSuccessfulOpen(File file) {
        if (deplLogger.isLoggable(Level.FINE)) {
            String msg = localStrings.getLocalString("enterprise.deployment.autodeploy.end_monitoring", "File {0} opened successfully; no need to monitor it further", file.getAbsolutePath());
            deplLogger.log(Level.FINE, msg);
        }
        return this.invalidFiles.remove(file) != null;
    }

    private void setTimeout() {
        int newTimeout = this.timeout;
        String timeoutText = this.activeDasConfig.getAutodeployRetryTimeout();
        if (timeoutText == null || timeoutText.equals("")) {
            this.timeout = 4;
            return;
        }
        try {
            int configuredTimeout = Integer.parseInt(timeoutText);
            if (configuredTimeout > 1000) {
                deplLogger.log(Level.WARNING, LARGE_TIMEOUT, configuredTimeout);
                newTimeout = configuredTimeout;
            } else if (configuredTimeout <= 0) {
                deplLogger.log(Level.WARNING, SMALL_TIMEOUT, new Object[]{configuredTimeout, this.timeout});
            } else {
                newTimeout = configuredTimeout;
            }
        }
        catch (NumberFormatException ex) {
            deplLogger.log(Level.WARNING, INVALID_TIMEOUT, new Object[]{timeoutText, this.timeout});
        }
        this.timeout = newTimeout;
    }

    private Info createInfo(File f) {
        if (f.isDirectory()) {
            return new DirectoryInfo(f);
        }
        return new JarInfo(f);
    }

    private abstract class Info {
        protected File file = null;
        protected long retryExpiration = 0L;

        public Info(File file) {
            this.file = file;
        }

        protected abstract boolean shouldOpen();

        protected abstract boolean update();

        private boolean hasRetryPeriodExpired() {
            return System.currentTimeMillis() > this.retryExpiration;
        }

        protected void postponeRetryExpiration() {
            this.retryExpiration = System.currentTimeMillis() + (long)AutodeployRetryManager.this.timeout * 1000L;
        }
    }

    private class DirectoryInfo
    extends Info {
        private long whenScanned;

        public DirectoryInfo(File f) {
            super(f);
            this.whenScanned = 0L;
            this.update();
        }

        @Override
        protected boolean shouldOpen() {
            return true;
        }

        @Override
        protected boolean update() {
            long newWhenScanned = System.currentTimeMillis();
            boolean hasChanged = this.isNewerFile(this.file, this.whenScanned);
            if (hasChanged) {
                this.postponeRetryExpiration();
            }
            this.whenScanned = newWhenScanned;
            return hasChanged;
        }

        private boolean isNewerFile(File f, long timestamp) {
            boolean aFileIsNewer;
            boolean bl = aFileIsNewer = f.lastModified() > timestamp;
            if (!aFileIsNewer && f.isDirectory()) {
                File containedFile;
                File[] fileArray = f.listFiles();
                int n = fileArray.length;
                for (int i = 0; i < n && !(aFileIsNewer = this.isNewerFile(containedFile = fileArray[i], timestamp)); ++i) {
                }
            }
            return aFileIsNewer;
        }
    }

    private class JarInfo
    extends Info {
        private long recordedLength;

        public JarInfo(File f) {
            super(f);
            this.recordedLength = f.length();
            this.update();
        }

        @Override
        protected boolean shouldOpen() {
            return this.file.length() == this.recordedLength;
        }

        @Override
        protected boolean update() {
            long currentLength = this.file.length();
            boolean hasChanged = this.recordedLength != currentLength;
            if (hasChanged) {
                this.postponeRetryExpiration();
            }
            this.recordedLength = currentLength;
            return hasChanged;
        }
    }
}

