/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-application-ref")
@I18n(value="delete.application.ref.command")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@PerLookup
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.DELETE, path="delete-application-ref"), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.DELETE, path="delete-application-ref")})
public class DeleteApplicationRefCommand
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteApplicationRefCommand.class);
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true, defaultValue="false")
    public Boolean cascade;
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    Applications applications;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    VersioningService versioningService;
    @Inject
    @Named(value="default-instance-name")
    protected Server server;
    @Inject
    ServerEnvironment env;
    private List<String> matchedVersions;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        try {
            this.matchedVersions = this.versioningService.getMatchedVersions(this.name, this.target);
        }
        catch (VersioningException e) {
            report.failure(logger2, e.getMessage());
            return false;
        }
        if (this.matchedVersions.isEmpty()) {
            if (this.env.isDas()) {
                report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", this.name, this.target));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            return false;
        }
        return true;
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        return DeploymentCommandUtils.getAccessChecksForExistingApp(this.domain, this.applications, this.target, this.matchedVersions, "update", "delete");
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        UndeployCommandParameters commandParams = new UndeployCommandParameters();
        commandParams.origin = this.server.isDas() ? OpsParams.Origin.unload : OpsParams.Origin.undeploy;
        commandParams.command = OpsParams.Command.delete_application_ref;
        for (String appName : this.matchedVersions) {
            Application application = this.applications.getApplication(appName);
            if (application == null) {
                if (this.env.isDas()) {
                    report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", appName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                }
                return;
            }
            ApplicationRef applicationRef = this.domain.getApplicationRefInTarget(appName, this.target);
            if (applicationRef == null) {
                if (this.env.isDas()) {
                    report.setMessage(localStrings.getLocalString("appref.not.exists", "Target {1} does not have a reference to application {0}.", appName, this.target));
                    report.setActionExitCode(ActionReport.ExitCode.WARNING);
                }
                return;
            }
            if (application.isLifecycleModule()) {
                try {
                    this.deployment.unregisterAppFromDomainXML(appName, this.target, true);
                }
                catch (Exception e) {
                    report.failure(logger2, e.getMessage());
                }
                return;
            }
            try {
                ReadableArchive source = null;
                ApplicationInfo appInfo = this.deployment.get(appName);
                if (appInfo != null) {
                    source = appInfo.getSource();
                } else {
                    File location = new File(new URI(application.getLocation()));
                    source = this.archiveFactory.openArchive(location);
                }
                commandParams.name = appName;
                commandParams.cascade = this.cascade;
                ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger2, commandParams, report).source(source).build();
                deploymentContext.getAppProps().putAll((Map<?, ?>)application.getDeployProperties());
                deploymentContext.setModulePropsMap(application.getModulePropertiesMap());
                if (this.domain.isCurrentInstanceMatchingTarget(this.target, appName, this.server.getName(), null) && appInfo != null) {
                    this.deployment.unload(appInfo, deploymentContext);
                }
                if (!report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
                try {
                    if (this.server.isInstance()) {
                        this.deployment.undeploy(appName, deploymentContext);
                        deploymentContext.clean();
                        if (!Boolean.valueOf(application.getDirectoryDeployed()).booleanValue() && source.exists()) {
                            FileUtils.whack(new File(source.getURI()));
                        }
                        this.deployment.unregisterAppFromDomainXML(appName, this.target);
                        continue;
                    }
                    this.deployment.unregisterAppFromDomainXML(appName, this.target, true);
                }
                catch (TransactionFailure e) {
                    logger2.warning("failed to delete application ref for " + appName);
                }
            }
            catch (Exception e) {
                logger2.log(Level.SEVERE, "Error during deleteing application ref ", e);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(e.getMessage());
            }
        }
    }
}

