/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.admin.cli.ConnectionPoolUtil;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.PropertyBag;

@Service(name="flush-connection-pool")
@PerLookup
@I18n(value="flush.connection.pool")
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.POST, path="flush-connection-pool", description="flush-connection-pool")})
public class FlushConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FlushConnectionPool.class);
    @Param(name="pool_name", primary=true)
    private String poolName;
    @Inject
    private Domain domain;
    @Param(name="appname", optional=true)
    private String applicationName;
    @Param(name="modulename", optional=true)
    private String moduleName;
    @Inject
    private Applications applications;
    @Inject
    private ConnectionPoolUtil poolUtil;
    @Inject
    private ConnectorRuntime _runtime;

    @Override
    public void execute(AdminCommandContext context) {
        PropertyBag ccp;
        Application application;
        ActionReport report = context.getActionReport();
        Resources resources = this.domain.getResources();
        String scope = "";
        if (this.moduleName != null) {
            if (!this.poolUtil.isValidModule(this.applicationName, this.moduleName, this.poolName, report)) {
                return;
            }
            application = this.applications.getApplication(this.applicationName);
            Module module = application.getModule(this.moduleName);
            resources = module.getResources();
            scope = "java:module/";
        } else if (this.applicationName != null) {
            if (!this.poolUtil.isValidApplication(this.applicationName, this.poolName, report)) {
                return;
            }
            application = this.applications.getApplication(this.applicationName);
            resources = application.getResources();
            scope = "java:app/";
        }
        SimpleJndiName jndiName = new SimpleJndiName(this.poolName);
        if (!this.poolUtil.isValidPool(resources, jndiName, scope, report)) {
            return;
        }
        boolean poolingEnabled = false;
        ResourcePool pool = resources.getResourceByName(ResourcePool.class, jndiName);
        if (pool instanceof ConnectorConnectionPool) {
            ccp = (ConnectorConnectionPool)pool;
            poolingEnabled = Boolean.parseBoolean(ccp.getPooling());
        } else {
            ccp = (JdbcConnectionPool)pool;
            poolingEnabled = Boolean.parseBoolean(ccp.getPooling());
        }
        if (!poolingEnabled) {
            String i18nMsg = localStrings.getLocalString("flush.connection.pool.pooling.disabled", "Attempt to Flush Connection Pool failed because Pooling is disabled for pool : {0}", this.poolName);
            report.setMessage(i18nMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            PoolInfo poolInfo = new PoolInfo(jndiName, this.applicationName, this.moduleName);
            this._runtime.flushConnectionPool(poolInfo);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (ConnectorRuntimeException e) {
            report.setMessage(localStrings.getLocalString("flush.connection.pool.fail", "Flush connection pool for {0} failed", this.poolName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }
}

