/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import jakarta.inject.Singleton;
import java.util.StringTokenizer;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.ValidationInformation;
import org.glassfish.hk2.api.ValidationService;
import org.glassfish.hk2.api.Validator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class HK2BindTracingService
implements ValidationService {
    private static final Filter ALL_FILTER = BuilderHelper.allFilter();
    private static final Filter NONE_FILTER = new Filter(){

        @Override
        public boolean matches(Descriptor d) {
            return false;
        }
    };
    private static final boolean TRACE_BINDS = Boolean.parseBoolean(System.getProperty("org.glassfish.hk2.tracing.binds", "false"));
    private static final String TRACE_BINDS_PATTERN = System.getProperty("org.glassfish.hk2.tracing.bindsPattern");
    private static final boolean TRACE_LOOKUPS = Boolean.parseBoolean(System.getProperty("org.glassfish.hk2.tracing.lookups", "false"));
    private static final String TRACE_LOOKUPS_PATTERN = System.getProperty("org.glassfish.hk2.tracing.lookupsPattern");
    private static final String STACK_PATTERN = System.getProperty("org.glassfish.hk2.tracing.binds.stackPattern");
    private static final Validator VALIDATOR = new ValidatorImpl();

    @Override
    public Filter getLookupFilter() {
        if (TRACE_LOOKUPS) {
            return ALL_FILTER;
        }
        return NONE_FILTER;
    }

    @Override
    public Validator getValidator() {
        return VALIDATOR;
    }

    private static boolean matchesPattern(String pattern, ActiveDescriptor<?> descriptor) {
        if (pattern == null) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(pattern, "|");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (descriptor.getImplementation().contains(token)) {
                return true;
            }
            for (String contract : descriptor.getAdvertisedContracts()) {
                if (!contract.contains(token)) continue;
                return true;
            }
        }
        return false;
    }

    private static class ValidatorImpl
    implements Validator {
        private ValidatorImpl() {
        }

        @Override
        public boolean validate(ValidationInformation info) {
            if (!TRACE_BINDS && !TRACE_LOOKUPS) {
                return true;
            }
            switch (info.getOperation()) {
                case BIND: {
                    if (!TRACE_BINDS || !HK2BindTracingService.matchesPattern(TRACE_BINDS_PATTERN, info.getCandidate())) break;
                    System.out.println("HK2 Tracing (BIND): " + String.valueOf(info.getCandidate()));
                    break;
                }
                case UNBIND: {
                    if (!TRACE_BINDS || !HK2BindTracingService.matchesPattern(TRACE_BINDS_PATTERN, info.getCandidate())) break;
                    System.out.println("HK2 Tracing (UNBIND): " + String.valueOf(info.getCandidate()));
                    break;
                }
                case LOOKUP: {
                    if (!TRACE_LOOKUPS || !HK2BindTracingService.matchesPattern(TRACE_LOOKUPS_PATTERN, info.getCandidate())) break;
                    System.out.println("HK2 Tracing (LOOKUP) Candidate: " + String.valueOf(info.getCandidate()));
                    if (info.getInjectee() == null) break;
                    System.out.println("HK2 Tracing (LOOKUP) Injectee: " + String.valueOf(info.getInjectee()));
                    break;
                }
            }
            if (STACK_PATTERN != null && HK2BindTracingService.matchesPattern(STACK_PATTERN, info.getCandidate())) {
                Thread.dumpStack();
            }
            return true;
        }
    }
}

