/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.hk2;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.cdi.hk2.CDIContextBridge;
import org.glassfish.cdi.hk2.CDISecondChanceResolver;
import org.glassfish.cdi.hk2.HK2CDIBean;
import org.glassfish.cdi.hk2.HK2ContextBridge;
import org.glassfish.cdi.hk2.HK2IntegrationUtilities;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;

public class HK2IntegrationExtension
implements Extension {
    private final HashMap<Long, ActiveDescriptor<?>> foundWithHK2 = new HashMap();
    private final ServiceLocator locator = HK2IntegrationUtilities.getApplicationServiceLocator();

    private <T> void injectionTargetObserver(@Observes ProcessInjectionTarget<T> pit) {
        if (this.locator == null) {
            return;
        }
        InjectionTarget<T> injectionTarget = pit.getInjectionTarget();
        Set<InjectionPoint> injectionPoints = injectionTarget.getInjectionPoints();
        for (InjectionPoint injectionPoint : injectionPoints) {
            Injectee injectee = HK2IntegrationUtilities.convertInjectionPointToInjectee(injectionPoint);
            ActiveDescriptor<?> descriptor = this.locator.getInjecteeDescriptor(injectee);
            if (descriptor == null || descriptor.getServiceId() == null) continue;
            this.foundWithHK2.put(descriptor.getServiceId(), descriptor);
        }
    }

    private void afterDiscoveryObserver(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        if (this.locator == null) {
            return;
        }
        HashSet<Class<Annotation>> customScopes = new HashSet<Class<Annotation>>();
        for (ActiveDescriptor<?> descriptor : this.foundWithHK2.values()) {
            afterBeanDiscovery.addBean(new HK2CDIBean(this.locator, descriptor));
            customScopes.add(descriptor.getScopeAnnotation());
        }
        customScopes.remove(PerLookup.class);
        customScopes.remove(Singleton.class);
        List<Context> hk2Contexts = this.locator.getAllServices(Context.class, new Annotation[0]);
        for (Context hk2Context : hk2Contexts) {
            if (!customScopes.contains(hk2Context.getScope())) continue;
            afterBeanDiscovery.addContext(new HK2ContextBridge(hk2Context));
        }
        this.foundWithHK2.clear();
    }

    private void afterDeploymentValidation(@Observes AfterDeploymentValidation event) {
        if (this.locator == null) {
            return;
        }
        DynamicConfiguration config = this.locator.getService(DynamicConfigurationService.class, new Annotation[0]).createDynamicConfiguration();
        config.addActiveDescriptor(CDISecondChanceResolver.class);
        config.addActiveDescriptor(CDIContextBridge.class);
        config.commit();
    }

    public String toString() {
        return "HK2IntegrationExtension(" + String.valueOf(this.locator) + "," + System.identityHashCode(this) + ")";
    }
}

