/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.invocation;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.glassfish.api.invocation.ApplicationEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ComponentInvocationHandler;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.glassfish.hk2.api.IterableProvider;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class InvocationManagerImpl
implements InvocationManager {
    private static final System.Logger LOG = System.getLogger(InvocationManagerImpl.class.getName());
    private InheritableThreadLocal<InvocationArray<ComponentInvocation>> frames;
    private final ThreadLocal<Stack<ApplicationEnvironment>> applicationEnvironments = new ThreadLocal<Stack<ApplicationEnvironment>>(){

        @Override
        protected Stack<ApplicationEnvironment> initialValue() {
            return new Stack<ApplicationEnvironment>();
        }
    };
    private final Map<ComponentInvocation.ComponentInvocationType, List<RegisteredComponentInvocationHandler>> regCompInvHandlerMap = new HashMap<ComponentInvocation.ComponentInvocationType, List<RegisteredComponentInvocationHandler>>();
    private final ComponentInvocationHandler[] invHandlers;

    public InvocationManagerImpl() {
        this(null);
    }

    @Inject
    private InvocationManagerImpl(@Optional IterableProvider<ComponentInvocationHandler> handlers) {
        LOG.log(System.Logger.Level.DEBUG, "InvocationManagerImpl(handlers={0})", handlers);
        if (handlers == null) {
            this.invHandlers = null;
        } else {
            LinkedList<ComponentInvocationHandler> localHandlers = new LinkedList<ComponentInvocationHandler>();
            for (ComponentInvocationHandler handler : handlers) {
                localHandlers.add(handler);
            }
            this.invHandlers = localHandlers.isEmpty() ? null : (ComponentInvocationHandler[])localHandlers.toArray(ComponentInvocationHandler[]::new);
        }
        this.frames = new InheritableThreadLocal<InvocationArray<ComponentInvocation>>(){

            @Override
            protected InvocationArray<ComponentInvocation> initialValue() {
                return new InvocationArray<ComponentInvocation>();
            }

            @Override
            protected InvocationArray<ComponentInvocation> childValue(InvocationArray<ComponentInvocation> parentValue) {
                InvocationArray<ComponentInvocation> result = new InvocationArray<ComponentInvocation>();
                if (!parentValue.isEmpty() && parentValue.outsideStartup()) {
                    ComponentInvocation parentInv = (ComponentInvocation)parentValue.get(parentValue.size() - 1);
                    if (parentInv.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION) {
                        ComponentInvocation inv = new ComponentInvocation();
                        inv.componentId = parentInv.getComponentId();
                        inv.setComponentInvocationType(parentInv.getInvocationType());
                        inv.instance = null;
                        inv.container = parentInv.getContainerContext();
                        inv.transaction = null;
                        result.add(inv);
                    } else if (parentInv.getInvocationType() != ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
                        ComponentInvocation cpy = new ComponentInvocation();
                        cpy.componentId = parentInv.getComponentId();
                        cpy.setComponentInvocationType(parentInv.getInvocationType());
                        cpy.instance = parentInv.getInstance();
                        cpy.container = parentInv.getContainerContext();
                        cpy.transaction = parentInv.getTransaction();
                        result.add(cpy);
                    }
                }
                return result;
            }
        };
    }

    @Override
    public <T extends ComponentInvocation> void preInvoke(T invocation) throws InvocationException {
        List<RegisteredComponentInvocationHandler> setCIH;
        LOG.log(System.Logger.Level.DEBUG, "preInvoke(invocation={0})", invocation);
        InvocationArray invocations = (InvocationArray)this.frames.get();
        if (invocation.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP) {
            invocations.setInvocationAttribute(ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP);
            return;
        }
        int beforeSize = invocations.size();
        ComponentInvocation prevInv = beforeSize == 0 ? null : (ComponentInvocation)invocations.get(beforeSize - 1);
        ComponentInvocation.ComponentInvocationType invType = invocation.getInvocationType();
        if (this.invHandlers != null) {
            for (ComponentInvocationHandler handler : this.invHandlers) {
                handler.beforePreInvoke(invType, prevInv, invocation);
            }
        }
        if ((setCIH = this.regCompInvHandlerMap.get((Object)invType)) != null) {
            for (RegisteredComponentInvocationHandler element : setCIH) {
                element.getComponentInvocationHandler().beforePreInvoke(invType, prevInv, invocation);
            }
        }
        invocations.add(invocation);
        if (this.invHandlers != null) {
            for (ComponentInvocationHandler handler : this.invHandlers) {
                handler.afterPreInvoke(invType, prevInv, invocation);
            }
        }
        if (setCIH != null) {
            for (RegisteredComponentInvocationHandler element : setCIH) {
                element.getComponentInvocationHandler().afterPreInvoke(invType, prevInv, invocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ComponentInvocation> void postInvoke(T invocation) throws InvocationException {
        Object invType;
        LOG.log(System.Logger.Level.DEBUG, "postInvoke(invocation={0})", invocation);
        InvocationArray invocations = (InvocationArray)this.frames.get();
        if (invocation.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP) {
            invocations.setInvocationAttribute(ComponentInvocation.ComponentInvocationType.UN_INITIALIZED);
            return;
        }
        int beforeSize = invocations.size();
        if (beforeSize == 0) {
            throw new InvocationException("BeforeSize is null.");
        }
        ComponentInvocation prevInv = beforeSize > 1 ? (ComponentInvocation)invocations.get(beforeSize - 2) : null;
        ComponentInvocation curInv = (ComponentInvocation)invocations.get(beforeSize - 1);
        try {
            List<RegisteredComponentInvocationHandler> setCIH;
            invType = invocation.getInvocationType();
            if (this.invHandlers != null) {
                for (ComponentInvocationHandler handler : this.invHandlers) {
                    handler.beforePostInvoke((ComponentInvocation.ComponentInvocationType)((Object)invType), prevInv, curInv);
                }
            }
            if ((setCIH = this.regCompInvHandlerMap.get(invType)) != null) {
                for (RegisteredComponentInvocationHandler element : setCIH) {
                    element.getComponentInvocationHandler().beforePostInvoke((ComponentInvocation.ComponentInvocationType)((Object)invType), prevInv, curInv);
                }
            }
        }
        finally {
            List<RegisteredComponentInvocationHandler> handlers;
            invocations.remove(beforeSize - 1);
            if (this.invHandlers != null) {
                invType = this.invHandlers;
                int setCIH = ((ComponentInvocationHandler[])invType).length;
                for (int n = 0; n < setCIH; ++n) {
                    ComponentInvocationHandler handler = invType[n];
                    handler.afterPostInvoke(invocation.getInvocationType(), prevInv, invocation);
                }
            }
            if ((handlers = this.regCompInvHandlerMap.get(invType = invocation.getInvocationType())) != null) {
                for (RegisteredComponentInvocationHandler handler : handlers) {
                    handler.getComponentInvocationHandler().afterPostInvoke((ComponentInvocation.ComponentInvocationType)((Object)invType), prevInv, curInv);
                }
            }
        }
    }

    @Override
    public boolean isInvocationStackEmpty() {
        InvocationArray v = (InvocationArray)this.frames.get();
        return v == null || v.isEmpty();
    }

    @Override
    public <T extends ComponentInvocation> T getCurrentInvocation() {
        InvocationArray v = (InvocationArray)this.frames.get();
        int size = v.size();
        if (size == 0) {
            return null;
        }
        return (T)((ComponentInvocation)v.get(size - 1));
    }

    @Override
    public <T extends ComponentInvocation> T getPreviousInvocation() throws InvocationException {
        InvocationArray v = (InvocationArray)this.frames.get();
        int i = v.size();
        if (i < 2) {
            return null;
        }
        return (T)((ComponentInvocation)v.get(i - 2));
    }

    public List<ComponentInvocation> getAllInvocations() {
        return (List)this.frames.get();
    }

    @Override
    public void registerComponentInvocationHandler(ComponentInvocation.ComponentInvocationType type2, RegisteredComponentInvocationHandler handler) {
        List<RegisteredComponentInvocationHandler> setRegCompInvHandlers = this.regCompInvHandlerMap.get((Object)type2);
        if (setRegCompInvHandlers == null) {
            setRegCompInvHandlers = new ArrayList<RegisteredComponentInvocationHandler>();
            this.regCompInvHandlerMap.put(type2, setRegCompInvHandlers);
        }
        if (setRegCompInvHandlers.isEmpty()) {
            setRegCompInvHandlers.add(handler);
        }
    }

    @Override
    public void pushAppEnvironment(ApplicationEnvironment env) {
        Stack<ApplicationEnvironment> stack = this.applicationEnvironments.get();
        stack.push(env);
    }

    @Override
    public ApplicationEnvironment peekAppEnvironment() {
        Stack<ApplicationEnvironment> stack = this.applicationEnvironments.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    @Override
    public void popAppEnvironment() {
        Stack<ApplicationEnvironment> stack = this.applicationEnvironments.get();
        if (!stack.isEmpty()) {
            stack.pop();
        }
    }

    static class InvocationArray<T extends ComponentInvocation>
    extends ArrayList<T> {
        private static final long serialVersionUID = 1L;
        private ComponentInvocation.ComponentInvocationType invocationAttribute;

        InvocationArray() {
        }

        public void setInvocationAttribute(ComponentInvocation.ComponentInvocationType attribute) {
            this.invocationAttribute = attribute;
        }

        public ComponentInvocation.ComponentInvocationType getInvocationAttribute() {
            return this.invocationAttribute;
        }

        public boolean outsideStartup() {
            return this.getInvocationAttribute() != ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP;
        }
    }
}

