/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandAspect;
import org.glassfish.api.admin.CommandAspectFacade;
import org.glassfish.api.admin.CommandAspectImpl;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.WrappedAdminCommand;
import org.glassfish.hk2.api.ServiceLocator;

public final class CommandSupport {
    public static String getParamValue(AdminCommand command, String name) {
        return CommandSupport.getParamValue(command, name, String.class);
    }

    public static <T> T getParamValue(AdminCommand command, String name, Class<T> paramType) {
        AdminCommand unwrappedCommand = CommandSupport.getUnwrappedCommand(command);
        Class<?> commandClass = unwrappedCommand.getClass();
        for (Field field : commandClass.getDeclaredFields()) {
            Param param = field.getAnnotation(Param.class);
            if (param == null || !name.equals(CommandModel.getParamName(param, field))) continue;
            if (!paramType.isAssignableFrom(field.getType())) break;
            try {
                AccessController.doPrivileged(() -> {
                    field.setAccessible(true);
                    return null;
                });
                Object value = field.get(unwrappedCommand);
                return paramType.cast(value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unexpected error", e);
            }
        }
        return null;
    }

    public static void init(ServiceLocator serviceLocator, AdminCommand command, AdminCommandContext context, Job instance) {
        CommandSupport.processAspects(serviceLocator, command, (a, aspect, command1) -> {
            aspect.init(a, command1, context, instance);
            return command1;
        });
    }

    public static void done(ServiceLocator serviceLocator, AdminCommand command, Job instance, boolean isNotify) {
        CommandAspectFacade commandAspectFacade;
        CommandSupport.processAspects(serviceLocator, command, (a, aspect, command1) -> {
            aspect.done(a, command1, instance);
            return command1;
        });
        if (isNotify && (commandAspectFacade = serviceLocator.getService(CommandAspectFacade.class, new Annotation[0])) != null) {
            commandAspectFacade.done(command, instance);
        }
    }

    public static void done(ServiceLocator serviceLocator, AdminCommand command, Job instance) {
        CommandSupport.done(serviceLocator, command, instance, false);
    }

    public static AdminCommand createWrappers(ServiceLocator serviceLocator, CommandModel model, AdminCommand command, ActionReport report) {
        return CommandSupport.processAspects(serviceLocator, command, (a, cai, command1) -> cai.createWrapper(a, model, command1, report));
    }

    private static AdminCommand processAspects(ServiceLocator serviceLocator, AdminCommand command, Function function) {
        Annotation[] annotations;
        for (Annotation a : annotations = CommandSupport.getUnwrappedCommand(command).getClass().getAnnotations()) {
            CommandAspect ca = a.annotationType().getAnnotation(CommandAspect.class);
            if (ca == null) continue;
            CommandAspectImpl cai = (CommandAspectImpl)serviceLocator.getService((Type)ca.value(), new Annotation[0]);
            command = function.apply(a, cai, command);
        }
        return command;
    }

    private static AdminCommand getUnwrappedCommand(AdminCommand wrappedCommand) {
        if (wrappedCommand instanceof WrappedAdminCommand) {
            return ((WrappedAdminCommand)wrappedCommand).getWrappedCommand();
        }
        return wrappedCommand;
    }

    private static interface Function {
        public AdminCommand apply(Annotation var1, CommandAspectImpl<Annotation> var2, AdminCommand var3);
    }
}

