/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.payload;

import java.io.InputStream;
import java.util.Iterator;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.admin.Payload;

public class TextPayloadImpl {
    private static final String PAYLOAD_IMPL_CONTENT_TYPE = "text/";

    public static class Inbound
    extends PayloadImpl.Inbound {
        private final InputStream is;
        private final String contentType;

        public static Inbound newInstance(String messageContentType, InputStream is) {
            return new Inbound(messageContentType, is);
        }

        public static boolean supportsContentType(String contentType) {
            return TextPayloadImpl.PAYLOAD_IMPL_CONTENT_TYPE.regionMatches(true, 0, contentType, 0, TextPayloadImpl.PAYLOAD_IMPL_CONTENT_TYPE.length());
        }

        private Inbound(String contentType, InputStream is) {
            this.contentType = contentType;
            this.is = is;
        }

        @Override
        public Iterator<Payload.Part> parts() {
            return new Iterator<Payload.Part>(){
                private boolean hasReturnedReport = false;

                @Override
                public boolean hasNext() {
                    return !this.hasReturnedReport;
                }

                @Override
                public Payload.Part next() {
                    this.hasReturnedReport = true;
                    return new PayloadImpl.Part.Streamed(contentType, "report", null, is);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

