/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.jsonstructure;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.yasson.internal.jsonstructure.JsonArrayIterator;
import org.eclipse.yasson.internal.jsonstructure.JsonObjectIterator;
import org.eclipse.yasson.internal.jsonstructure.JsonStructureIterator;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class JsonStructureToParserAdapter
implements JsonParser {
    private Deque<JsonStructureIterator> iterators = new ArrayDeque<JsonStructureIterator>();
    private final JsonStructure rootStructure;

    public JsonStructureToParserAdapter(JsonStructure structure) {
        this.rootStructure = structure;
    }

    @Override
    public boolean hasNext() {
        return this.iterators.peek().hasNext();
    }

    @Override
    public JsonParser.Event next() {
        JsonStructureIterator current;
        JsonParser.Event next;
        if (this.iterators.isEmpty()) {
            if (this.rootStructure instanceof JsonObject) {
                this.iterators.push(new JsonObjectIterator((JsonObject)this.rootStructure));
                return JsonParser.Event.START_OBJECT;
            }
            if (this.rootStructure instanceof JsonArray) {
                this.iterators.push(new JsonArrayIterator((JsonArray)this.rootStructure));
                return JsonParser.Event.START_ARRAY;
            }
        }
        if ((next = (JsonParser.Event)((Object)(current = this.iterators.peek()).next())) == JsonParser.Event.START_OBJECT) {
            this.iterators.push(new JsonObjectIterator((JsonObject)current.getValue()));
        } else if (next == JsonParser.Event.START_ARRAY) {
            this.iterators.push(new JsonArrayIterator((JsonArray)current.getValue()));
        } else if (next == JsonParser.Event.END_OBJECT || next == JsonParser.Event.END_ARRAY) {
            this.iterators.pop();
        }
        return next;
    }

    @Override
    public String getString() {
        return this.iterators.peek().getString();
    }

    @Override
    public boolean isIntegralNumber() {
        return this.getJsonNumberValue().isIntegral();
    }

    @Override
    public int getInt() {
        return this.getJsonNumberValue().intValueExact();
    }

    @Override
    public long getLong() {
        return this.getJsonNumberValue().longValueExact();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.getJsonNumberValue().bigDecimalValue();
    }

    @Override
    public JsonObject getObject() {
        JsonStructureIterator current = this.iterators.peek();
        if (current instanceof JsonObjectIterator) {
            this.iterators.pop();
            return current.getValue().asJsonObject();
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Outside of object context"));
    }

    private JsonNumber getJsonNumberValue() {
        JsonStructureIterator iterator = this.iterators.peek();
        JsonValue value = iterator.getValue();
        if (value.getValueType() != JsonValue.ValueType.NUMBER) {
            throw iterator.createIncompatibleValueError();
        }
        return (JsonNumber)value;
    }

    @Override
    public JsonLocation getLocation() {
        throw new JsonbException("Operation not supported");
    }

    @Override
    public void skipArray() {
        JsonStructureIterator current;
        if (!this.iterators.isEmpty() && (current = this.iterators.peek()) instanceof JsonArrayIterator) {
            this.iterators.pop();
        }
    }

    @Override
    public void skipObject() {
        JsonStructureIterator current;
        if (!this.iterators.isEmpty() && (current = this.iterators.peek()) instanceof JsonObjectIterator) {
            this.iterators.pop();
        }
    }

    @Override
    public void close() {
    }
}

