/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;

public class TypeDefinition
extends DatabaseObjectDefinition {
    protected List<FieldDefinition> fields = new Vector<FieldDefinition>();

    public void addField(String fieldName, Class<?> type2) {
        this.addField(new FieldDefinition(fieldName, type2));
    }

    public void addField(String fieldName, Class<?> type2, int fieldSize) {
        this.addField(new FieldDefinition(fieldName, type2, fieldSize));
    }

    public void addField(String fieldName, Class<?> type2, int fieldSize, int fieldSubSize) {
        this.addField(new FieldDefinition(fieldName, type2, fieldSize, fieldSubSize));
    }

    public void addField(String fieldName, String typeName) {
        this.addField(new FieldDefinition(fieldName, typeName));
    }

    public void addField(FieldDefinition field) {
        this.getFields().add(field);
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("CREATE TYPE " + this.getFullName() + " AS OBJECT (");
            List<FieldDefinition> fields = this.getFields();
            for (int i = 0; i < this.getFields().size(); ++i) {
                FieldDefinition field = fields.get(i);
                field.appendTypeString(writer, session);
                if (i + 1 >= fields.size()) continue;
                writer.write(", ");
            }
            writer.write(")");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TYPE " + this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public List<FieldDefinition> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldDefinition> fields) {
        this.fields = fields;
    }
}

