/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.sessions.Login;

public class ConnectionPolicy
implements Cloneable,
Serializable {
    protected Login login;
    protected String poolName;
    protected boolean isLazy;
    protected ExclusiveMode exclusiveMode;
    protected Map properties;

    public ConnectionPolicy() {
        this.isLazy = true;
        this.exclusiveMode = ExclusiveMode.Transactional;
    }

    public ConnectionPolicy(String poolName) {
        this.isLazy = true;
        this.poolName = poolName;
        this.exclusiveMode = ExclusiveMode.Transactional;
    }

    public ConnectionPolicy(Login login) {
        this.isLazy = false;
        this.login = login;
        this.exclusiveMode = ExclusiveMode.Transactional;
    }

    public Object clone() {
        try {
            ConnectionPolicy clone = (ConnectionPolicy)super.clone();
            if (clone.hasLogin()) {
                clone.setLogin(clone.getLogin().clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void dontUseLazyConnection() {
        this.setIsLazy(false);
    }

    public Login getLogin() {
        return this.login;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public Object getProperty(Object object) {
        if (this.hasProperties()) {
            return this.getProperties().get(object);
        }
        return null;
    }

    public boolean hasLogin() {
        return this.login != null;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public boolean isExclusiveIsolated() {
        return this.exclusiveMode == ExclusiveMode.Isolated;
    }

    public boolean isExclusiveAlways() {
        return this.exclusiveMode == ExclusiveMode.Always;
    }

    public boolean isExclusive() {
        return this.isExclusiveIsolated() || this.isExclusiveAlways();
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public boolean isPooled() {
        return this.poolName != null;
    }

    public boolean isUserDefinedConnection() {
        return this.poolName == null;
    }

    public Object removeProperty(Object key) {
        if (this.hasProperties()) {
            return this.getProperties().remove(key);
        }
        return null;
    }

    public void setIsLazy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setProperty(Object key, Object property) {
        this.getProperties().put(key, property);
    }

    public ExclusiveMode getExclusiveMode() {
        return this.exclusiveMode;
    }

    public void setExclusiveMode(ExclusiveMode exclusiveMode) {
        this.exclusiveMode = exclusiveMode == null ? ExclusiveMode.Transactional : exclusiveMode;
    }

    public String toString() {
        Object type2 = "";
        type2 = this.isPooled() ? "(" + ToStringLocalization.buildMessage("pooled", null) + ": " + this.getPoolName() : "(" + ToStringLocalization.buildMessage("login", null) + ": " + this.getLogin();
        type2 = this.isLazy() ? (String)type2 + "," + ToStringLocalization.buildMessage("lazy", null) + ")" : (String)type2 + "," + ToStringLocalization.buildMessage("non-lazy", null) + ")";
        return Helper.getShortClassName(this.getClass()) + (String)type2;
    }

    public void useLazyConnection() {
        this.setIsLazy(true);
    }

    public static enum ExclusiveMode {
        Transactional,
        Isolated,
        Always;

    }
}

