/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.databaseaccess.SimpleAppendCallCustomParameter;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.queries.Call;

public class Oracle8Platform
extends OraclePlatform {
    protected boolean usesLocatorForLOBWrite = true;
    protected int lobValueLimits = 0;

    @Override
    protected Hashtable<Class<?>, FieldTypeDefinition> buildFieldTypes() {
        Hashtable<Class<?>, FieldTypeDefinition> fieldTypeMapping = super.buildFieldTypes();
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("CLOB", false));
        return fieldTypeMapping;
    }

    @Override
    public void copyInto(Platform platform) {
        super.copyInto(platform);
        if (!(platform instanceof Oracle8Platform)) {
            return;
        }
        Oracle8Platform oracle8Platform = (Oracle8Platform)platform;
        oracle8Platform.setShouldUseLocatorForLOBWrite(this.shouldUseLocatorForLOBWrite());
        oracle8Platform.setLobValueLimits(this.getLobValueLimits());
    }

    @Override
    public boolean shouldUseCustomModifyForCall(DatabaseField field) {
        Class<?> type2;
        if (this.shouldUseLocatorForLOBWrite() && (ClassConstants.BLOB.equals(type2 = field.getType()) || ClassConstants.CLOB.equals(type2))) {
            return true;
        }
        return super.shouldUseCustomModifyForCall(field);
    }

    protected boolean lobValueExceedsLimit(Object value) {
        if (value == null) {
            return false;
        }
        int limit = this.getLobValueLimits();
        if (value instanceof byte[]) {
            return ((byte[])value).length >= limit;
        }
        if (value instanceof String) {
            return ((String)value).length() >= limit;
        }
        return false;
    }

    @Override
    public Connection getConnection(AbstractSession session, Connection connection) {
        if (session.getServerPlatform() != null && session.getLogin().shouldUseExternalConnectionPooling()) {
            return session.getServerPlatform().unwrapConnection(connection);
        }
        return connection;
    }

    @Override
    public Object getCustomModifyValueForCall(Call call, Object value, DatabaseField field, boolean shouldBind) {
        Class<?> type2 = field.getType();
        if (ClassConstants.BLOB.equals(type2) || ClassConstants.CLOB.equals(type2)) {
            if (value == null) {
                return null;
            }
            Object lobValue = this.convertToDatabaseType(value);
            if (this.shouldUseLocatorForLOBWrite() & this.lobValueExceedsLimit(lobValue)) {
                ((DatabaseCall)call).addContext(field, lobValue);
                lobValue = ClassConstants.BLOB.equals(type2) ? (shouldBind ? (Object)new byte[1] : new SimpleAppendCallCustomParameter("empty_blob()")) : (shouldBind ? new String(" ") : new SimpleAppendCallCustomParameter("empty_clob()"));
            }
            return lobValue;
        }
        return super.getCustomModifyValueForCall(call, value, field, shouldBind);
    }

    @Override
    public void writeLOB(DatabaseField field, Object value, ResultSet resultSet, AbstractSession session) throws SQLException {
        if (this.isBlob(field.getType())) {
            Blob blob = (Blob)resultSet.getObject(field.getName());
            blob.setBytes(1L, (byte[])value);
            session.log(1, "sql", "write_BLOB", blob.length(), field.getName());
        } else if (this.isClob(field.getType())) {
            Clob clob = (Clob)resultSet.getObject(field.getName());
            clob.setString(1L, (String)value);
            session.log(1, "sql", "write_CLOB", clob.length(), field.getName());
        }
    }

    protected boolean isBlob(Class<?> type2) {
        return ClassConstants.BLOB.equals(type2);
    }

    protected boolean isClob(Class<?> type2) {
        return ClassConstants.CLOB.equals(type2);
    }

    @Override
    public boolean isNativeConnectionRequiredForLobLocator() {
        return true;
    }

    public void setShouldUseLocatorForLOBWrite(boolean usesLocatorForLOBWrite) {
        this.usesLocatorForLOBWrite = usesLocatorForLOBWrite;
    }

    public boolean shouldUseLocatorForLOBWrite() {
        return this.usesLocatorForLOBWrite;
    }

    public int getLobValueLimits() {
        return this.lobValueLimits;
    }

    public void setLobValueLimits(int lobValueLimits) {
        this.lobValueLimits = lobValueLimits;
    }
}

