/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.AbstractSemanticValidator;
import org.eclipse.persistence.jpa.jpql.AbstractValidator;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.ITypeHelper;
import org.eclipse.persistence.jpa.jpql.JPAVersion;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.LiteralVisitor;
import org.eclipse.persistence.jpa.jpql.SemanticValidatorHelper;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EncapsulatedIdentificationVariableExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.tools.DefaultLiteralVisitor;
import org.eclipse.persistence.jpa.jpql.tools.GenericSemanticValidatorHelper;
import org.eclipse.persistence.jpa.jpql.tools.JPQLQueryContext;

public class DefaultSemanticValidator
extends AbstractSemanticValidator {
    protected NullValueVisitor nullValueVisitor;
    protected UpdateClauseAbstractSchemaNameFinder updateClauseAbstractSchemaNameFinder;
    protected Map<Class<? extends TypeValidator>, TypeValidator> validators;

    public DefaultSemanticValidator(JPQLQueryContext queryContext) {
        super(new GenericSemanticValidatorHelper(queryContext));
    }

    public DefaultSemanticValidator(SemanticValidatorHelper helper) {
        super(helper);
    }

    protected boolean areTypesEquivalent(Object[] typeDeclarations1, Object[] typeDeclarations2) {
        if (typeDeclarations1.length == 0 && typeDeclarations2.length == 0) {
            return true;
        }
        if (typeDeclarations1.length != typeDeclarations2.length) {
            return false;
        }
        int index = typeDeclarations1.length;
        while (--index >= 0) {
            if (this.helper.isTypeDeclarationAssignableTo(typeDeclarations1[index], typeDeclarations2[index])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected LiteralVisitor buildLiteralVisitor() {
        return new DefaultLiteralVisitor();
    }

    @Override
    protected AbstractValidator.OwningClauseVisitor buildOwningClauseVisitor() {
        return new AbstractValidator.OwningClauseVisitor();
    }

    protected ResultVariableInOrderByVisitor buildResultVariableInOrderByVisitor() {
        return new ResultVariableInOrderByVisitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractSchemaName findAbstractSchemaName(UpdateItem expression) {
        UpdateClauseAbstractSchemaNameFinder visitor = this.getUpdateClauseAbstractSchemaNameFinder();
        try {
            expression.accept(visitor);
            AbstractSchemaName abstractSchemaName = visitor.expression;
            return abstractSchemaName;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected NullValueVisitor getNullValueVisitor() {
        if (this.nullValueVisitor == null) {
            this.nullValueVisitor = new NullValueVisitor();
        }
        return this.nullValueVisitor;
    }

    protected Object getType(Expression expression) {
        return this.helper.getType(expression);
    }

    protected ITypeHelper getTypeHelper() {
        return this.helper.getTypeHelper();
    }

    protected UpdateClauseAbstractSchemaNameFinder getUpdateClauseAbstractSchemaNameFinder() {
        if (this.updateClauseAbstractSchemaNameFinder == null) {
            this.updateClauseAbstractSchemaNameFinder = new UpdateClauseAbstractSchemaNameFinder();
        }
        return this.updateClauseAbstractSchemaNameFinder;
    }

    protected TypeValidator getValidator(Class<? extends TypeValidator> validatorClass) {
        TypeValidator validator = this.validators.get(validatorClass);
        if (validator == null) {
            try {
                Constructor<? extends TypeValidator> constructor = validatorClass.getDeclaredConstructor(DefaultSemanticValidator.class);
                if (!constructor.canAccess(null)) {
                    AccessController.doPrivileged(() -> {
                        constructor.setAccessible(true);
                        return null;
                    });
                }
                validator = constructor.newInstance(this);
                this.validators.put(validatorClass, validator);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return validator;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.validators = new HashMap<Class<? extends TypeValidator>, TypeValidator>();
    }

    protected boolean isBooleanType(Expression expression) {
        return this.isValid(expression, BooleanTypeValidator.class);
    }

    protected boolean isComparisonEquivalentType(Expression expression1, Expression expression2) {
        Object type1 = this.helper.getType(expression1);
        Object type2 = this.helper.getType(expression2);
        ITypeHelper typeHelper = this.getTypeHelper();
        return type1 == type2 || !this.helper.isTypeResolvable(type1) || !this.helper.isTypeResolvable(type2) || typeHelper.isNumericType(type1) && typeHelper.isNumericType(type2) || typeHelper.isDateType(type1) && typeHelper.isDateType(type2) || this.helper.isAssignableTo(type1, type2) || this.helper.isAssignableTo(type2, type1);
    }

    protected boolean isEquivalentBetweenType(Expression expression1, Expression expression2) {
        Object type1 = this.helper.getType(expression1);
        Object type2 = this.helper.getType(expression2);
        if (!this.helper.isTypeResolvable(type1) || !this.helper.isTypeResolvable(type2)) {
            return true;
        }
        ITypeHelper typeHelper = this.getTypeHelper();
        if (type1 == type2) {
            return typeHelper.isNumericType(type1) || typeHelper.isStringType(type1) || typeHelper.isDateType(type1);
        }
        return typeHelper.isNumericType(type1) && typeHelper.isNumericType(type2) || typeHelper.isStringType(type1) && typeHelper.isStringType(type2) || typeHelper.isDateType(type1) && typeHelper.isDateType(type2);
    }

    protected boolean isIntegralType(Expression expression) {
        if (this.isNumericType(expression)) {
            ITypeHelper typeHelper = this.getTypeHelper();
            Object type2 = this.helper.getType(expression);
            return type2 == typeHelper.unknownType() || typeHelper.isIntegralType(type2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isNullValue(Expression expression) {
        NullValueVisitor visitor = this.getNullValueVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.valid;
            return bl;
        }
        finally {
            visitor.valid = false;
        }
    }

    protected boolean isNumericType(Expression expression) {
        return this.isValid(expression, NumericTypeValidator.class);
    }

    protected boolean isStringType(Expression expression) {
        return this.isValid(expression, StringTypeValidator.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isValid(Expression expression, Class<? extends TypeValidator> validatorClass) {
        TypeValidator validator = this.getValidator(validatorClass);
        try {
            expression.accept(validator);
            boolean bl = validator.valid;
            return bl;
        }
        finally {
            validator.valid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isValidWithFindQueryBNF(AbstractExpression expression, String queryBNF) {
        AbstractValidator.JPQLQueryBNFValidator validator = this.getExpressionValidator(queryBNF);
        try {
            JPQLQueryBNF childQueryBNF = expression.getParent().findQueryBNF(expression);
            validator.validate(childQueryBNF);
            boolean bl = validator.isValid();
            return bl;
        }
        finally {
            validator.dispose();
        }
    }

    @Override
    protected AbstractSemanticValidator.PathType selectClausePathExpressionPathType() {
        return AbstractSemanticValidator.PathType.ANY_FIELD;
    }

    @Override
    protected boolean validateAbsExpression(AbsExpression expression) {
        boolean valid = super.validateAbsExpression(expression);
        if (valid) {
            valid = this.validateNumericType(expression.getExpression(), "ABS_EXPRESSION_INVALID_NUMERIC_EXPRESSION");
        }
        return valid;
    }

    @Override
    protected int validateArithmeticExpression(ArithmeticExpression expression, String leftExpressionWrongTypeMessageKey, String rightExpressionWrongTypeMessageKey) {
        boolean valid;
        int result = super.validateArithmeticExpression(expression, leftExpressionWrongTypeMessageKey, rightExpressionWrongTypeMessageKey);
        if (this.isValid(result, 0)) {
            valid = this.validateNumericType(expression.getLeftExpression(), leftExpressionWrongTypeMessageKey);
            this.updateStatus(result, 0, valid);
        }
        valid = this.validateNumericType(expression.getRightExpression(), rightExpressionWrongTypeMessageKey);
        this.updateStatus(result, 1, valid);
        return result;
    }

    @Override
    protected boolean validateAvgFunction(AvgFunction expression) {
        boolean valid = super.validateAvgFunction(expression);
        if (valid) {
            valid = this.validateNumericType(expression.getExpression(), "AVG_FUNCTION_INVALID_NUMERIC_EXPRESSION");
        }
        return valid;
    }

    @Override
    protected int validateBetweenExpression(BetweenExpression expression) {
        int result = super.validateBetweenExpression(expression);
        if (this.isValid(result, 1) && this.isValid(result, 2) && !this.isEquivalentBetweenType(expression.getExpression(), expression.getLowerBoundExpression()) || !this.isEquivalentBetweenType(expression.getExpression(), expression.getUpperBoundExpression())) {
            this.addProblem(expression, "BETWEEN_EXPRESSION_WRONG_TYPE");
            this.updateStatus(result, 1, false);
            this.updateStatus(result, 2, false);
        }
        return result;
    }

    protected boolean validateBooleanType(Expression expression, String messageKey) {
        if (this.isValid(expression, "boolean_primary") && !this.isBooleanType(expression)) {
            this.addProblem(expression, messageKey);
            return false;
        }
        return true;
    }

    @Override
    protected int validateCollectionMemberExpression(CollectionMemberExpression expression) {
        Expression entityExpression;
        Object type2;
        int result = super.validateCollectionMemberExpression(expression);
        if (this.isValid(result, 0) && expression.hasEntityExpression() && this.helper.getEmbeddable(type2 = this.helper.getType(entityExpression = expression.getEntityExpression())) != null) {
            this.addProblem(entityExpression, "COLLECTION_MEMBER_EXPRESSION_EMBEDDABLE");
            this.updateStatus(result, 0, false);
        }
        return result;
    }

    @Override
    protected boolean validateComparisonExpression(ComparisonExpression expression) {
        boolean valid = super.validateComparisonExpression(expression);
        if (valid && expression.hasLeftExpression() && expression.hasRightExpression() && !this.isComparisonEquivalentType(expression.getLeftExpression(), expression.getRightExpression())) {
            this.addProblem(expression, "COMPARISON_EXPRESSION_WRONG_COMPARISON_TYPE");
            valid = false;
        }
        return valid;
    }

    @Override
    protected boolean validateConcatExpression(ConcatExpression expression) {
        boolean result = super.validateConcatExpression(expression);
        if (expression.hasExpression()) {
            int index = 0;
            for (Expression child : this.getChildren(expression.getExpression())) {
                if (index != 0 || result) {
                    result &= this.validateStringType(child, "CONCAT_EXPRESSION_EXPRESSION_WRONG_TYPE");
                }
                ++index;
            }
        }
        return result;
    }

    @Override
    protected void validateConstructorExpression(ConstructorExpression expression) {
        super.validateConstructorExpression(expression);
        String className = expression.getClassName();
        if (ExpressionTools.stringIsNotEmpty(className)) {
            Object type2 = this.helper.getType(className);
            if (!this.helper.isTypeResolvable(type2)) {
                int startPosition = this.position(expression) + 4;
                int endPosition = startPosition + className.length();
                this.addProblem((Expression)expression, startPosition, endPosition, "CONSTRUCTOR_EXPRESSION_UNKNOWN_TYPE", className);
            } else if (expression.hasLeftParenthesis() && expression.hasConstructorItems()) {
                Expression constructorItems = expression.getConstructorItems();
                List<Expression> children = this.getChildren(constructorItems);
                Object[] typeDeclarations = null;
                boolean constructorFound = false;
                for (Object constructor : this.helper.getConstructors(type2)) {
                    Object[] parameterTypeDeclarations = this.helper.getMethodParameterTypeDeclarations(constructor);
                    if (children.size() != parameterTypeDeclarations.length) continue;
                    if (parameterTypeDeclarations.length == 0) {
                        constructor = true;
                        continue;
                    }
                    if (typeDeclarations == null) {
                        typeDeclarations = new Object[children.size()];
                        int index = children.size();
                        while (--index >= 0) {
                            typeDeclarations[index] = this.helper.getTypeDeclaration(children.get(index));
                        }
                    }
                    if (constructorFound = this.areTypesEquivalent(parameterTypeDeclarations, typeDeclarations)) break;
                }
                if (!constructorFound) {
                    int startPosition = this.position(expression) + 4;
                    int endPosition = startPosition + className.length();
                    this.addProblem((Expression)expression, startPosition, endPosition, "CONSTRUCTOR_EXPRESSION_UNDEFINED_CONSTRUCTOR", new String[0]);
                }
            }
        }
    }

    @Override
    protected void validateCountFunction(CountFunction expression) {
        Expression childExpression;
        Object type2;
        super.validateCountFunction(expression);
        if (expression.hasExpression() && expression.hasDistinct() && this.helper.getEmbeddable(type2 = this.helper.getType(childExpression = expression.getExpression())) != null) {
            int distinctLength = "DISTINCT".length() + 1;
            int startIndex = this.position(childExpression) - distinctLength;
            int endIndex = startIndex + this.length(childExpression) + distinctLength;
            this.addProblem((Expression)expression, startIndex, endIndex, "COUNT_FUNCTION_DISTINCT_EMBEDDABLE", new String[0]);
        }
    }

    @Override
    protected void validateEntryExpression(EntryExpression expression) {
        this.validateMapIdentificationVariable(expression);
        super.validateEntryExpression(expression);
    }

    @Override
    protected boolean validateIdentificationVariable(IdentificationVariable expression, String variable) {
        boolean valid = super.validateIdentificationVariable(expression, variable);
        for (String entityName : this.helper.entityNames()) {
            if (!variable.equalsIgnoreCase(entityName) || this.isValidWithFindQueryBNF(expression, "literal")) continue;
            int startIndex = this.position(expression);
            int endIndex = startIndex + variable.length();
            this.addProblem((Expression)expression, startIndex, endIndex, "IDENTIFICATION_VARIABLE_ENTITY_NAME", new String[0]);
            valid = false;
            break;
        }
        return valid;
    }

    protected boolean validateIntegralType(Expression expression, String queryBNF, String messageKey) {
        if (this.isValid(expression, queryBNF) && !this.isIntegralType(expression)) {
            this.addProblem(expression, messageKey);
            return false;
        }
        return true;
    }

    @Override
    protected void validateKeyExpression(KeyExpression expression) {
        this.validateMapIdentificationVariable(expression);
        super.validateKeyExpression(expression);
    }

    @Override
    protected boolean validateLengthExpression(LengthExpression expression) {
        boolean valid = super.validateLengthExpression(expression);
        if (valid) {
            valid = this.validateStringType(expression.getExpression(), "LENGTH_EXPRESSION_WRONG_TYPE");
        }
        return valid;
    }

    @Override
    protected int validateLocateExpression(LocateExpression expression) {
        boolean valid;
        int result = super.validateLocateExpression(expression);
        if (this.isValid(result, 0)) {
            valid = this.validateStringType(expression.getFirstExpression(), "LOCATE_EXPRESSION_FIRST_EXPRESSION_WRONG_TYPE");
            this.updateStatus(result, 0, valid);
        }
        if (this.isValid(result, 1)) {
            valid = this.validateStringType(expression.getSecondExpression(), "LOCATE_EXPRESSION_SECOND_EXPRESSION_WRONG_TYPE");
            this.updateStatus(result, 1, valid);
        }
        if (this.isValid(result, 2)) {
            valid = this.validateNumericType(expression.getThirdExpression(), "LOCATE_EXPRESSION_THIRD_EXPRESSION_WRONG_TYPE");
            this.updateStatus(result, 2, valid);
        }
        return result;
    }

    @Override
    protected boolean validateLowerExpression(LowerExpression expression) {
        boolean valid = super.validateLowerExpression(expression);
        if (valid) {
            valid = this.validateStringType(expression.getExpression(), "LOWER_EXPRESSION_WRONG_TYPE");
        }
        return valid;
    }

    protected void validateMapIdentificationVariable(EncapsulatedIdentificationVariableExpression expression) {
        Expression childExpression;
        String variableName;
        if (expression.hasExpression() && ExpressionTools.stringIsNotEmpty(variableName = this.literal(childExpression = expression.getExpression(), LiteralType.IDENTIFICATION_VARIABLE))) {
            Object typeDeclaration = this.helper.getTypeDeclaration(childExpression);
            Object type2 = this.helper.getType(typeDeclaration);
            if (!this.getTypeHelper().isMapType(type2)) {
                this.addProblem(childExpression, "ENCAPSULATED_IDENTIFICATION_VARIABLE_EXPRESSION_NOT_MAP_VALUED", expression.getIdentifier());
            }
        }
    }

    @Override
    protected int validateModExpression(ModExpression expression) {
        boolean valid;
        int result = super.validateModExpression(expression);
        if (this.isValid(result, 0)) {
            valid = this.validateIntegralType(expression.getFirstExpression(), expression.parameterExpressionBNF(0), "MOD_EXPRESSION_FIRST_EXPRESSION_WRONG_TYPE");
            this.updateStatus(result, 0, valid);
        }
        if (this.isValid(result, 1)) {
            valid = this.validateIntegralType(expression.getSecondExpression(), expression.parameterExpressionBNF(1), "MOD_EXPRESSION_SECOND_EXPRESSION_WRONG_TYPE");
            this.updateStatus(result, 1, valid);
        }
        return result;
    }

    @Override
    protected void validateNotExpression(NotExpression expression) {
        super.validateNotExpression(expression);
        this.validateBooleanType(expression.getExpression(), "NOT_EXPRESSION_WRONG_TYPE");
    }

    @Override
    protected void validateNullComparisonExpression(NullComparisonExpression expression) {
        Object type2;
        super.validateNullComparisonExpression(expression);
        StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(expression.getExpression());
        if (pathExpression != null && this.helper.getEmbeddable(type2 = this.helper.getType(pathExpression)) != null) {
            this.addProblem((Expression)pathExpression, "NULL_COMPARISON_EXPRESSION_INVALID_TYPE", pathExpression.toParsedText());
        }
    }

    protected boolean validateNumericType(Expression expression, String messageKey) {
        if (this.isValid(expression, "simple_arithmetic_expression") && !this.isNumericType(expression)) {
            this.addProblem(expression, messageKey);
            return false;
        }
        return true;
    }

    @Override
    protected boolean validateSqrtExpression(SqrtExpression expression) {
        boolean valid = super.validateSqrtExpression(expression);
        if (valid) {
            valid = this.validateNumericType(expression.getExpression(), "SQRT_EXPRESSION_WRONG_TYPE");
        }
        return valid;
    }

    protected boolean validateStringType(Expression expression, String messageKey) {
        if (this.isValid(expression, "string_primary") && !this.isStringType(expression)) {
            this.addProblem(expression, messageKey, expression.toParsedText());
            return false;
        }
        return true;
    }

    @Override
    protected int validateSubstringExpression(SubstringExpression expression) {
        boolean valid;
        int result = super.validateSubstringExpression(expression);
        if (this.isValid(result, 0)) {
            valid = this.validateStringType(expression.getFirstExpression(), "SUBSTRING_EXPRESSION_FIRST_EXPRESSION_WRONG_TYPE");
            this.updateStatus(result, 0, valid);
        }
        if (this.isValid(result, 1)) {
            valid = this.validateIntegralType(expression.getSecondExpression(), expression.getParameterQueryBNFId(1), "SUBSTRING_EXPRESSION_SECOND_EXPRESSION_WRONG_TYPE");
            this.updateStatus(result, 1, valid);
        }
        if (this.isValid(result, 2) && this.getJPAVersion().isNewerThanOrEqual(JPAVersion.VERSION_2_0)) {
            valid = this.validateIntegralType(expression.getThirdExpression(), expression.getParameterQueryBNFId(2), "SUBSTRING_EXPRESSION_THIRD_EXPRESSION_WRONG_TYPE");
            this.updateStatus(result, 2, valid);
        }
        return result;
    }

    @Override
    protected boolean validateSumFunction(SumFunction expression) {
        boolean valid = super.validateSumFunction(expression);
        if (valid) {
            valid = this.validateNumericType(expression.getExpression(), "SUM_FUNCTION_WRONG_TYPE");
        }
        return valid;
    }

    @Override
    protected boolean validateUpdateItem(UpdateItem expression) {
        boolean valid = super.validateUpdateItem(expression);
        if (valid) {
            Object entity;
            String entityName;
            AbstractSchemaName abstractSchemaName = this.findAbstractSchemaName(expression);
            String string = entityName = abstractSchemaName != null ? abstractSchemaName.getText() : null;
            if (ExpressionTools.stringIsNotEmpty(entityName) && (entity = this.helper.getEntityNamed(entityName)) != null && expression.hasSpaceAfterStateFieldPathExpression()) {
                String stateFieldValue;
                StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(expression.getStateFieldPathExpression());
                String string2 = stateFieldValue = pathExpression != null ? pathExpression.toParsedText() : null;
                if (ExpressionTools.stringIsNotEmpty(stateFieldValue)) {
                    if (stateFieldValue.indexOf(46) == -1) {
                        Object mapping = this.helper.getMappingNamed(entity, stateFieldValue);
                        if (mapping == null) {
                            this.addProblem((Expression)pathExpression, "UPDATE_ITEM_NOT_RESOLVABLE", stateFieldValue);
                        } else {
                            this.validateUpdateItemTypes(expression, this.helper.getMappingType(mapping));
                        }
                    } else {
                        Object type2 = this.helper.getType(pathExpression);
                        if (!this.helper.isTypeResolvable(type2)) {
                            this.addProblem((Expression)pathExpression, "UPDATE_ITEM_NOT_RESOLVABLE", stateFieldValue);
                        } else {
                            this.validateUpdateItemTypes(expression, type2);
                        }
                    }
                }
            }
        }
        return valid;
    }

    protected void validateUpdateItemTypes(UpdateItem expression, Object type2) {
        if (expression.hasNewValue()) {
            Expression newValue = expression.getNewValue();
            ITypeHelper typeHelper = this.getTypeHelper();
            boolean nullValue = this.isNullValue(newValue);
            if (nullValue) {
                if (typeHelper.isPrimitiveType(type2)) {
                    this.addProblem(expression, "UPDATE_ITEM_NULL_NOT_ASSIGNABLE_TO_PRIMITIVE");
                }
                return;
            }
            Object newValueType = this.getType(newValue);
            if (!this.helper.isTypeResolvable(newValueType) || typeHelper.isDateType(type2) && typeHelper.isDateType(newValueType) || (typeHelper.isNumericType(type2) || typeHelper.isPrimitiveType(type2)) && (typeHelper.isNumericType(newValueType) || typeHelper.isPrimitiveType(newValueType))) {
                return;
            }
            if (!this.helper.isAssignableTo(newValueType, type2)) {
                this.addProblem((Expression)expression, "UPDATE_ITEM_NOT_ASSIGNABLE", this.helper.getTypeName(newValueType), this.helper.getTypeName(type2));
            }
        }
    }

    @Override
    protected boolean validateUpperExpression(UpperExpression expression) {
        boolean valid = super.validateUpperExpression(expression);
        if (valid) {
            valid = this.validateStringType(expression.getExpression(), "UPPER_EXPRESSION_WRONG_TYPE");
        }
        return valid;
    }

    @Override
    protected void validateValueExpression(ValueExpression expression) {
        this.validateMapIdentificationVariable(expression);
        super.validateValueExpression(expression);
    }

    protected static class UpdateClauseAbstractSchemaNameFinder
    extends AbstractExpressionVisitor {
        protected AbstractSchemaName expression;

        protected UpdateClauseAbstractSchemaNameFinder() {
        }

        @Override
        public void visit(AbstractSchemaName expression) {
            this.expression = expression;
        }

        @Override
        public void visit(CollectionExpression expression) {
            expression.getParent().accept(this);
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            expression.getRootObject().accept(this);
        }

        @Override
        public void visit(UpdateClause expression) {
            expression.getRangeVariableDeclaration().accept(this);
        }

        @Override
        public void visit(UpdateItem expression) {
            expression.getParent().accept(this);
        }
    }

    protected abstract class TypeValidator
    extends AbstractExpressionVisitor {
        protected boolean valid;

        protected TypeValidator() {
        }

        protected abstract boolean isRightType(Object var1);

        @Override
        public final void visit(CaseExpression expression) {
            Object type2 = DefaultSemanticValidator.this.getType(expression);
            this.valid = this.isRightType(type2);
        }

        @Override
        public final void visit(CoalesceExpression expression) {
            Object type2 = DefaultSemanticValidator.this.getType(expression);
            this.valid = this.isRightType(type2);
        }

        @Override
        public final void visit(InputParameter expression) {
            this.valid = true;
        }

        @Override
        public void visit(NullExpression expression) {
            this.valid = true;
        }

        @Override
        public final void visit(NullIfExpression expression) {
            expression.getFirstExpression().accept(this);
        }

        @Override
        public final void visit(StateFieldPathExpression expression) {
            Object type2 = DefaultSemanticValidator.this.getType(expression);
            this.valid = this.isRightType(type2);
        }

        @Override
        public final void visit(SubExpression expression) {
            expression.getExpression().accept(this);
        }
    }

    protected class StringTypeValidator
    extends TypeValidator {
        protected StringTypeValidator() {
        }

        @Override
        protected boolean isRightType(Object type2) {
            return DefaultSemanticValidator.this.getTypeHelper().isStringType(type2);
        }

        @Override
        public void visit(ConcatExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(LowerExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(StringLiteral expression) {
            this.valid = true;
        }

        @Override
        public void visit(SubstringExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(TrimExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(UpperExpression expression) {
            this.valid = true;
        }
    }

    protected static class ResultVariableInOrderByVisitor
    extends AbstractExpressionVisitor {
        public boolean result;

        protected ResultVariableInOrderByVisitor() {
        }

        @Override
        public void visit(IdentificationVariable expression) {
            expression.getParent().accept(this);
        }

        @Override
        public void visit(OrderByClause expression) {
            this.result = true;
        }

        @Override
        public void visit(OrderByItem expression) {
            expression.getParent().accept(this);
        }
    }

    protected class NumericTypeValidator
    extends TypeValidator {
        protected NumericTypeValidator() {
        }

        @Override
        protected boolean isRightType(Object type2) {
            return DefaultSemanticValidator.this.getTypeHelper().isNumericType(type2);
        }

        @Override
        public void visit(AbsExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(AdditionExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(ArithmeticFactor expression) {
            this.valid = true;
        }

        @Override
        public void visit(AvgFunction expression) {
            this.valid = true;
        }

        @Override
        public void visit(CountFunction expression) {
            this.valid = true;
        }

        @Override
        public void visit(DivisionExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(IndexExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(LengthExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(LocateExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(MaxFunction expression) {
            this.valid = true;
        }

        @Override
        public void visit(MinFunction expression) {
            this.valid = true;
        }

        @Override
        public void visit(ModExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(MultiplicationExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(NumericLiteral expression) {
            this.valid = true;
        }

        @Override
        public void visit(SizeExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(SqrtExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(SubtractionExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(SumFunction expression) {
            this.valid = true;
        }
    }

    protected static class NullValueVisitor
    extends AbstractExpressionVisitor {
        protected boolean valid;

        protected NullValueVisitor() {
        }

        @Override
        public void visit(KeywordExpression expression) {
            this.valid = expression.getText() == "NULL";
        }
    }

    protected class BooleanTypeValidator
    extends TypeValidator {
        protected BooleanTypeValidator() {
        }

        @Override
        protected boolean isRightType(Object type2) {
            return DefaultSemanticValidator.this.getTypeHelper().isBooleanType(type2);
        }

        @Override
        public void visit(AllOrAnyExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(AndExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(BetweenExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(ComparisonExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(EmptyCollectionComparisonExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(ExistsExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(KeywordExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(LikeExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(NotExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(NullComparisonExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(OrExpression expression) {
            this.valid = true;
        }
    }
}

