/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.JPAVersion;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.DefaultStringExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.QueryPosition;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.utility.iterable.ListIterable;
import org.eclipse.persistence.jpa.jpql.utility.iterable.SnapshotCloneListIterable;

public abstract class AbstractExpression
implements Expression {
    private String actualText;
    private List<Expression> children;
    private int offset = -1;
    private List<Expression> orderedChildren;
    private AbstractExpression parent;
    private String parsedText;
    private String text;
    public static final char COMMA = ',';
    public static final char DOT = '.';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char LEFT_CURLY_BRACKET = '{';
    public static final char LEFT_PARENTHESIS = '(';
    public static final char NOT_DEFINED = '\u0000';
    public static final char RIGHT_CURLY_BRACKET = '}';
    public static final char RIGHT_PARENTHESIS = ')';
    public static final char SINGLE_QUOTE = '\'';
    public static final char SPACE = ' ';
    public static final char UNDERSCORE = '_';

    protected AbstractExpression(AbstractExpression parent) {
        this(parent, "");
    }

    protected AbstractExpression(AbstractExpression parent, String text) {
        this.text = text;
        this.parent = parent;
    }

    protected boolean acceptUnknownVisitor(ExpressionVisitor visitor) {
        try {
            try {
                this.acceptUnknownVisitor(visitor, visitor.getClass(), this.getClass());
            }
            catch (NoSuchMethodException e) {
                this.acceptUnknownVisitor(visitor, visitor.getClass(), Expression.class);
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            RuntimeException actual = cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
            throw actual;
        }
    }

    protected void acceptUnknownVisitor(ExpressionVisitor visitor, Class<?> type2, Class<?> parameterType) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            Method visitMethod = type2.getDeclaredMethod("visit", parameterType);
            if (!visitMethod.canAccess(visitor)) {
                AccessController.doPrivileged(() -> {
                    visitMethod.setAccessible(true);
                    return null;
                });
            }
            visitMethod.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            type2 = type2.getSuperclass();
            if (type2 == Object.class) {
                throw e;
            }
            this.acceptUnknownVisitor(visitor, type2, parameterType);
        }
    }

    protected void addChildrenTo(Collection<Expression> children) {
    }

    protected void addOrderedChildrenTo(List<Expression> children) {
    }

    protected final AbstractExpression buildExpressionFromFallingBack(WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        ExpressionFactory factory = this.findFallBackExpressionFactory(queryBNF);
        if (factory == null) {
            return null;
        }
        if (tolerant && factory.getId() == "literal" && this.shouldSkipLiteral(expression)) {
            return null;
        }
        return factory.buildExpression(this, wordParser, word, queryBNF, expression, tolerant);
    }

    protected final AbstractExpression buildNullExpression() {
        return new NullExpression(this);
    }

    protected final Expression buildStringExpression(char value) {
        return this.buildStringExpression(String.valueOf(value));
    }

    protected final Expression buildStringExpression(String value) {
        return new DefaultStringExpression(this, value);
    }

    protected final AbstractExpression buildUnknownExpression(String text) {
        return new UnknownExpression(this, text);
    }

    protected final int calculatePosition(Expression expression, int length) {
        Expression parent = expression.getParent();
        if (parent == null) {
            return length;
        }
        for (Expression childExpression : parent.orderedChildren()) {
            if (childExpression == expression) {
                return this.calculatePosition(parent, length);
            }
            length += childExpression.getLength();
        }
        throw new RuntimeException("The position of the Expression could not be calculated: " + expression);
    }

    @Override
    public final ListIterable<Expression> children() {
        if (this.children == null) {
            this.children = new LinkedList<Expression>();
            this.addChildrenTo(this.children);
        }
        return new SnapshotCloneListIterable<Expression>(this.children);
    }

    protected final ExpressionFactory findFallBackExpressionFactory(JPQLQueryBNF queryBNF) {
        String fallBackBNFId = queryBNF.getFallbackBNFId();
        if (fallBackBNFId == null) {
            return null;
        }
        JPQLQueryBNF fallBackQueryBNF = this.getQueryBNF(fallBackBNFId);
        if (fallBackQueryBNF != queryBNF && fallBackQueryBNF.getFallbackBNFId() != null) {
            return this.findFallBackExpressionFactory(fallBackQueryBNF);
        }
        return this.getExpressionRegistry().getExpressionFactory(fallBackQueryBNF.getFallbackExpressionFactoryId());
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        return this.getQueryBNF();
    }

    protected final ExpressionFactory getExpressionFactory(String expressionFactoryId) {
        return this.getExpressionRegistry().getExpressionFactory(expressionFactoryId);
    }

    protected final ExpressionRegistry getExpressionRegistry() {
        return this.getGrammar().getExpressionRegistry();
    }

    @Override
    public JPQLGrammar getGrammar() {
        return this.getRoot().getGrammar();
    }

    public JPAVersion getIdentifierVersion(String identifier) {
        return this.getRoot().getIdentifierVersion(identifier);
    }

    protected JPAVersion getJPAVersion() {
        return this.getRoot().getJPAVersion();
    }

    @Override
    public final int getLength() {
        return this.toActualText().length();
    }

    @Override
    public final int getOffset() {
        if (this.offset == -1) {
            this.offset = this.calculatePosition(this, 0);
        }
        return this.offset;
    }

    @Override
    public final AbstractExpression getParent() {
        return this.parent;
    }

    public JPQLQueryBNF getQueryBNF(String queryBNFID) {
        return this.getExpressionRegistry().getQueryBNF(queryBNFID);
    }

    @Override
    public final JPQLExpression getRoot() {
        return this.parent == null ? (JPQLExpression)this : this.parent.getRoot();
    }

    protected String getText() {
        return this.text;
    }

    protected boolean handleAggregate(JPQLQueryBNF queryBNF) {
        return queryBNF.handleAggregate();
    }

    protected boolean handleCollection(JPQLQueryBNF queryBNF) {
        return queryBNF.handleCollection();
    }

    @Override
    public boolean isAncestor(Expression expression) {
        if (expression == this) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        return this.isAncestor(expression.getParent());
    }

    protected final boolean isIdentifier(String word) {
        return this.getExpressionRegistry().isIdentifier(word);
    }

    protected boolean isNull() {
        return false;
    }

    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("FROM") || word.equalsIgnoreCase("WHERE") || word.equalsIgnoreCase("HAVING") || wordParser.startsWithIdentifier("GROUP BY") || wordParser.startsWithIdentifier("ORDER BY") || wordParser.startsWithIdentifier("AS OF") || wordParser.startsWithIdentifier("START WITH") || wordParser.startsWithIdentifier("CONNECT BY") || wordParser.startsWithIdentifier("ORDER SIBLINGS BY") || word.equalsIgnoreCase("UNION") || word.equalsIgnoreCase("INTERSECT") || word.equalsIgnoreCase("EXCEPT");
    }

    protected boolean isTolerant() {
        return this.getRoot().isTolerant();
    }

    protected boolean isUnknown() {
        return false;
    }

    protected boolean isVirtual() {
        return false;
    }

    @Override
    public final ListIterable<Expression> orderedChildren() {
        if (this.orderedChildren == null) {
            this.orderedChildren = new LinkedList<Expression>();
            this.addOrderedChildrenTo(this.orderedChildren);
        }
        return new SnapshotCloneListIterable<Expression>(this.orderedChildren);
    }

    protected abstract void parse(WordParser var1, boolean var2);

    protected AbstractExpression parse(WordParser wordParser, String queryBNFId, boolean tolerant) {
        if (tolerant && wordParser.isTail()) {
            return null;
        }
        JPQLQueryBNF queryBNF = this.getQueryBNF(queryBNFId);
        int count = 0;
        boolean beginning = !tolerant;
        char character = wordParser.character();
        AbstractExpression expression = null;
        Info rootInfo = null;
        Info currentInfo = null;
        while (!wordParser.isTail()) {
            String word;
            AbstractExpression child = null;
            if (character == '(') {
                Info info;
                if (queryBNF.handleSubExpression()) {
                    expression = this.buildExpressionFromFallingBack(wordParser, "", queryBNF, expression, tolerant);
                } else {
                    expression = new SubExpression(this, queryBNF);
                    ((AbstractExpression)expression).parse(wordParser, tolerant);
                    if (this.parent != null && this.parent.getQueryBNF().handleSubExpression()) {
                        return expression;
                    }
                }
                beginning = false;
                count = wordParser.skipLeadingWhitespace();
                character = wordParser.character();
                if (rootInfo == null) {
                    info = new Info();
                } else {
                    info = new Info(currentInfo);
                    currentInfo.next = currentInfo.next;
                }
                currentInfo = info;
                currentInfo.expression = expression;
                boolean bl = currentInfo.space = count > 0;
            }
            if ((word = wordParser.word()).length() > 0) {
                ExpressionFactory factory;
                ExpressionRegistry expressionRegistry;
                ExpressionFactory factory2;
                if (!tolerant && !beginning && this.isParsingComplete(wordParser, word, expression) || tolerant && this.isParsingComplete(wordParser, word, expression)) break;
                if (this.shouldParseWithFactoryFirst() && wordParser.getWordType() == WordParser.WordType.WORD && (factory2 = queryBNF.getExpressionFactory(word)) != null && (child = factory2.buildExpression(this, wordParser, word, queryBNF, expression, tolerant)) != null) {
                    if (expression != null && child.isAncestor(expression)) {
                        if (currentInfo == rootInfo) {
                            rootInfo = null;
                            currentInfo = null;
                        } else if (currentInfo != null) {
                            currentInfo = currentInfo.previous;
                        }
                    }
                    beginning = false;
                    count = wordParser.skipLeadingWhitespace();
                    character = wordParser.character();
                    expression = child;
                }
                if (child == null && (child = this.buildExpressionFromFallingBack(wordParser, word, queryBNF, expression, tolerant)) != null) {
                    if (expression != null && child.isAncestor(expression)) {
                        if (currentInfo == rootInfo) {
                            rootInfo = null;
                            currentInfo = null;
                        } else if (currentInfo != null) {
                            currentInfo = currentInfo.previous;
                        }
                    }
                    beginning = false;
                    count = wordParser.skipLeadingWhitespace();
                    character = wordParser.character();
                    expression = child;
                }
                if (tolerant && child == null && (expressionRegistry = this.getExpressionRegistry()).getIdentifierRole(word) != IdentifierRole.AGGREGATE && (factory = expressionRegistry.expressionFactoryForIdentifier(word)) != null && (child = factory.buildExpression(this, wordParser, word, queryBNF, expression, tolerant)) != null) {
                    child = new BadExpression(this, child);
                    if (expression != null && child.isAncestor(expression)) {
                        if (currentInfo == rootInfo) {
                            rootInfo = null;
                            currentInfo = null;
                        } else if (currentInfo != null) {
                            currentInfo = currentInfo.previous;
                        }
                    }
                    beginning = false;
                    count = wordParser.skipLeadingWhitespace();
                    character = wordParser.character();
                    expression = child;
                }
            }
            if (child == null && character != ',') break;
            if (expression == null || child != null) {
                Info info;
                if (rootInfo == null) {
                    info = new Info();
                } else {
                    info = new Info(currentInfo);
                    currentInfo.next = currentInfo.next;
                }
                currentInfo = info;
                currentInfo.expression = child;
                boolean bl = currentInfo.space = count > 1;
            }
            if (wordParser.isTail()) break;
            if (character == ',') {
                boolean stopParsing;
                if (!this.handleCollection(queryBNF) || tolerant && this.isParsingComplete(wordParser, word, expression)) break;
                wordParser.moveForward(1);
                currentInfo.comma = true;
                count = wordParser.skipLeadingWhitespace();
                currentInfo.space = count > 0;
                character = wordParser.character();
                expression = null;
                if (character == '(') continue;
                word = wordParser.word();
                boolean bl = stopParsing = tolerant && (word.length() == 0 || this.isParsingComplete(wordParser, word, null));
                if (wordParser.isTail() || stopParsing) {
                    Info info;
                    count = 0;
                    if (rootInfo == null) {
                        info = new Info();
                    } else {
                        info = new Info(currentInfo);
                        currentInfo.next = currentInfo.next;
                    }
                    currentInfo = info;
                    if (stopParsing) break;
                }
                if (character != ')') continue;
                break;
            }
            if (character == ')' || !this.handleAggregate(queryBNF)) break;
            currentInfo.space = count > 0;
        }
        if (count > 0) {
            currentInfo.space = currentInfo.comma;
            if (!currentInfo.comma) {
                wordParser.moveBackward(count);
            }
        }
        if (currentInfo == null) {
            return null;
        }
        if (currentInfo == rootInfo && !currentInfo.comma && !currentInfo.space) {
            return currentInfo.expression;
        }
        return new CollectionExpression(this, rootInfo.buildChildren(), rootInfo.buildCommas(), rootInfo.buildSpaces());
    }

    protected AbstractExpression parseUsingExpressionFactory(WordParser wordParser, String queryBNFId, boolean tolerant) {
        String word = wordParser.word();
        JPQLQueryBNF queryBNF = this.getQueryBNF(queryBNFId);
        ExpressionFactory factory = queryBNF.getExpressionFactory(word);
        if (factory == null) {
            return null;
        }
        return factory.buildExpression(this, wordParser, word, queryBNF, null, tolerant);
    }

    @Override
    public void populatePosition(QueryPosition queryPosition, int position) {
        queryPosition.addPosition(this, position);
        if (position != 0) {
            for (Expression expression : this.orderedChildren()) {
                String expressionText = expression.toParsedText();
                if (position <= expressionText.length()) {
                    expression.populatePosition(queryPosition, position);
                    return;
                }
                position -= expressionText.length();
            }
            throw new IllegalStateException("A problem was encountered while calculating the position.");
        }
        queryPosition.setExpression(this);
    }

    protected final void rebuildActualText() {
        if (this.actualText != null) {
            this.toActualText();
        }
    }

    protected final void rebuildParsedText() {
        if (this.parsedText != null) {
            this.toParsedText();
        }
    }

    protected final void setParent(AbstractExpression parent) {
        this.parent = parent;
    }

    protected final void setText(String text) {
        this.text = text;
    }

    protected boolean shouldParseWithFactoryFirst() {
        return true;
    }

    protected boolean shouldSkipLiteral(AbstractExpression expression) {
        return expression != null;
    }

    @Override
    public String toActualText() {
        if (this.actualText == null) {
            StringBuilder writer = new StringBuilder();
            this.toParsedText(writer, true);
            this.actualText = writer.toString();
        }
        return this.actualText;
    }

    @Override
    public String toParsedText() {
        if (this.parsedText == null) {
            StringBuilder writer = new StringBuilder();
            this.toParsedText(writer, false);
            this.parsedText = writer.toString();
        }
        return this.parsedText;
    }

    protected abstract void toParsedText(StringBuilder var1, boolean var2);

    public final String toString() {
        this.parsedText = null;
        return this.toParsedText();
    }

    private static class Info {
        boolean comma;
        AbstractExpression expression;
        Info next;
        Info previous;
        boolean space;

        Info() {
        }

        Info(Info previous) {
            this.previous = previous;
        }

        private void addChild(ArrayList<AbstractExpression> children) {
            children.add(this.expression);
            if (this.next != null) {
                this.next.addChild(children);
            }
        }

        private void addComma(ArrayList<Boolean> children) {
            children.add(this.comma);
            if (this.next != null) {
                this.next.addComma(children);
            }
        }

        private void addSpace(ArrayList<Boolean> children) {
            children.add(this.space);
            if (this.next != null) {
                this.next.addSpace(children);
            }
        }

        List<AbstractExpression> buildChildren() {
            ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>();
            this.addChild(children);
            return children;
        }

        List<Boolean> buildCommas() {
            ArrayList<Boolean> children = new ArrayList<Boolean>();
            this.addComma(children);
            return children;
        }

        List<Boolean> buildSpaces() {
            ArrayList<Boolean> children = new ArrayList<Boolean>();
            this.addSpace(children);
            return children;
        }
    }
}

