/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.platform.database.oracle;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import org.eclipse.persistence.internal.databaseaccess.PlatformWrapper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPHelper;

public class TIMESTAMPTZWrapper
implements Serializable,
PlatformWrapper {
    private final ZonedDateTime zonedDateTime;
    private final Map<Class<?>, Function<TIMESTAMPTZWrapper, ?>> UNWRAP = this.initUnwrappers();

    public TIMESTAMPTZWrapper(ZonedDateTime zonedDateTime) {
        this.zonedDateTime = zonedDateTime;
    }

    public LocalTime toLocalTime() {
        return this.zonedDateTime.toLocalTime();
    }

    public LocalDate toLocalDate() {
        return this.zonedDateTime.toLocalDate();
    }

    public LocalDateTime toLocalDateTime() {
        return this.zonedDateTime.toLocalDateTime();
    }

    public OffsetTime toOffsetTime() {
        return this.zonedDateTime.toOffsetDateTime().toOffsetTime();
    }

    public OffsetDateTime toOffsetDateTime() {
        return this.zonedDateTime.toOffsetDateTime();
    }

    public Calendar toCalendar() {
        return TIMESTAMPHelper.buildCalendar(this);
    }

    public Timestamp getTimestamp() {
        return Timestamp.valueOf(this.zonedDateTime.toLocalDateTime());
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.zonedDateTime.getZone());
    }

    public ZoneId getZoneId() {
        return this.zonedDateTime.getZone();
    }

    Map<Class<?>, Function<TIMESTAMPTZWrapper, ?>> initUnwrappers() {
        HashMap unwrappers = new HashMap();
        unwrappers.put(TIMESTAMPTZWrapper.class, wrapper -> wrapper);
        unwrappers.put(LocalDate.class, TIMESTAMPTZWrapper::toLocalDate);
        unwrappers.put(LocalTime.class, TIMESTAMPTZWrapper::toLocalTime);
        unwrappers.put(LocalDateTime.class, TIMESTAMPTZWrapper::toLocalDateTime);
        unwrappers.put(OffsetTime.class, TIMESTAMPTZWrapper::toOffsetTime);
        unwrappers.put(OffsetDateTime.class, TIMESTAMPTZWrapper::toOffsetDateTime);
        unwrappers.put(Timestamp.class, TIMESTAMPTZWrapper::getTimestamp);
        unwrappers.put(TimeZone.class, TIMESTAMPTZWrapper::getTimeZone);
        unwrappers.put(ZoneId.class, TIMESTAMPTZWrapper::getZoneId);
        unwrappers.put(Calendar.class, TIMESTAMPTZWrapper::toCalendar);
        return unwrappers;
    }

    public <T> T unwrap(Class<T> type2) {
        Function<TIMESTAMPTZWrapper, ?> unwrapper = this.UNWRAP.get(type2);
        if (unwrapper != null) {
            return type2.cast(unwrapper.apply(this));
        }
        throw new IllegalArgumentException("Unwrapping of TIMESTAMPTZWrapper as " + type2.getName() + " is not supported");
    }
}

