/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import jakarta.activation.DataHandler;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeMultipart;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.helper.CoreConversionManager;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ByteArrayDataSource;
import org.eclipse.persistence.internal.oxm.ByteArraySource;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.Marshaller;

public class XMLBinaryDataHelper {
    protected static XMLBinaryDataHelper binaryDataHelper;
    public Class<?> DATA_HANDLER;
    public Class<?> IMAGE;
    public Class<?> SOURCE;
    public Class<?> MULTIPART;

    public XMLBinaryDataHelper() {
        if (this.DATA_HANDLER == null) {
            this.initializeDataTypes();
        }
    }

    public static XMLBinaryDataHelper getXMLBinaryDataHelper() {
        if (binaryDataHelper == null) {
            XMLBinaryDataHelper.setXMLBinaryDataHelper(new XMLBinaryDataHelper());
        }
        return binaryDataHelper;
    }

    public static void setXMLBinaryDataHelper(XMLBinaryDataHelper helper) {
        binaryDataHelper = helper;
    }

    public void initializeDataTypes() {
        this.DATA_HANDLER = DataHandler.class;
        this.IMAGE = Image.class;
        this.SOURCE = Source.class;
        this.MULTIPART = MimeMultipart.class;
    }

    public Object convertObject(Object obj, Class<?> classification, CoreAbstractSession session, CoreContainerPolicy cp) {
        if (obj instanceof List && cp != null) {
            List theList = (List)obj;
            Object container = cp.containerInstance(theList.size());
            for (int i = 0; i < theList.size(); ++i) {
                Object next = theList.get(i);
                cp.addInto(this.convertSingleObject(next, classification, session), container, session);
            }
            return container;
        }
        return this.convertSingleObject(obj, classification, session);
    }

    public Object convertSingleObject(Object obj, Class<?> classification, CoreAbstractSession session) {
        if (classification == this.DATA_HANDLER) {
            return this.convertObjectToDataHandler(obj, session);
        }
        if (classification == this.IMAGE) {
            return this.convertObjectToImage(obj);
        }
        if (classification == this.SOURCE) {
            return this.convertObjectToSource(obj);
        }
        if (classification == this.MULTIPART) {
            return this.convertObjectToMultipart(obj);
        }
        return ((CoreConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(obj, classification);
    }

    public EncodedData getBytesFromDataHandler(DataHandler handler) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            handler.writeTo(output);
        }
        catch (IOException ex) {
            throw ConversionException.couldNotBeConverted((Object)handler, byte[].class, ex);
        }
        return new EncodedData(output.toByteArray(), handler.getContentType());
    }

    public List<byte[]> getBytesListForBinaryValues(List attributeValue, Marshaller marshaller, String mimeType) {
        ArrayList<byte[]> returnList = new ArrayList<byte[]>(attributeValue.size());
        for (int i = 0; i < attributeValue.size(); ++i) {
            Object next = attributeValue.get(i);
            EncodedData nextEncodedData = this.getBytesForSingleBinaryValue(next, marshaller, mimeType);
            returnList.add(nextEncodedData.getData());
        }
        return returnList;
    }

    public EncodedData getBytesForBinaryValue(Object attributeValue, Marshaller marshaller, String mimeType) {
        return this.getBytesForSingleBinaryValue(attributeValue, marshaller, mimeType);
    }

    public EncodedData getBytesForSingleBinaryValue(Object attributeValue, Marshaller marshaller, String mimeType) {
        if (attributeValue instanceof DataHandler) {
            return this.getBytesFromDataHandler((DataHandler)attributeValue);
        }
        if (attributeValue instanceof Image) {
            return this.getBytesFromImage((Image)attributeValue, mimeType);
        }
        if (attributeValue instanceof Source) {
            return this.getBytesFromSource((Source)attributeValue, marshaller, mimeType);
        }
        if (attributeValue instanceof MimeMultipart) {
            return this.getBytesFromMultipart((MimeMultipart)attributeValue, marshaller);
        }
        if (attributeValue.getClass() == CoreClassConstants.APBYTE) {
            return new EncodedData((byte[])attributeValue, mimeType);
        }
        if (attributeValue.getClass() == CoreClassConstants.ABYTE) {
            return this.getBytesFromByteObjectArray((Byte[])attributeValue, mimeType);
        }
        return new EncodedData(new byte[0], null);
    }

    public EncodedData getBytesFromMultipart(MimeMultipart value, Marshaller marshaller) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            ContentType contentType = new ContentType(value.getContentType());
            String boundary = contentType.getParameter("boundary");
            output.write(Constants.cr().getBytes());
            output.write(("Content-Type: " + contentType.getBaseType() + "; boundary=\"" + boundary + "\"\n").getBytes());
        }
        catch (Exception ex) {
            throw ConversionException.couldNotBeConverted((Object)value, byte[].class, ex);
        }
        try {
            value.writeTo(output);
        }
        catch (Exception ex) {
            throw ConversionException.couldNotBeConverted((Object)value, byte[].class, ex);
        }
        return new EncodedData(output.toByteArray(), value.getContentType());
    }

    public EncodedData getBytesFromSource(Source source, Marshaller marshaller, String mimeType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        marshaller.getTransformer().transform(source, (Result)result);
        if (mimeType == null) {
            mimeType = "application/xml";
        }
        return new EncodedData(out.toByteArray(), mimeType);
    }

    public EncodedData getBytesFromByteObjectArray(Byte[] bytes, String mimeType) {
        byte[] data = new byte[bytes.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = bytes[i];
        }
        return new EncodedData(data, mimeType);
    }

    public EncodedData getBytesFromImage(Image image, String mimeType) {
        if (mimeType == null || mimeType.startsWith("image/*")) {
            mimeType = "image/png";
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Iterator<ImageWriter> itr = ImageIO.getImageWritersByMIMEType(mimeType);
            if (!itr.hasNext()) {
                throw XMLMarshalException.noEncoderForMimeType(mimeType);
            }
            ImageWriter w = itr.next();
            w.setOutput(ImageIO.createImageOutputStream(outputStream));
            w.write(this.convertToBufferedImage(image));
            w.dispose();
            return new EncodedData(outputStream.toByteArray(), mimeType);
        }
        catch (Exception ex) {
            throw ConversionException.couldNotBeConverted((Object)image, byte[].class, ex);
        }
    }

    private BufferedImage convertToBufferedImage(Image image) throws IOException {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        MediaTracker tracker = new MediaTracker(new Component(){});
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
        BufferedImage bufImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        return bufImage;
    }

    public Object convertObjectToMultipart(Object obj) {
        if (obj instanceof MimeMultipart) {
            return obj;
        }
        if (obj instanceof DataHandler) {
            try {
                if (((DataHandler)obj).getContent() instanceof MimeMultipart) {
                    MimeMultipart multipart = (MimeMultipart)((DataHandler)obj).getContent();
                    return multipart;
                }
                return new MimeMultipart(((DataHandler)obj).getDataSource());
            }
            catch (Exception ex) {
                throw ConversionException.couldNotBeConverted(obj, this.MULTIPART, ex);
            }
        }
        if (obj instanceof byte[]) {
            try {
                byte[] bytes = (byte[])obj;
                InputStreamReader in = new InputStreamReader(new ByteArrayInputStream(bytes));
                int i = 0;
                while (i != -1) {
                    i = in.read();
                }
                return new MimeMultipart(new ByteArrayDataSource((byte[])obj, "multipart/mixed"));
            }
            catch (Exception ex) {
                throw ConversionException.couldNotBeConverted(obj, this.MULTIPART, ex);
            }
        }
        if (obj instanceof Byte[]) {
            Byte[] objectBytes = (Byte[])obj;
            byte[] bytes = new byte[objectBytes.length];
            for (int i = 0; i < objectBytes.length; ++i) {
                bytes[i] = objectBytes[i];
            }
            try {
                return new MimeMultipart(new ByteArrayDataSource(bytes, "multipart/mixed"));
            }
            catch (Exception ex) {
                throw ConversionException.couldNotBeConverted(obj, this.MULTIPART, ex);
            }
        }
        return null;
    }

    public Object convertObjectToImage(Object obj) {
        if (obj instanceof Image) {
            return obj;
        }
        if (obj instanceof DataHandler) {
            try {
                if (((DataHandler)obj).getContent() instanceof Image) {
                    Image image = (Image)((DataHandler)obj).getContent();
                    return image;
                }
                return ImageIO.read(((DataHandler)obj).getInputStream());
            }
            catch (Exception ex) {
                throw ConversionException.couldNotBeConverted(obj, this.IMAGE, ex);
            }
        }
        if (obj instanceof byte[]) {
            ByteArrayInputStream stream = new ByteArrayInputStream((byte[])obj);
            try {
                return ImageIO.read(stream);
            }
            catch (Exception ex) {
                throw ConversionException.couldNotBeConverted(obj, this.IMAGE, ex);
            }
        }
        if (obj instanceof Byte[]) {
            Byte[] objectBytes = (Byte[])obj;
            byte[] bytes = new byte[objectBytes.length];
            for (int i = 0; i < objectBytes.length; ++i) {
                bytes[i] = objectBytes[i];
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            try {
                return ImageIO.read(stream);
            }
            catch (Exception ex) {
                throw ConversionException.couldNotBeConverted(obj, this.IMAGE, ex);
            }
        }
        return null;
    }

    public String stringFromDataHandler(DataHandler source, QName schemaTypeQName, CoreAbstractSession session) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            source.writeTo(output);
            return ((ConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(output.toByteArray(), String.class, schemaTypeQName);
        }
        catch (Exception ex) {
            throw ConversionException.couldNotBeConverted((Object)source, CoreClassConstants.STRING, ex);
        }
    }

    public String stringFromDataHandler(Object source, QName schemaTypeQName, CoreAbstractSession session) {
        return this.stringFromDataHandler((DataHandler)source, schemaTypeQName, session);
    }

    public String stringFromImage(Image image, QName schemaTypeQName, CoreAbstractSession session) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            String mimeType = "image/png";
            Iterator<ImageWriter> itr = ImageIO.getImageWritersByMIMEType(mimeType);
            if (!itr.hasNext()) {
                throw XMLMarshalException.noEncoderForMimeType(mimeType);
            }
            ImageWriter w = itr.next();
            w.setOutput(ImageIO.createImageOutputStream(outputStream));
            w.write(this.convertToBufferedImage(image));
            w.dispose();
            return ((ConversionManager)session.getDatasourcePlatform().getConversionManager()).buildBase64StringFromBytes(outputStream.toByteArray());
        }
        catch (Exception ex) {
            throw ConversionException.couldNotBeConverted((Object)image, byte[].class, ex);
        }
    }

    public String stringFromSource(Source source, QName schemaTypeQName, CoreAbstractSession session) {
        DataHandler handler = new DataHandler(source, "text/xml");
        return this.stringFromDataHandler(handler, schemaTypeQName, session);
    }

    public String stringFromMultipart(MimeMultipart multipart, QName schemaTypeQName, CoreAbstractSession session) {
        DataHandler handler = new DataHandler(multipart, multipart.getContentType());
        return this.stringFromDataHandler(handler, schemaTypeQName, session);
    }

    public DataHandler convertObjectToDataHandler(Object sourceObject, CoreAbstractSession session) {
        byte[] bytes;
        DataHandler handler = null;
        if (sourceObject instanceof DataHandler) {
            return (DataHandler)sourceObject;
        }
        if (sourceObject instanceof byte[]) {
            bytes = (byte[])sourceObject;
            handler = new DataHandler(new ByteArrayDataSource(bytes, "application/octet-stream"));
        } else if (sourceObject instanceof Byte[]) {
            bytes = (byte[])((CoreConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(sourceObject, CoreClassConstants.APBYTE);
            handler = new DataHandler(new ByteArrayDataSource(bytes, "application/octet-stream"));
        }
        if (sourceObject instanceof String) {
            bytes = ((ConversionManager)session.getDatasourcePlatform().getConversionManager()).convertSchemaBase64ToByteArray(sourceObject);
            handler = new DataHandler(new ByteArrayDataSource(bytes, "application/octet-stream"));
        } else if (sourceObject instanceof Image) {
            handler = new DataHandler(sourceObject, "image/jpeg");
        } else if (sourceObject instanceof Source) {
            handler = new DataHandler(sourceObject, "text/xml");
        } else if (sourceObject instanceof MimeMultipart) {
            handler = new DataHandler(sourceObject, ((MimeMultipart)sourceObject).getContentType());
        }
        return handler;
    }

    public Object convertObjectToSource(Object obj) {
        block12: {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Source) {
                return obj;
            }
            if (obj.getClass() == CoreClassConstants.STRING) {
                return new StreamSource(new StringReader((String)obj));
            }
            if (obj instanceof DataHandler) {
                try {
                    InputStream object = ((DataHandler)obj).getInputStream();
                    return new StreamSource(object);
                }
                catch (Exception ex) {
                    try {
                        Object object = ((DataHandler)obj).getContent();
                        this.convertObjectToSource(object);
                        break block12;
                    }
                    catch (Exception ioException) {
                        throw ConversionException.couldNotBeConverted(obj, Source.class);
                    }
                }
            }
            if (obj instanceof byte[]) {
                return new ByteArraySource((byte[])obj);
            }
            if (obj instanceof Byte[]) {
                Byte[] objectBytes = (Byte[])obj;
                byte[] bytes = new byte[objectBytes.length];
                for (int i = 0; i < objectBytes.length; ++i) {
                    bytes[i] = objectBytes[i];
                }
                return new ByteArraySource(bytes);
            }
            if (obj instanceof InputStream) {
                return new StreamSource((InputStream)obj);
            }
        }
        return null;
    }

    public static final class EncodedData {
        private byte[] data;
        private String mimeType;

        public EncodedData(byte[] bytes, String contentType) {
            this.data = bytes;
            this.mimeType = contentType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setMimeType(String type2) {
            this.mimeType = type2;
        }

        public void setData(byte[] bytes) {
            this.data = bytes;
        }
    }
}

