/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CompoundSelection;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.Type;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.expressions.ArgumentListFunctionExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicCollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicMapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicSetJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.CollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.CommonAbstractCriteriaImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.ConstructorSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaDeleteImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaUpdateImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.FromImpl;
import org.eclipse.persistence.internal.jpa.querydef.FunctionExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.JoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.ListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.MapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.OrderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.PathImpl;
import org.eclipse.persistence.internal.jpa.querydef.PredicateImpl;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.SetJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.jpa.JpaCriteriaBuilder;
import org.eclipse.persistence.queries.ReportQuery;

public class CriteriaBuilderImpl
implements JpaCriteriaBuilder,
Serializable {
    public static final String CONCAT = "concat";
    public static final String SIZE = "size";
    protected Metamodel metamodel;

    public CriteriaBuilderImpl(Metamodel metamodel) {
        this.metamodel = metamodel;
    }

    @Override
    public CriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(this.metamodel, AbstractQueryImpl.ResultType.UNKNOWN, ClassConstants.OBJECT, this);
    }

    @Override
    public <T> CriteriaQuery<T> createQuery(Class<T> resultClass) {
        if (resultClass == null) {
            return this.createQuery();
        }
        if (resultClass.equals(Tuple.class)) {
            return new CriteriaQueryImpl<T>(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, resultClass, this);
        }
        if (resultClass.equals(ClassConstants.AOBJECT)) {
            return new CriteriaQueryImpl<T>(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        if (resultClass.isArray()) {
            return new CriteriaQueryImpl<T>(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        if (resultClass.equals(ClassConstants.OBJECT)) {
            return this.createQuery();
        }
        if (resultClass.isPrimitive() || resultClass.equals(ClassConstants.STRING) || BasicTypeHelperImpl.getInstance().isWrapperClass(resultClass) || BasicTypeHelperImpl.getInstance().isDateClass(resultClass)) {
            return new CriteriaQueryImpl<T>(this.metamodel, AbstractQueryImpl.ResultType.OTHER, resultClass, this);
        }
        TypeImpl<T> type2 = ((MetamodelImpl)this.metamodel).getType(resultClass);
        if (type2 != null && type2.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaQueryImpl<T>(this.metamodel, AbstractQueryImpl.ResultType.ENTITY, resultClass, this);
        }
        return new CriteriaQueryImpl<T>(this.metamodel, AbstractQueryImpl.ResultType.CONSTRUCTOR, resultClass, this);
    }

    @Override
    public CriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, Tuple.class, this);
    }

    @Override
    public <Y> CompoundSelection<Y> construct(Class<Y> result, Selection<?> ... selections) {
        return new ConstructorSelectionImpl(result, selections);
    }

    @Override
    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return new CompoundSelectionImpl(Tuple.class, selections, true);
    }

    @Override
    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return new CompoundSelectionImpl(ClassConstants.AOBJECT, selections, true);
    }

    @Override
    public Order asc(jakarta.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new OrderImpl(x);
    }

    @Override
    public Order desc(jakarta.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        OrderImpl order = new OrderImpl(x, false);
        return order;
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<Double> avg(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ((InternalSelection)((Object)x)).getCurrentNode().average(), this.buildList(x), "AVG");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> sum(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().sum(), this.buildList(x), "SUM");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> max(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().maximum(), this.buildList(x), "MAX");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> min(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().minimum(), this.buildList(x), "MIN");
    }

    @Override
    public <X extends Comparable<? super X>> jakarta.persistence.criteria.Expression<X> greatest(jakarta.persistence.criteria.Expression<X> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().maximum());
    }

    @Override
    public <X extends Comparable<? super X>> jakarta.persistence.criteria.Expression<X> least(jakarta.persistence.criteria.Expression<X> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().minimum());
    }

    @Override
    public jakarta.persistence.criteria.Expression<Long> count(jakarta.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)((Object)x)).getCurrentNode().count(), this.buildList(x), "COUNT");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Long> countDistinct(jakarta.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)((Object)x)).getCurrentNode().distinct().count(), this.buildList(x), "COUNT");
    }

    @Override
    public Predicate exists(Subquery<?> subquery) {
        return new CompoundExpressionImpl(this.metamodel, Expression.getOperator(86).expressionFor(((SubQueryImpl)subquery).getCurrentNode()), this.buildList(subquery), "exists");
    }

    @Override
    public <Y> jakarta.persistence.criteria.Expression<Y> all(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().all(((InternalSelection)((Object)subquery)).getCurrentNode()), this.buildList(subquery), "all");
    }

    @Override
    public <Y> jakarta.persistence.criteria.Expression<Y> some(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().some(((InternalSelection)((Object)subquery)).getCurrentNode()), this.buildList(subquery), "some");
    }

    @Override
    public <Y> jakarta.persistence.criteria.Expression<Y> any(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().any(((InternalSelection)((Object)subquery)).getCurrentNode()), this.buildList(subquery), "any");
    }

    @Override
    public Predicate and(jakarta.persistence.criteria.Expression<Boolean> x, jakarta.persistence.criteria.Expression<Boolean> y) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)((Object)x)).isExpression() ? (CompoundExpressionImpl)this.isTrue(x) : (CompoundExpressionImpl)x;
        yp = ((InternalExpression)((Object)y)).isExpression() ? (CompoundExpressionImpl)this.isTrue(y) : (CompoundExpressionImpl)y;
        if (yp.isJunction()) {
            if (((PredicateImpl)yp).getJunctionValue().booleanValue()) {
                return xp;
            }
            return yp;
        }
        if (xp.isJunction()) {
            if (((PredicateImpl)xp).getJunctionValue().booleanValue()) {
                return yp;
            }
            return xp;
        }
        Expression currentNode = xp.getCurrentNode().and(yp.getCurrentNode());
        xp.setParentNode(currentNode);
        yp.setParentNode(currentNode);
        return new PredicateImpl(this.metamodel, currentNode, this.buildList(xp, yp), Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate or(jakarta.persistence.criteria.Expression<Boolean> x, jakarta.persistence.criteria.Expression<Boolean> y) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)((Object)x)).isExpression() ? (CompoundExpressionImpl)this.isTrue(x) : (CompoundExpressionImpl)x;
        yp = ((InternalExpression)((Object)y)).isExpression() ? (CompoundExpressionImpl)this.isTrue(y) : (CompoundExpressionImpl)y;
        if (yp.isJunction()) {
            if (((PredicateImpl)yp).getJunctionValue().booleanValue()) {
                return yp;
            }
            return xp;
        }
        if (xp.isJunction()) {
            if (((PredicateImpl)xp).getJunctionValue().booleanValue()) {
                return xp;
            }
            return yp;
        }
        Expression parentNode = xp.getCurrentNode().or(yp.getCurrentNode());
        xp.setParentNode(parentNode);
        yp.setParentNode(parentNode);
        return new PredicateImpl(this.metamodel, parentNode, this.buildList(xp, yp), Predicate.BooleanOperator.OR);
    }

    @Override
    public Predicate and(Predicate ... restrictions) {
        int max = restrictions.length;
        if (max == 0) {
            return this.conjunction();
        }
        Predicate a = restrictions[0];
        for (int i = 1; i < max; ++i) {
            a = this.and((jakarta.persistence.criteria.Expression<Boolean>)a, (jakarta.persistence.criteria.Expression<Boolean>)restrictions[i]);
        }
        return a;
    }

    @Override
    public Predicate or(Predicate ... restrictions) {
        int max = restrictions.length;
        if (max == 0) {
            return this.disjunction();
        }
        Predicate a = restrictions[0];
        for (int i = 1; i < max; ++i) {
            a = this.or((jakarta.persistence.criteria.Expression<Boolean>)a, (jakarta.persistence.criteria.Expression<Boolean>)restrictions[i]);
        }
        return a;
    }

    @Override
    public Predicate not(jakarta.persistence.criteria.Expression<Boolean> restriction) {
        if (((InternalExpression)((Object)restriction)).isPredicate()) {
            return ((Predicate)restriction).not();
        }
        Expression parentNode = null;
        List<jakarta.persistence.criteria.Expression<?>> compoundExpressions = null;
        String name = "not";
        if (((InternalExpression)((Object)restriction)).isCompoundExpression() && ((CompoundExpressionImpl)restriction).getOperation().equals("exists")) {
            FunctionExpression exp = (FunctionExpression)((InternalSelection)((Object)restriction)).getCurrentNode();
            SubSelectExpression sub = (SubSelectExpression)exp.getChildren().get(0);
            parentNode = Expression.getOperator(88).expressionFor(sub);
            name = "notExists";
            compoundExpressions = ((CompoundExpressionImpl)restriction).getChildExpressions();
        } else {
            parentNode = ((InternalSelection)((Object)restriction)).getCurrentNode().not();
            compoundExpressions = this.buildList(restriction);
        }
        CompoundExpressionImpl expr = new CompoundExpressionImpl(this.metamodel, parentNode, compoundExpressions, name);
        expr.setIsNegated(true);
        return expr;
    }

    @Override
    public Predicate conjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate disjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.OR);
    }

    @Override
    public Predicate isTrue(jakarta.persistence.criteria.Expression<Boolean> x) {
        if (((InternalExpression)((Object)x)).isPredicate()) {
            if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
                return (Predicate)x;
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("PREDICATE_PASSED_TO_EVALUATION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().equal(true), this.buildList(x), "equals");
    }

    @Override
    public Predicate isFalse(jakarta.persistence.criteria.Expression<Boolean> x) {
        if (((InternalExpression)((Object)x)).isPredicate()) {
            if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
                if (((Predicate)x).getOperator() == Predicate.BooleanOperator.AND) {
                    return (Predicate)x;
                }
                return this.conjunction();
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("PREDICATE_PASSED_TO_EVALUATION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().equal(false), this.buildList(x), "equals");
    }

    @Override
    public Predicate isNull(jakarta.persistence.criteria.Expression<?> x) {
        return new PredicateImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().isNull(), this.buildList(x), Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate isNotNull(jakarta.persistence.criteria.Expression<?> x) {
        return new PredicateImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notNull(), this.buildList(x), Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate equal(jakarta.persistence.criteria.Expression<?> x, jakarta.persistence.criteria.Expression<?> y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().equal(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "equals");
    }

    @Override
    public Predicate notEqual(jakarta.persistence.criteria.Expression<?> x, jakarta.persistence.criteria.Expression<?> y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null || ((InternalSelection)((Object)y)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notEqual(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "not equal");
    }

    @Override
    public Predicate equal(jakarta.persistence.criteria.Expression<?> x, Object y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        if (y instanceof ParameterExpression) {
            return this.equal(x, (ParameterExpression)y);
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().equal(y), this.buildList(x, this.internalLiteral(y)), "equal");
    }

    @Override
    public Predicate notEqual(jakarta.persistence.criteria.Expression<?> x, Object y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        if (y instanceof ParameterExpression) {
            return this.notEqual(x, (ParameterExpression)y);
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notEqual(y), this.buildList(x, this.internalLiteral(y)), "not equal");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate greaterThan(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null || ((InternalSelection)((Object)y)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().greaterThan(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "greaterThan");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate lessThan(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null || ((InternalSelection)((Object)y)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().lessThan(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "lessThan");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        if (((ExpressionImpl)x).getCurrentNode() == null || ((ExpressionImpl)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThanEqual(((ExpressionImpl)y).getCurrentNode()), this.buildList(x, y), "greaterThanEqual");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        if (((ExpressionImpl)x).getCurrentNode() == null || ((ExpressionImpl)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThanEqual(((ExpressionImpl)y).getCurrentNode()), this.buildList(x, y), "lessThanEqual");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate between(jakarta.persistence.criteria.Expression<? extends Y> v, jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)v).getCurrentNode().between(((ExpressionImpl)x).getCurrentNode(), ((ExpressionImpl)y).getCurrentNode()), this.buildList(v, x, y), "between");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate greaterThan(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        jakarta.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThan(((ExpressionImpl)expressionY).getCurrentNode()), this.buildList(x, expressionY), "greaterThan");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate lessThan(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        jakarta.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThan(((ExpressionImpl)expressionY).getCurrentNode()), this.buildList(x, expressionY), "lessThan");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        jakarta.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThanEqual(((ExpressionImpl)expressionY).getCurrentNode()), this.buildList(x, expressionY), "greaterThanEqual");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        jakarta.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThanEqual(((ExpressionImpl)expressionY).getCurrentNode()), this.buildList(x, expressionY), "lessThanEqual");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate between(jakarta.persistence.criteria.Expression<? extends Y> v, Y x, Y y) {
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)v).getCurrentNode().between(x, y), this.buildList(v, this.internalLiteral(x), this.internalLiteral(y)), "between");
    }

    protected List<jakarta.persistence.criteria.Expression<?>> buildList(jakarta.persistence.criteria.Expression<?> ... expressions) {
        ArrayList list = new ArrayList();
        for (jakarta.persistence.criteria.Expression<?> exp : expressions) {
            list.add(exp);
        }
        return list;
    }

    @Override
    public Predicate gt(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().greaterThan(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "gt");
    }

    @Override
    public Predicate lt(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().lessThan(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "lessThan");
    }

    @Override
    public Predicate ge(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().greaterThanEqual(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "ge");
    }

    @Override
    public Predicate le(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().lessThanEqual(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "le");
    }

    @Override
    public Predicate gt(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().greaterThan(y), this.buildList(x, this.internalLiteral(y)), "gt");
    }

    @Override
    public Predicate lt(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().lessThan(y), this.buildList(x, this.internalLiteral(y)), "lt");
    }

    @Override
    public Predicate ge(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().greaterThanEqual(y), this.buildList(x, this.internalLiteral(y)), "ge");
    }

    @Override
    public Predicate le(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().lessThanEqual(y), this.buildList(x, this.internalLiteral(y)), "le");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> neg(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.negate(((InternalSelection)((Object)x)).getCurrentNode()), this.buildList(x), "neg");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> abs(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.abs(((InternalSelection)((Object)x)).getCurrentNode()), this.buildList(x), "ABS");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> sum(jakarta.persistence.criteria.Expression<? extends N> x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getJavaType(), y.getJavaType()), ExpressionMath.add(((InternalSelection)((Object)x)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "sum");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Long> sumAsLong(jakarta.persistence.criteria.Expression<Integer> x) {
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)((Object)x)).getCurrentNode().sum(), this.buildList(x), "SUM");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Double> sumAsDouble(jakarta.persistence.criteria.Expression<Float> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ((InternalSelection)((Object)x)).getCurrentNode().sum(), this.buildList(x), "SUM");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> prod(jakarta.persistence.criteria.Expression<? extends N> x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getJavaType(), y.getJavaType()), ExpressionMath.multiply(((InternalSelection)((Object)x)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "prod");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> diff(jakarta.persistence.criteria.Expression<? extends N> x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.subtract(((InternalSelection)((Object)x)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "diff");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> sum(jakarta.persistence.criteria.Expression<? extends N> x, N y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getJavaType(), y.getClass()), ExpressionMath.add(((InternalSelection)((Object)x)).getCurrentNode(), y), this.buildList(x, this.internalLiteral(y)), "sum");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> prod(jakarta.persistence.criteria.Expression<? extends N> x, N y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getJavaType(), y.getClass()), ExpressionMath.multiply(((InternalSelection)((Object)x)).getCurrentNode(), y), this.buildList(x, this.internalLiteral(y)), "prod");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> diff(jakarta.persistence.criteria.Expression<? extends N> x, N y) {
        return new FunctionExpressionImpl(this.metamodel, y.getClass(), ExpressionMath.subtract(((InternalSelection)((Object)x)).getCurrentNode(), y), this.buildList(x, this.internalLiteral(y)), "diff");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> sum(N x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getClass(), y.getJavaType()), ExpressionMath.add((Expression)new ConstantExpression(x, ((InternalSelection)((Object)y)).getCurrentNode()), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(this.internalLiteral(x), y), "sum");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> prod(N x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getClass(), y.getJavaType()), ExpressionMath.multiply((Expression)new ConstantExpression(x, ((InternalSelection)((Object)y)).getCurrentNode()), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(this.internalLiteral(x), y), "prod");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> diff(N x, jakarta.persistence.criteria.Expression<? extends N> y) {
        jakarta.persistence.criteria.Expression<N> literal = this.internalLiteral(x);
        return new FunctionExpressionImpl(this.metamodel, literal.getJavaType(), ExpressionMath.subtract(((InternalSelection)((Object)literal)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(literal, y), "diff");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Number> quot(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new FunctionExpressionImpl<Number>(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getJavaType(), y.getClass()), ExpressionMath.divide(((InternalSelection)((Object)x)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "quot");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Number> quot(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new FunctionExpressionImpl<Number>(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getJavaType(), y.getClass()), ExpressionMath.divide(((InternalSelection)((Object)x)).getCurrentNode(), y), this.buildList(x, this.internalLiteral(y)), "quot");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Number> quot(Number x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new FunctionExpressionImpl<Number>(this.metamodel, ClassConstants.NUMBER, ExpressionMath.divide((Expression)new ConstantExpression(x, ((InternalSelection)((Object)y)).getCurrentNode()), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(this.internalLiteral(x), y), "quot");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Integer> mod(jakarta.persistence.criteria.Expression<Integer> x, jakarta.persistence.criteria.Expression<Integer> y) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod(((InternalSelection)((Object)x)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "mod");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Integer> mod(jakarta.persistence.criteria.Expression<Integer> x, Integer y) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod(((InternalSelection)((Object)x)).getCurrentNode(), y), this.buildList(x, this.internalLiteral(y)), "mod");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Integer> mod(Integer x, jakarta.persistence.criteria.Expression<Integer> y) {
        jakarta.persistence.criteria.Expression<Integer> xExp = this.internalLiteral(x);
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod(((InternalSelection)((Object)xExp)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(xExp, y), "mod");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Double> sqrt(jakarta.persistence.criteria.Expression<? extends Number> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.sqrt(((InternalSelection)((Object)x)).getCurrentNode()), this.buildList(x), "sqrt");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Integer> sign(jakarta.persistence.criteria.Expression<? extends Number> x) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.sign(((InternalSelection)((Object)x)).getCurrentNode()), this.buildList(x), "sign");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> ceiling(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.ceil(((InternalSelection)((Object)x)).getCurrentNode()), this.buildList(x), "ceiling");
    }

    @Override
    public <N extends Number> jakarta.persistence.criteria.Expression<N> floor(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.floor(((InternalSelection)((Object)x)).getCurrentNode()), this.buildList(x), "floor");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Double> exp(jakarta.persistence.criteria.Expression<? extends Number> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.exp(((InternalSelection)((Object)x)).getCurrentNode()), this.buildList(x), "exp");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Double> ln(jakarta.persistence.criteria.Expression<? extends Number> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.ln(((InternalSelection)((Object)x)).getCurrentNode()), this.buildList(x), "ln");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Double> power(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.power(((InternalSelection)((Object)x)).getCurrentNode(), ((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "power");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Double> power(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.power(((InternalSelection)((Object)x)).getCurrentNode(), y), this.buildList(x, this.internalLiteral(y)), "power");
    }

    @Override
    public <T extends Number> jakarta.persistence.criteria.Expression<T> round(jakarta.persistence.criteria.Expression<T> x, Integer n) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.round(((InternalSelection)((Object)x)).getCurrentNode(), n), this.buildList(x, this.internalLiteral(n)), "round");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Long> toLong(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public jakarta.persistence.criteria.Expression<Integer> toInteger(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public jakarta.persistence.criteria.Expression<Float> toFloat(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public jakarta.persistence.criteria.Expression<Double> toDouble(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public jakarta.persistence.criteria.Expression<BigDecimal> toBigDecimal(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public jakarta.persistence.criteria.Expression<BigInteger> toBigInteger(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> toString(jakarta.persistence.criteria.Expression<Character> character) {
        ExpressionImpl impl = (ExpressionImpl)character;
        return impl;
    }

    @Override
    public <T> jakarta.persistence.criteria.Expression<T> literal(T value) {
        if (value == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa_criteriaapi_null_literal_value", new Object[0]));
        }
        return new ExpressionImpl(this.metamodel, value.getClass(), new ConstantExpression(value, new ExpressionBuilder()), value);
    }

    @Override
    public <T> jakarta.persistence.criteria.Expression<T> nullLiteral(Class<T> resultClass) {
        return new ExpressionImpl<T>(this.metamodel, resultClass, new ConstantExpression(null, new ExpressionBuilder()), null);
    }

    protected <T> jakarta.persistence.criteria.Expression<T> internalLiteral(T value) {
        return new ExpressionImpl(this.metamodel, value == null ? null : value.getClass(), new ConstantExpression(value, new ExpressionBuilder()), value);
    }

    @Override
    public <T> ParameterExpression<T> parameter(Class<T> paramClass) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass);
    }

    @Override
    public <T> ParameterExpression<T> parameter(Class<T> paramClass, String name) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass, name);
    }

    @Override
    public <C extends Collection<?>> Predicate isEmpty(jakarta.persistence.criteria.Expression<C> collection) {
        if (((InternalExpression)((Object)collection)).isLiteral()) {
            if (((Collection)((ConstantExpression)((InternalSelection)((Object)collection)).getCurrentNode()).getValue()).isEmpty()) {
                return this.conjunction();
            }
            return this.disjunction();
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().size(ClassConstants.INTEGER).equal(0), this.buildList(collection), "isEmpty");
    }

    @Override
    public <C extends Collection<?>> Predicate isNotEmpty(jakarta.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().size(ClassConstants.INTEGER).equal(0).not(), this.buildList(collection), "isNotEmpty");
    }

    @Override
    public <C extends Collection<?>> jakarta.persistence.criteria.Expression<Integer> size(C collection) {
        return this.internalLiteral(collection.size());
    }

    @Override
    public <C extends Collection<?>> jakarta.persistence.criteria.Expression<Integer> size(jakarta.persistence.criteria.Expression<C> collection) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)collection)).getCurrentNode().size(ClassConstants.INTEGER), this.buildList(collection), SIZE);
    }

    @Override
    public <E, C extends Collection<E>> Predicate isMember(E elem, jakarta.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().equal(elem), this.buildList(collection, this.internalLiteral(elem)), "isMember");
    }

    @Override
    public <E, C extends Collection<E>> Predicate isNotMember(E elem, jakarta.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().notEqual(elem), this.buildList(collection, this.internalLiteral(elem)), "isMember");
    }

    @Override
    public <E, C extends Collection<E>> Predicate isMember(jakarta.persistence.criteria.Expression<E> elem, jakarta.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().equal(((InternalSelection)((Object)elem)).getCurrentNode()), this.buildList(collection, elem), "isMember");
    }

    @Override
    public <E, C extends Collection<E>> Predicate isNotMember(jakarta.persistence.criteria.Expression<E> elem, jakarta.persistence.criteria.Expression<C> collection) {
        ReportQuery subQuery = new ReportQuery();
        subQuery.setReferenceClass(((ExpressionImpl)elem).getJavaType());
        ExpressionBuilder elemBuilder = new ExpressionBuilder();
        Expression collectionExp = ((InternalSelection)((Object)collection)).getCurrentNode();
        Expression elemExp = ((InternalSelection)((Object)elem)).getCurrentNode();
        subQuery.setExpressionBuilder(elemBuilder);
        subQuery.setShouldRetrieveFirstPrimaryKey(true);
        subQuery.setSelectionCriteria(elemBuilder.equal(collectionExp).and(collectionExp.equal(elemExp)));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)elem)).getCurrentNode().notExists(subQuery), this.buildList(elem, collection), "isNotMemeber");
    }

    @Override
    public <V, M extends Map<?, V>> jakarta.persistence.criteria.Expression<Collection<V>> values(M map) {
        return this.internalLiteral(map.values());
    }

    @Override
    public <K, M extends Map<K, ?>> jakarta.persistence.criteria.Expression<Set<K>> keys(M map) {
        return this.internalLiteral(map.keySet());
    }

    @Override
    public Predicate like(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().like(((InternalSelection)((Object)pattern)).getCurrentNode()), this.buildList(x, pattern), "like");
    }

    @Override
    public Predicate like(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, jakarta.persistence.criteria.Expression<Character> escapeChar) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().like(((InternalSelection)((Object)pattern)).getCurrentNode(), ((InternalSelection)((Object)escapeChar)).getCurrentNode()), this.buildList(x, pattern, escapeChar), "like");
    }

    @Override
    public Predicate like(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, char escapeChar) {
        return this.like(x, pattern, this.internalLiteral(Character.valueOf(escapeChar)));
    }

    @Override
    public Predicate like(jakarta.persistence.criteria.Expression<String> x, String pattern) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().like(pattern), this.buildList(x, this.internalLiteral(pattern)), "like");
    }

    @Override
    public Predicate like(jakarta.persistence.criteria.Expression<String> x, String pattern, jakarta.persistence.criteria.Expression<Character> escapeChar) {
        return this.like(x, this.internalLiteral(pattern), escapeChar);
    }

    @Override
    public Predicate like(jakarta.persistence.criteria.Expression<String> x, String pattern, char escapeChar) {
        String escapeString = String.valueOf(escapeChar);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().like(pattern, escapeString), this.buildList(x, this.internalLiteral(pattern), this.internalLiteral(Character.valueOf(escapeChar))), "like");
    }

    @Override
    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notLike(((InternalSelection)((Object)pattern)).getCurrentNode()), this.buildList(x, pattern), "notLike");
    }

    @Override
    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, jakarta.persistence.criteria.Expression<Character> escapeChar) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notLike(((InternalSelection)((Object)pattern)).getCurrentNode(), ((InternalSelection)((Object)escapeChar)).getCurrentNode()), this.buildList(x, pattern, escapeChar), "like");
    }

    @Override
    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, char escapeChar) {
        return this.notLike(x, pattern, this.internalLiteral(Character.valueOf(escapeChar)));
    }

    @Override
    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, String pattern) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notLike(pattern), this.buildList(x, this.internalLiteral(pattern)), "notLike");
    }

    @Override
    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, String pattern, jakarta.persistence.criteria.Expression<Character> escapeChar) {
        return this.notLike(x, this.internalLiteral(pattern), escapeChar);
    }

    @Override
    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, String pattern, char escapeChar) {
        return this.notLike(x, this.internalLiteral(pattern), this.internalLiteral(Character.valueOf(escapeChar)));
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> concat(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> y) {
        Expression xNode = ((InternalSelection)((Object)x)).getCurrentNode();
        Expression yNode = ((InternalSelection)((Object)y)).getCurrentNode();
        if (xNode.isParameterExpression() && yNode.isParameterExpression()) {
            ((org.eclipse.persistence.internal.expressions.ParameterExpression)xNode).setType(ClassConstants.STRING);
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, xNode.concat(yNode), this.buildList(x, y), CONCAT);
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> concat(jakarta.persistence.criteria.Expression<String> x, String y) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().concat(y), this.buildList(x, this.internalLiteral(y)), CONCAT);
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> concat(String x, jakarta.persistence.criteria.Expression<String> y) {
        jakarta.persistence.criteria.Expression<String> literal = this.internalLiteral(x);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)literal)).getCurrentNode().concat(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(literal, y), CONCAT);
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> substring(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<Integer> from) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().substring(((InternalSelection)((Object)from)).getCurrentNode()), this.buildList(x, from), "subString");
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> substring(jakarta.persistence.criteria.Expression<String> x, int from) {
        return this.substring(x, this.internalLiteral(from));
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> substring(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<Integer> from, jakarta.persistence.criteria.Expression<Integer> len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().substring(((InternalSelection)((Object)from)).getCurrentNode(), ((InternalSelection)((Object)len)).getCurrentNode()), this.buildList(x, from, len), "subString");
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> substring(jakarta.persistence.criteria.Expression<String> x, int from, int len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().substring(from, len), this.buildList(x, this.internalLiteral(from), this.internalLiteral(len)), "subString");
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> trim(jakarta.persistence.criteria.Expression<String> x) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().trim(), this.buildList(x), "trim");
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, jakarta.persistence.criteria.Expression<String> x) {
        if (ts == CriteriaBuilder.Trimspec.LEADING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().leftTrim(), this.buildList(x), "leftTrim");
        }
        if (ts == CriteriaBuilder.Trimspec.TRAILING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().rightTrim(), this.buildList(x), "rightTrim");
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().rightTrim().leftTrim(), this.buildList(x), "bothTrim");
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> trim(jakarta.persistence.criteria.Expression<Character> t, jakarta.persistence.criteria.Expression<String> x) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().trim(((InternalSelection)((Object)t)).getCurrentNode()), this.buildList(x, t), "trim");
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, jakarta.persistence.criteria.Expression<Character> t, jakarta.persistence.criteria.Expression<String> x) {
        if (ts == CriteriaBuilder.Trimspec.LEADING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().leftTrim(((InternalSelection)((Object)t)).getCurrentNode()), this.buildList(x, t), "leftTrim");
        }
        if (ts == CriteriaBuilder.Trimspec.TRAILING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().rightTrim(((InternalSelection)((Object)t)).getCurrentNode()), this.buildList(x, t), "rightTrim");
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().rightTrim(((InternalSelection)((Object)t)).getCurrentNode()).leftTrim(((InternalSelection)((Object)t)).getCurrentNode()), this.buildList(x, t), "bothTrim");
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> trim(char t, jakarta.persistence.criteria.Expression<String> x) {
        return this.trim(this.internalLiteral(Character.valueOf(t)), x);
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, char t, jakarta.persistence.criteria.Expression<String> x) {
        return this.trim(ts, this.internalLiteral(Character.valueOf(t)), x);
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> lower(jakarta.persistence.criteria.Expression<String> x) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().toLowerCase(), this.buildList(x), "lower");
    }

    @Override
    public jakarta.persistence.criteria.Expression<String> upper(jakarta.persistence.criteria.Expression<String> x) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x)).getCurrentNode().toUpperCase(), this.buildList(x), "upper");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Integer> length(jakarta.persistence.criteria.Expression<String> x) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x)).getCurrentNode().length(), this.buildList(x), "length");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Integer> locate(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x)).getCurrentNode().locate(((InternalSelection)((Object)pattern)).getCurrentNode()), this.buildList(x, pattern), "locate");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Integer> locate(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, jakarta.persistence.criteria.Expression<Integer> from) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x)).getCurrentNode().locate(((InternalSelection)((Object)pattern)).getCurrentNode(), ((InternalSelection)((Object)from)).getCurrentNode()), this.buildList(x, pattern, from), "locate");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Integer> locate(jakarta.persistence.criteria.Expression<String> x, String pattern) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x)).getCurrentNode().locate(pattern), this.buildList(x, this.internalLiteral(pattern)), "locate");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Integer> locate(jakarta.persistence.criteria.Expression<String> x, String pattern, int from) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x)).getCurrentNode().locate(pattern, from), this.buildList(x, this.internalLiteral(pattern), this.internalLiteral(from)), "locate");
    }

    @Override
    public jakarta.persistence.criteria.Expression<Date> currentDate() {
        return new ExpressionImpl<Date>(this.metamodel, ClassConstants.SQLDATE, new ExpressionBuilder().currentDateDate());
    }

    @Override
    public jakarta.persistence.criteria.Expression<Timestamp> currentTimestamp() {
        return new ExpressionImpl<Timestamp>(this.metamodel, ClassConstants.TIMESTAMP, new ExpressionBuilder().currentTimeStamp());
    }

    @Override
    public jakarta.persistence.criteria.Expression<Time> currentTime() {
        return new ExpressionImpl<Time>(this.metamodel, ClassConstants.TIME, new ExpressionBuilder().currentTime());
    }

    @Override
    public jakarta.persistence.criteria.Expression<LocalDateTime> localDateTime() {
        return new ExpressionImpl<LocalDateTime>(this.metamodel, ClassConstants.LOCAL_DATETIME, new ExpressionBuilder().localDateTime());
    }

    @Override
    public jakarta.persistence.criteria.Expression<LocalDate> localDate() {
        return new ExpressionImpl<LocalDate>(this.metamodel, ClassConstants.LOCAL_DATE, new ExpressionBuilder().localDate());
    }

    @Override
    public jakarta.persistence.criteria.Expression<LocalTime> localTime() {
        return new ExpressionImpl<LocalTime>(this.metamodel, ClassConstants.LOCAL_TIME, new ExpressionBuilder().localTime());
    }

    @Override
    public <T> CriteriaBuilder.In<T> in(jakarta.persistence.criteria.Expression<? extends T> expression) {
        return new InImpl(this.metamodel, (ExpressionImpl)expression, new ArrayList(), this.buildList(expression));
    }

    @Override
    public <Y> jakarta.persistence.criteria.Expression<Y> coalesce(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        ArgumentListFunctionExpression coalesce = ((InternalSelection)((Object)x)).getCurrentNode().coalesce();
        Expression expX = ((InternalSelection)((Object)x)).getCurrentNode();
        expX = Expression.from(expX, coalesce);
        coalesce.addChild(expX);
        Expression expY = ((InternalSelection)((Object)y)).getCurrentNode();
        expY = Expression.from(expY, coalesce);
        coalesce.addChild(expY);
        return new CoalesceImpl(this.metamodel, x.getJavaType(), coalesce, this.buildList(x, y), "coalesce");
    }

    @Override
    public <Y> jakarta.persistence.criteria.Expression<Y> coalesce(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        ArgumentListFunctionExpression coalesce = ((InternalSelection)((Object)x)).getCurrentNode().coalesce();
        Expression expX = ((InternalSelection)((Object)x)).getCurrentNode();
        expX = Expression.from(expX, coalesce);
        coalesce.addChild(expX);
        Expression expY = Expression.from(y, new ExpressionBuilder());
        coalesce.addChild(expY);
        return new CoalesceImpl(this.metamodel, x.getJavaType(), coalesce, this.buildList(x, this.internalLiteral(y)), "coalesce");
    }

    @Override
    public <Y> jakarta.persistence.criteria.Expression<Y> nullif(jakarta.persistence.criteria.Expression<Y> x, jakarta.persistence.criteria.Expression<?> y) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().nullIf(((InternalSelection)((Object)y)).getCurrentNode()), this.buildList(x, y), "nullIf");
    }

    @Override
    public <Y> jakarta.persistence.criteria.Expression<Y> nullif(jakarta.persistence.criteria.Expression<Y> x, Y y) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().nullIf(y), this.buildList(x, this.internalLiteral(y)), "nullIf");
    }

    @Override
    public <T> CriteriaBuilder.Coalesce<T> coalesce() {
        ArgumentListFunctionExpression coalesce = new ExpressionBuilder().coalesce();
        return new CoalesceImpl<Object>(this.metamodel, Object.class, coalesce, new ArrayList());
    }

    @Override
    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(jakarta.persistence.criteria.Expression<? extends C> expression) {
        ArgumentListFunctionExpression caseStatement = new ExpressionBuilder().caseStatement();
        return new SimpleCaseImpl<C, Object>(this.metamodel, Object.class, caseStatement, new ArrayList(), expression);
    }

    @Override
    public <R> CriteriaBuilder.Case<R> selectCase() {
        ArgumentListFunctionExpression caseStatement = new ExpressionBuilder().caseConditionStatement();
        return new CaseImpl<Object>(this.metamodel, Object.class, caseStatement, new ArrayList());
    }

    @Override
    public <T> jakarta.persistence.criteria.Expression<T> function(String name, Class<T> type2, jakarta.persistence.criteria.Expression<?> ... args) {
        if (args != null && args.length > 0) {
            ArrayList<Expression> params = new ArrayList<Expression>();
            for (int index = 1; index < args.length; ++index) {
                jakarta.persistence.criteria.Expression<?> x = args[index];
                params.add(((InternalSelection)((Object)x)).getCurrentNode());
            }
            return new FunctionExpressionImpl<T>(this.metamodel, type2, ((InternalSelection)((Object)args[0])).getCurrentNode().getFunctionWithArguments(name, params), this.buildList(args), name);
        }
        return new FunctionExpressionImpl<T>(this.metamodel, type2, new ExpressionBuilder().getFunction(name), new ArrayList(0), name);
    }

    @Override
    public <T> jakarta.persistence.criteria.Expression<T> fromExpression(Expression expression, Class<T> type2) {
        return new FunctionExpressionImpl<T>(this.metamodel, type2, expression, new ArrayList(0));
    }

    @Override
    public jakarta.persistence.criteria.Expression fromExpression(Expression expression) {
        return new FunctionExpressionImpl<Object>(this.metamodel, Object.class, expression, new ArrayList(0));
    }

    @Override
    public Expression toExpression(jakarta.persistence.criteria.Expression expression) {
        return ((SelectionImpl)((Object)expression)).getCurrentNode();
    }

    @Override
    public <T> CriteriaDelete<T> createCriteriaDelete(Class<T> targetEntity) {
        TypeImpl<T> type2;
        if (targetEntity != null && (type2 = ((MetamodelImpl)this.metamodel).getType(targetEntity)) != null && type2.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaDeleteImpl<T>(this.metamodel, this, targetEntity);
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_bean_class", new Object[]{targetEntity}));
    }

    @Override
    public <T> CriteriaUpdate<T> createCriteriaUpdate(Class<T> targetEntity) {
        TypeImpl<T> type2;
        if (targetEntity != null && (type2 = ((MetamodelImpl)this.metamodel).getType(targetEntity)) != null && type2.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaUpdateImpl<T>(this.metamodel, this, targetEntity);
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_bean_class", new Object[]{targetEntity}));
    }

    @Override
    public <X, T, V extends T> Join<X, V> treat(Join<X, T> join, Class<V> type2) {
        JoinImpl parentJoin = (JoinImpl)join;
        JoinImpl joinImpl = new JoinImpl(parentJoin, this.metamodel.managedType(type2), this.metamodel, type2, parentJoin.currentNode.treat(type2), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        joinImpl.isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    @Override
    public <X, T, E extends T> CollectionJoin<X, E> treat(CollectionJoin<X, T> join, Class<E> type2) {
        CollectionJoinImpl parentJoin = (CollectionJoinImpl)join;
        CollectionJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicCollectionJoinImpl ? new BasicCollectionJoinImpl(parentJoin, this.metamodel, type2, parentJoin.currentNode.treat(type2), parentJoin.getModel(), parentJoin.getJoinType()) : new CollectionJoinImpl(join, this.metamodel.managedType(type2), this.metamodel, type2, parentJoin.currentNode.treat(type2), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    @Override
    public <X, T, E extends T> SetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type2) {
        SetJoinImpl parentJoin = (SetJoinImpl)join;
        SetJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicSetJoinImpl ? new BasicSetJoinImpl(parentJoin, this.metamodel, type2, parentJoin.currentNode.treat(type2), parentJoin.getModel(), parentJoin.getJoinType()) : new SetJoinImpl(join, this.metamodel.managedType(type2), this.metamodel, type2, parentJoin.currentNode.treat(type2), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    @Override
    public <X, T, E extends T> ListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type2) {
        ListJoinImpl parentJoin = (ListJoinImpl)join;
        ListJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicListJoinImpl ? new BasicListJoinImpl(parentJoin, this.metamodel, type2, parentJoin.currentNode.treat(type2), parentJoin.getModel(), parentJoin.getJoinType()) : new ListJoinImpl(join, this.metamodel.managedType(type2), this.metamodel, type2, parentJoin.currentNode.treat(type2), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    @Override
    public <X, K, T, V extends T> MapJoin<X, K, V> treat(MapJoin<X, K, T> join, Class<V> type2) {
        MapJoinImpl parentJoin = (MapJoinImpl)join;
        MapJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicMapJoinImpl ? new BasicMapJoinImpl(parentJoin, this.metamodel, type2, parentJoin.currentNode.treat(type2), parentJoin.getModel(), parentJoin.getJoinType()) : new MapJoinImpl(join, (ManagedType)this.metamodel.managedType(type2), this.metamodel, type2, parentJoin.currentNode.treat(type2), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    @Override
    public <X, T extends X> Path<T> treat(Path<X> path, Class<T> type2) {
        PathImpl parentPath = (PathImpl)path;
        PathImpl newPath = (PathImpl)parentPath.clone();
        newPath.currentNode = newPath.currentNode.treat(type2);
        newPath.pathParent = parentPath;
        newPath.javaType = type2;
        newPath.modelArtifact = this.metamodel.managedType(type2);
        return newPath;
    }

    @Override
    public <X, T extends X> Root<T> treat(Root<X> root, Class<T> type2) {
        RootImpl parentRoot = (RootImpl)root;
        EntityType<T> entity = this.metamodel.entity(type2);
        return new RootImpl<T>(entity, this.metamodel, type2, parentRoot.currentNode.treat(type2), entity);
    }

    public class SimpleCaseImpl<C, R>
    extends FunctionExpressionImpl<R>
    implements CriteriaBuilder.SimpleCase<C, R> {
        private jakarta.persistence.criteria.Expression<C> expression;
        private jakarta.persistence.criteria.Expression<? extends R> elseExpression;

        protected <T> SimpleCaseImpl(Metamodel metamodel, Class<R> resultClass, FunctionExpression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions, jakarta.persistence.criteria.Expression<C> expression) {
            super(metamodel, resultClass, (Expression)expressionNode, compoundExpressions);
            this.expression = expression;
            expressionNode.addChild(((InternalSelection)((Object)expression)).getCurrentNode());
        }

        protected <T> SimpleCaseImpl(Metamodel metamodel, Class<R> resultClass, FunctionExpression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions, String operator, jakarta.persistence.criteria.Expression<C> expression) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
            this.expression = expression;
            expressionNode.addChild(((InternalSelection)((Object)expression)).getCurrentNode());
        }

        @Override
        public jakarta.persistence.criteria.Expression<C> getExpression() {
            return this.expression;
        }

        @Override
        public CriteriaBuilder.SimpleCase<C, R> when(C condition, R result) {
            Expression conditionExp = Expression.from(condition, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            jakarta.persistence.criteria.Expression<C> conditionLiteral = CriteriaBuilderImpl.this.internalLiteral(condition);
            this.expressions.add(conditionLiteral);
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            jakarta.persistence.criteria.Expression<R> resultLiteral = CriteriaBuilderImpl.this.internalLiteral(result);
            this.expressions.add(resultLiteral);
            this.setJavaType(resultLiteral.getJavaType());
            return this;
        }

        @Override
        public CriteriaBuilder.SimpleCase<C, R> when(C condition, jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression conditionExp = Expression.from(condition, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            jakarta.persistence.criteria.Expression<C> conditionLiteral = CriteriaBuilderImpl.this.internalLiteral(condition);
            this.expressions.add(conditionLiteral);
            Expression resultExp = ((InternalSelection)((Object)result)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            this.expressions.add(result);
            this.setJavaType(result.getJavaType());
            return this;
        }

        @Override
        public CriteriaBuilder.SimpleCase<C, R> when(jakarta.persistence.criteria.Expression<? extends C> condition, R result) {
            Expression conditionExp = ((InternalSelection)((Object)condition)).getCurrentNode();
            conditionExp = Expression.from(conditionExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            this.expressions.add(condition);
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            jakarta.persistence.criteria.Expression<R> resultLiteral = CriteriaBuilderImpl.this.internalLiteral(result);
            this.expressions.add(resultLiteral);
            this.setJavaType(resultLiteral.getJavaType());
            return this;
        }

        @Override
        public CriteriaBuilder.SimpleCase<C, R> when(jakarta.persistence.criteria.Expression<? extends C> condition, jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression conditionExp = ((InternalSelection)((Object)condition)).getCurrentNode();
            conditionExp = Expression.from(conditionExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            this.expressions.add(condition);
            Expression resultExp = ((InternalSelection)((Object)result)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            this.expressions.add(result);
            this.setJavaType(result.getJavaType());
            return this;
        }

        @Override
        public jakarta.persistence.criteria.Expression<R> otherwise(R result) {
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            jakarta.persistence.criteria.Expression<R> resultLiteral = CriteriaBuilderImpl.this.internalLiteral(result);
            this.elseExpression = resultLiteral;
            this.setJavaType(resultLiteral.getJavaType());
            return this;
        }

        @Override
        public jakarta.persistence.criteria.Expression<R> otherwise(jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression resultExp = ((InternalSelection)((Object)result)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            this.elseExpression = result;
            this.setJavaType(result.getJavaType());
            return this;
        }

        @Override
        public void findRootAndParameters(CommonAbstractCriteriaImpl query) {
            super.findRootAndParameters(query);
            if (this.expression != null) {
                ((InternalSelection)((Object)this.expression)).findRootAndParameters(query);
            }
            if (this.elseExpression != null) {
                ((InternalSelection)((Object)this.elseExpression)).findRootAndParameters(query);
            }
        }
    }

    public class CaseImpl<R>
    extends FunctionExpressionImpl<R>
    implements CriteriaBuilder.Case<R> {
        private jakarta.persistence.criteria.Expression<? extends R> elseExpression;

        protected <T> CaseImpl(Metamodel metamodel, Class<R> resultClass, Expression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions) {
            super(metamodel, resultClass, expressionNode, compoundExpressions);
        }

        protected <T> CaseImpl(Metamodel metamodel, Class<R> resultClass, Expression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions, String operator) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
        }

        @Override
        public CriteriaBuilder.Case<R> when(jakarta.persistence.criteria.Expression<Boolean> condition, R result) {
            Expression conditionExp = ((InternalSelection)((Object)condition)).getCurrentNode();
            conditionExp = Expression.from(conditionExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            this.expressions.add(condition);
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            jakarta.persistence.criteria.Expression<R> resultLiteral = CriteriaBuilderImpl.this.internalLiteral(result);
            this.expressions.add(resultLiteral);
            this.setJavaType(resultLiteral.getJavaType());
            return this;
        }

        @Override
        public CriteriaBuilder.Case<R> when(jakarta.persistence.criteria.Expression<Boolean> condition, jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression conditionExp = ((InternalSelection)((Object)condition)).getCurrentNode();
            conditionExp = Expression.from(conditionExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            this.expressions.add(condition);
            Expression resultExp = ((InternalSelection)((Object)result)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            this.expressions.add(result);
            this.setJavaType(result.getJavaType());
            return this;
        }

        @Override
        public jakarta.persistence.criteria.Expression<R> otherwise(R result) {
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            jakarta.persistence.criteria.Expression<R> resultLiteral = CriteriaBuilderImpl.this.internalLiteral(result);
            this.elseExpression = resultLiteral;
            this.setJavaType(resultLiteral.getJavaType());
            return this;
        }

        @Override
        public jakarta.persistence.criteria.Expression<R> otherwise(jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression resultExp = ((InternalSelection)((Object)result)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            this.elseExpression = result;
            this.setJavaType(result.getJavaType());
            return this;
        }

        @Override
        public void findRootAndParameters(CommonAbstractCriteriaImpl query) {
            super.findRootAndParameters(query);
            if (this.elseExpression != null) {
                ((InternalSelection)((Object)this.elseExpression)).findRootAndParameters(query);
            }
        }
    }

    public class CoalesceImpl<X>
    extends FunctionExpressionImpl<X>
    implements CriteriaBuilder.Coalesce<X> {
        protected <T> CoalesceImpl(Metamodel metamodel, Class<X> resultClass, Expression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions) {
            super(metamodel, resultClass, expressionNode, compoundExpressions);
        }

        protected <T> CoalesceImpl(Metamodel metamodel, Class<X> resultClass, Expression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions, String operator) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
        }

        @Override
        public CriteriaBuilder.Coalesce<X> value(X value) {
            Expression exp = Expression.from(value, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(exp);
            jakarta.persistence.criteria.Expression<X> valueLiteral = CriteriaBuilderImpl.this.internalLiteral(value);
            this.expressions.add(valueLiteral);
            return this;
        }

        @Override
        public CriteriaBuilder.Coalesce<X> value(jakarta.persistence.criteria.Expression<? extends X> value) {
            Expression exp = ((InternalSelection)((Object)value)).getCurrentNode();
            exp = Expression.from(exp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(exp);
            this.expressions.add(value);
            return this;
        }
    }
}

