/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedIdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ForeignKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyForeignKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.RelationTableMechanism;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public abstract class ObjectAccessor
extends RelationshipAccessor {
    private Boolean m_id;
    private Boolean m_optional;
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
    private PrimaryKeyForeignKeyMetadata m_primaryKeyForeignKey;
    private String m_mapsId;

    protected ObjectAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected ObjectAccessor(MetadataAnnotation annotation, MetadataAnnotatedElement annotatedElement, ClassAccessor classAccessor) {
        super(annotation, (MetadataAccessibleObject)annotatedElement, classAccessor);
        if (annotation != null) {
            this.m_optional = annotation.getAttributeBooleanDefaultTrue("optional");
        }
        if (this.isAnnotationPresent("jakarta.persistence.PrimaryKeyJoinColumns")) {
            MetadataAnnotation primaryKeyJoinColumns = this.getAnnotation("jakarta.persistence.PrimaryKeyJoinColumns");
            for (Object primaryKeyJoinColumn : primaryKeyJoinColumns.getAttributeArray("value")) {
                this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata((MetadataAnnotation)primaryKeyJoinColumn, this));
            }
            if (primaryKeyJoinColumns.hasAttribute("foreignKey")) {
                this.setPrimaryKeyForeignKey(new PrimaryKeyForeignKeyMetadata(primaryKeyJoinColumns.getAttributeAnnotation("foreignKey"), this));
            }
        }
        if (this.isAnnotationPresent("jakarta.persistence.PrimaryKeyJoinColumn")) {
            PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn = new PrimaryKeyJoinColumnMetadata(this.getAnnotation("jakarta.persistence.PrimaryKeyJoinColumn"), this);
            this.m_primaryKeyJoinColumns.add(primaryKeyJoinColumn);
            if (primaryKeyJoinColumn.hasForeignKey()) {
                this.setPrimaryKeyForeignKey(new PrimaryKeyForeignKeyMetadata(primaryKeyJoinColumn.getForeignKey()));
            }
        }
        if (this.isAnnotationPresent("jakarta.persistence.MapsId")) {
            this.m_mapsId = this.getAnnotation("jakarta.persistence.MapsId").getAttributeString("value", "");
        }
        this.m_id = this.isAnnotationPresent("jakarta.persistence.Id");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof ObjectAccessor) {
            ObjectAccessor objectAccessor = (ObjectAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_id, objectAccessor.getId())) {
                return false;
            }
            if (!this.valuesMatch(this.m_optional, objectAccessor.getOptional())) {
                return false;
            }
            if (!this.valuesMatch(this.m_primaryKeyJoinColumns, objectAccessor.getPrimaryKeyJoinColumns())) {
                return false;
            }
            if (!this.valuesMatch(this.m_primaryKeyForeignKey, objectAccessor.getPrimaryKeyForeignKey())) {
                return false;
            }
            return this.valuesMatch(this.m_mapsId, objectAccessor.getMapsId());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_id != null ? this.m_id.hashCode() : 0);
        result = 31 * result + (this.m_optional != null ? this.m_optional.hashCode() : 0);
        result = 31 * result + (this.m_primaryKeyJoinColumns != null ? this.m_primaryKeyJoinColumns.hashCode() : 0);
        result = 31 * result + (this.m_primaryKeyForeignKey != null ? this.m_primaryKeyForeignKey.hashCode() : 0);
        result = 31 * result + (this.m_mapsId != null ? this.m_mapsId.hashCode() : 0);
        return result;
    }

    @Override
    public boolean derivesId() {
        return this.hasId() || this.hasMapsId();
    }

    @Override
    public String getAttributeType() {
        return this.getTargetEntity().getName();
    }

    @Override
    public String getDefaultFetchType() {
        return "EAGER";
    }

    public Boolean getId() {
        return this.m_id;
    }

    public String getMapsId() {
        return this.m_mapsId;
    }

    public PrimaryKeyForeignKeyMetadata getPrimaryKeyForeignKey() {
        return this.m_primaryKeyForeignKey;
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    public Boolean getOptional() {
        return this.m_optional;
    }

    @Override
    public MetadataClass getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass.isVoid()) {
                this.m_referenceClass = super.getReferenceClass();
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    protected MetadataClass getSimplePKType() {
        MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
        ClassAccessor referenceAccessor = referenceDescriptor.getClassAccessor();
        if (referenceAccessor.hasDerivedId()) {
            return ((ObjectAccessor)referenceDescriptor.getMappingAccessor(referenceDescriptor.getIdAttributeName())).getSimplePKType();
        }
        return referenceDescriptor.getMappingAccessor(referenceDescriptor.getIdAttributeName()).getRawClass();
    }

    @Override
    public boolean hasAttributeType() {
        return this.getTargetEntity() != null && !this.getTargetEntity().isVoid();
    }

    protected boolean hasId() {
        return this.m_id != null && this.m_id != false;
    }

    protected boolean hasMapsId() {
        return this.m_mapsId != null;
    }

    protected ObjectReferenceMapping initManyToOneMapping() {
        ObjectReferenceMapping mapping = this.getDescriptor().getClassDescriptor().newManyToOneMapping();
        this.processRelationshipMapping(mapping);
        mapping.setIsOptional(this.isOptional());
        mapping.setDerivesId(this.derivesId());
        this.processIndirection(mapping);
        this.processReturnInsertAndUpdate();
        return mapping;
    }

    protected ObjectReferenceMapping initOneToOneMapping() {
        ObjectReferenceMapping mapping = this.getDescriptor().getClassDescriptor().newOneToOneMapping();
        this.processRelationshipMapping(mapping);
        mapping.setIsOptional(this.isOptional());
        mapping.setDerivesId(this.derivesId());
        this.processIndirection(mapping);
        this.processReturnInsertAndUpdate();
        return mapping;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_primaryKeyJoinColumns, accessibleObject);
        this.initXMLObject(this.m_primaryKeyForeignKey, accessibleObject);
    }

    public boolean isOneToOnePrimaryKeyRelationship() {
        return !this.m_primaryKeyJoinColumns.isEmpty();
    }

    public boolean isOptional() {
        return this.m_optional != null && this.m_optional != false;
    }

    @Override
    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, MetadataDescriptor owningDescriptor) {
        if (this.getMapping().isOneToOneMapping()) {
            this.processAssociationOverride(associationOverride, embeddableMapping, owningDescriptor.getPrimaryTable(), owningDescriptor);
        } else {
            super.processAssociationOverride(associationOverride, embeddableMapping, owningDescriptor);
        }
    }

    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, DatabaseTable defaultTable, MetadataDescriptor owningDescriptor) {
        for (JoinColumnMetadata joinColumn : this.getJoinColumnsAndValidate(associationOverride.getJoinColumns(), this.getReferenceDescriptor())) {
            DatabaseField pkField = this.getReferencedField(joinColumn.getReferencedColumnName(), this.getReferenceDescriptor(), "metadata_default_pk_column");
            DatabaseField fkField = ((OneToOneMapping)this.getMapping()).getTargetToSourceKeyFields().get(pkField);
            if (fkField == null) {
                throw ValidationException.invalidAssociationOverrideReferenceColumnName(pkField.getName(), associationOverride.getName(), embeddableMapping.getAttributeName(), owningDescriptor.getJavaClassName());
            }
            DatabaseField translationFKField = joinColumn.getForeignKeyField(pkField);
            if (!translationFKField.hasTableName()) {
                translationFKField.setTable(defaultTable);
            }
            embeddableMapping.addFieldTranslation(translationFKField, fkField.getName());
        }
    }

    protected void processId(OneToOneMapping mapping) {
        MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
        String referencePKClassName = referenceDescriptor.getPKClassName();
        if (referencePKClassName != null) {
            String pkClassName = this.getDescriptor().getPKClassName();
            if (pkClassName == null) {
                throw ValidationException.invalidCompositePKSpecification(this.getJavaClass(), null);
            }
            if (pkClassName.equals(referencePKClassName)) {
                this.getOwningDescriptor().getPKClassIDs().clear();
            } else {
                this.getOwningDescriptor().validateDerivedPKClassId(this.getAttributeName(), referencePKClassName, this.getReferenceClassName());
            }
        } else {
            MetadataClass type2 = null;
            type2 = referenceDescriptor.getClassAccessor().hasDerivedId() ? ((ObjectAccessor)referenceDescriptor.getMappingAccessor(referenceDescriptor.getIdAttributeName())).getSimplePKType() : referenceDescriptor.getMappingAccessor(referenceDescriptor.getIdAttributeName()).getRawClass();
            this.getOwningDescriptor().validateDerivedPKClassId(this.getAttributeName(), this.getBoxedType(type2.getName()), this.getReferenceClassName());
        }
        this.getOwningDescriptor().addIdAttributeName(this.getAttributeName());
        for (DatabaseField pkField : mapping.getForeignKeyFields()) {
            this.getOwningDescriptor().addPrimaryKeyField(pkField);
        }
    }

    protected void processMapsId(OneToOneMapping oneToOneMapping) {
        EmbeddedIdAccessor embeddedIdAccessor = this.getDescriptor().getEmbeddedIdAccessor();
        if (embeddedIdAccessor == null) {
            MappingAccessor idAccessor = this.getDescriptor().getMappingAccessor(this.getDescriptor().getIdAttributeName());
            DatabaseMapping idMapping = idAccessor.getMapping();
            DatabaseField foreignKeyField = oneToOneMapping.getForeignKeyFields().elementAt(0);
            this.updatePrimaryKeyField(idAccessor, foreignKeyField);
            ((AbstractDirectMapping)idMapping).setField(foreignKeyField);
            idMapping.setIsReadOnly(true);
            oneToOneMapping.setDerivedIdMapping(idMapping);
        } else {
            if (embeddedIdAccessor.getReferenceClassName().equals(this.getReferenceDescriptor().getPKClassName())) {
                this.processMapsIdFields(oneToOneMapping, embeddedIdAccessor, embeddedIdAccessor);
            } else {
                if (this.m_mapsId.equals("")) {
                    this.m_mapsId = this.getAttributeName();
                }
                oneToOneMapping.setMapsIdValue(this.m_mapsId);
                MappingAccessor mappingAccessor = embeddedIdAccessor.getReferenceDescriptor().getMappingAccessor(this.m_mapsId);
                if (mappingAccessor == null) {
                    throw ValidationException.invalidMappedByIdValue(this.m_mapsId, this.getAnnotatedElementName(), embeddedIdAccessor.getReferenceClass());
                }
                this.processMapsIdFields(oneToOneMapping, embeddedIdAccessor, mappingAccessor);
            }
            oneToOneMapping.setDerivedIdMapping(embeddedIdAccessor.getMapping());
        }
    }

    protected void processMapsIdFields(OneToOneMapping oneToOneMapping, EmbeddedIdAccessor embeddedIdAccessor, MappingAccessor mapsIdAccessor) {
        for (DatabaseField fkField : oneToOneMapping.getForeignKeyFields()) {
            if (mapsIdAccessor.isBasic()) {
                embeddedIdAccessor.addMapsIdAccessor(mapsIdAccessor);
                embeddedIdAccessor.updateDerivedIdField((EmbeddableMapping)((Object)embeddedIdAccessor.getMapping()), mapsIdAccessor.getAttributeName(), fkField, mapsIdAccessor);
                continue;
            }
            if (mapsIdAccessor.isDerivedIdClass()) {
                embeddedIdAccessor.addMapsIdAccessor(mapsIdAccessor);
            } else {
                embeddedIdAccessor.getMapping().setIsReadOnly(true);
            }
            DatabaseField referencePKField = oneToOneMapping.getSourceToTargetKeyFields().get(fkField);
            MappingAccessor referencePKAccessor = this.getReferenceDescriptor().getPrimaryKeyAccessorForField(referencePKField);
            if (referencePKAccessor == null) {
                throw ValidationException.invalidDerivedIdPrimaryKeyField(this.getReferenceClassName(), referencePKField.getQualifiedName(), this.getAttributeName(), this.getJavaClassName());
            }
            Set<MappingAccessor> mappingAccessors = this.findAllFieldAccessors(mapsIdAccessor.getReferenceDescriptor());
            ArrayList<MappingAccessor> accessorsWithTargetAttributeName = new ArrayList<MappingAccessor>();
            for (MappingAccessor ma : mappingAccessors) {
                if (!referencePKAccessor.getAttributeName().equals(ma.getAttributeName())) continue;
                accessorsWithTargetAttributeName.add(ma);
            }
            MappingAccessor idAccessor = null;
            idAccessor = accessorsWithTargetAttributeName.size() > 1 && accessorsWithTargetAttributeName.contains(referencePKAccessor) ? (MappingAccessor)accessorsWithTargetAttributeName.get(accessorsWithTargetAttributeName.indexOf(referencePKAccessor)) : mapsIdAccessor.getReferenceDescriptor().getMappingAccessor(referencePKAccessor.getAttributeName());
            ((EmbeddedAccessor)mapsIdAccessor).updateDerivedIdField((EmbeddableMapping)((Object)mapsIdAccessor.getMapping()), idAccessor.getAttributeName(), fkField, idAccessor);
        }
    }

    private Set<MappingAccessor> findAllFieldAccessors(MetadataDescriptor md) {
        HashSet<MappingAccessor> retSet = new HashSet<MappingAccessor>();
        Collection<MappingAccessor> mappingAccessors = md.getMappingAccessors();
        for (MappingAccessor ma : mappingAccessors) {
            if (ma instanceof EmbeddedAccessor) {
                retSet.addAll(this.findAllFieldAccessors(ma.getReferenceDescriptor()));
                continue;
            }
            retSet.add(ma);
        }
        return retSet;
    }

    protected void processForeignKeyRelationship(ObjectReferenceMapping mapping) {
        String defaultFKFieldName = this.getDefaultAttributeName() + "_" + this.getReferenceDescriptor().getPrimaryKeyFieldName();
        List<JoinColumnMetadata> joinColumns = this.getJoinColumns(this.getJoinColumns(), this.getReferenceDescriptor());
        ForeignKeyMetadata foreignKey = this.getForeignKey(this.getForeignKey(), this.getReferenceDescriptor());
        this.processForeignKeyRelationship(mapping, joinColumns, foreignKey, this.getReferenceDescriptor(), defaultFKFieldName, this.getDescriptor().getPrimaryTable());
    }

    protected void processOneToOnePrimaryKeyRelationship(OneToOneMapping mapping) {
        List<PrimaryKeyJoinColumnMetadata> pkJoinColumns = this.processPrimaryKeyJoinColumns(this.getPrimaryKeyJoinColumns());
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn : pkJoinColumns) {
            DatabaseField pkField = this.getReferencedField(primaryKeyJoinColumn.getReferencedColumnName(), this.getReferenceDescriptor(), "metadata_default_pk_column");
            DatabaseField fkField = this.getReferencedField(primaryKeyJoinColumn.getName(), this.getDescriptor(), "metadata_default_fk_column");
            mapping.addForeignKeyField(fkField, pkField);
        }
        mapping.setIsReadOnly(true);
        mapping.setIsOneToOnePrimaryKeyRelationship(true);
        if (this.m_primaryKeyForeignKey != null) {
            this.m_primaryKeyForeignKey.process(this.getDescriptor().getPrimaryKeyTable());
        }
    }

    protected void processOwningMappingKeys(OneToOneMapping mapping) {
        if (this.derivesId()) {
            this.processForeignKeyRelationship(mapping);
            if (this.hasMapsId()) {
                this.processMapsId(mapping);
            } else {
                this.processId(mapping);
            }
        } else if (this.isOneToOnePrimaryKeyRelationship()) {
            this.processOneToOnePrimaryKeyRelationship(mapping);
        } else if (this.hasJoinTable()) {
            mapping.setRelationTableMechanism(new RelationTableMechanism());
            this.processJoinTable(mapping, mapping.getRelationTableMechanism(), this.getJoinTableMetadata());
        } else {
            this.processForeignKeyRelationship(mapping);
        }
    }

    public void setId(Boolean id) {
        this.m_id = id;
    }

    public void setMapsId(String mapsId) {
        this.m_mapsId = mapsId;
    }

    public void setOptional(Boolean isOptional) {
        this.m_optional = isOptional;
    }

    public void setPrimaryKeyForeignKey(PrimaryKeyForeignKeyMetadata primaryKeyForeignKey) {
        this.m_primaryKeyForeignKey = primaryKeyForeignKey;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        this.m_primaryKeyJoinColumns = primaryKeyJoinColumns;
    }
}

