/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.LockTimeoutException;
import jakarta.persistence.Parameter;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.QueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JPQLCallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.JPAQueryBuilder;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class EJBQueryImpl<X>
extends QueryImpl
implements JpaQuery<X> {
    protected EJBQueryImpl(EntityManagerImpl entityManager) {
        super(entityManager);
    }

    public EJBQueryImpl(DatabaseQuery query, EntityManagerImpl entityManager) {
        super(query, entityManager);
    }

    public EJBQueryImpl(String jpql, EntityManagerImpl entityManager) {
        this(jpql, entityManager, false);
    }

    public EJBQueryImpl(String queryDescription, EntityManagerImpl entityManager, boolean isNamedQuery) {
        super(entityManager);
        if (isNamedQuery) {
            this.queryName = queryDescription;
        } else if (this.databaseQuery == null) {
            this.databaseQuery = EJBQueryImpl.buildEJBQLDatabaseQuery(queryDescription, entityManager.getActiveSessionIfExists());
        }
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String jpql, AbstractSession session) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(null, jpql, session, null, null, session.getDatasourcePlatform().getConversionManager().getLoader());
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String queryName, String jpqlQuery, AbstractSession session, Enum lockMode, Map<String, Object> hints, ClassLoader classLoader) {
        boolean isCacheable = queryName == null && hints == null;
        DatabaseQuery databaseQuery = null;
        if (isCacheable) {
            databaseQuery = (DatabaseQuery)session.getProject().getJPQLParseCache().get(jpqlQuery);
        }
        if (databaseQuery == null || !databaseQuery.isPrepared()) {
            ReadAllQuery readQuery;
            JPAQueryBuilder queryBuilder = session.getQueryBuilder();
            databaseQuery = queryBuilder.buildQuery(jpqlQuery, session);
            if (databaseQuery.isReadAllQuery()) {
                ReadAllQuery readAllQuery = (ReadAllQuery)databaseQuery;
                if (readAllQuery.hasJoining() && readAllQuery.getDistinctState() == 2) {
                    readAllQuery.setShouldFilterDuplicates(false);
                }
            } else if (databaseQuery.isModifyQuery()) {
                ((ModifyQuery)databaseQuery).setIsBatchExecutionSupported(false);
            }
            ((JPQLCallQueryMechanism)databaseQuery.getQueryMechanism()).getJPQLCall().setIsParsed(true);
            if (lockMode != null && !lockMode.name().equals("NONE")) {
                if (databaseQuery.isObjectLevelReadQuery()) {
                    if (((ObjectLevelReadQuery)databaseQuery).setLockModeType(lockMode.name(), session)) {
                        throw new PersistenceException(ExceptionLocalization.buildMessage("ejb30-wrong-lock_called_without_version_locking-index", null));
                    }
                } else {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_lock_query", null));
                }
            }
            if ((databaseQuery = EJBQueryImpl.applyHints(hints, databaseQuery, classLoader, session)).isReadAllQuery() && !databaseQuery.isReportQuery() && ((ReadAllQuery)databaseQuery).shouldCheckCache() && (readQuery = (ReadAllQuery)databaseQuery).getContainerPolicy().getContainerClass() == ContainerPolicy.getDefaultContainerClass() && !readQuery.hasHierarchicalExpressions()) {
                databaseQuery.checkDescriptor(session);
                Expression selectionCriteria = databaseQuery.getSelectionCriteria();
                if (selectionCriteria != null && (databaseQuery.getDescriptor().getObjectBuilder().isPrimaryKeyExpression(true, selectionCriteria, session) || databaseQuery.getDescriptor().getCachePolicy().isIndexableExpression(selectionCriteria, databaseQuery.getDescriptor(), session))) {
                    ReadObjectQuery newQuery = new ReadObjectQuery();
                    newQuery.copyFromQuery(databaseQuery);
                    databaseQuery = newQuery;
                }
            }
            if (isCacheable) {
                databaseQuery.checkPrepare(session, new DatabaseRecord());
                session.getProject().getJPQLParseCache().put(jpqlQuery, databaseQuery);
            }
        }
        return databaseQuery;
    }

    public static DatabaseQuery buildSQLDatabaseQuery(Class<?> resultClass, String sqlString, ClassLoader classLoader, AbstractSession session) {
        return EJBQueryImpl.buildSQLDatabaseQuery(resultClass, sqlString, null, classLoader, session);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(Class<?> resultClass, String sqlString, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        ReadAllQuery query = new ReadAllQuery(resultClass);
        query.setCall(((DatasourcePlatform)session.getPlatform((Class)resultClass)).buildNativeCall(sqlString));
        query.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(hints, query, classLoader, session);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlString, ClassLoader classLoader, AbstractSession session) {
        return EJBQueryImpl.buildSQLDatabaseQuery(sqlString, new HashMap<String, Object>(), classLoader, session);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlString, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DataReadQuery query = new DataReadQuery();
        query.setResultType(4);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(hints, query, classLoader, session);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlResultSetMappingName, String sqlString, ClassLoader classLoader, AbstractSession session) {
        return EJBQueryImpl.buildSQLDatabaseQuery(sqlResultSetMappingName, sqlString, null, classLoader, session);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlResultSetMappingName, String sqlString, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        query.setSQLResultSetMappingName(sqlResultSetMappingName);
        query.setCall(((DatasourcePlatform)session.getDatasourcePlatform()).buildNativeCall(sqlString));
        query.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(hints, query, classLoader, session);
    }

    @Override
    public TypedQuery<X> setHint(String hintName, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setHintInternal(hintName, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public EJBQueryImpl setLockMode(LockModeType lockMode) {
        return (EJBQueryImpl)super.setLockMode(lockMode);
    }

    @Override
    public Collection getResultCollection() {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        this.setAsSQLReadQuery();
        this.propagateResultProperties();
        DatabaseQuery query = this.getDatabaseQueryInternal();
        try {
            if (query.isReadAllQuery()) {
                Class<?> containerClass = ((ReadAllQuery)this.getDatabaseQueryInternal()).getContainerPolicy().getContainerClass();
                if (!Helper.classImplementsInterface(containerClass, ClassConstants.Collection_Class)) {
                    throw QueryException.invalidContainerClass(containerClass, ClassConstants.Collection_Class);
                }
            } else {
                if (query.isReadObjectQuery()) {
                    ArrayList<Object> resultList = new ArrayList<Object>();
                    Object result = this.executeReadQuery();
                    if (result != null) {
                        resultList.add(this.executeReadQuery());
                    }
                    return resultList;
                }
                if (!query.isReadQuery()) {
                    throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_collection"));
                }
            }
            return (Collection)this.executeReadQuery();
        }
        catch (LockTimeoutException exception) {
            throw exception;
        }
        catch (PersistenceException exception) {
            this.setRollbackOnly();
            throw exception;
        }
        catch (IllegalStateException exception) {
            this.setRollbackOnly();
            throw exception;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw new PersistenceException(exception);
        }
    }

    @Override
    public Cursor getResultCursor() {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        try {
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            if (this.getDatabaseQueryInternal() instanceof ReadAllQuery) {
                if (!((ReadAllQuery)this.getDatabaseQueryInternal()).getContainerPolicy().isCursorPolicy()) {
                    Class<?> containerClass = ((ReadAllQuery)this.getDatabaseQueryInternal()).getContainerPolicy().getContainerClass();
                    throw QueryException.invalidContainerClass(containerClass, Cursor.class);
                }
            } else {
                if (this.getDatabaseQueryInternal() instanceof ReadObjectQuery) {
                    throw QueryException.incorrectQueryObjectFound(this.getDatabaseQueryInternal(), ReadAllQuery.class);
                }
                if (!(this.getDatabaseQueryInternal() instanceof ReadQuery)) {
                    throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_collection"));
                }
            }
            Object result = this.executeReadQuery();
            return (Cursor)result;
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (PersistenceException exception) {
            this.setRollbackOnly();
            throw exception;
        }
        catch (IllegalStateException exception) {
            this.setRollbackOnly();
            throw exception;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw new PersistenceException(exception);
        }
    }

    @Override
    public X getSingleResult() {
        return (X)super.getSingleResult();
    }

    @Override
    public EJBQueryImpl setFirstResult(int startPosition) {
        return (EJBQueryImpl)super.setFirstResult(startPosition);
    }

    @Override
    public EJBQueryImpl setFlushMode(FlushModeType flushMode) {
        return (EJBQueryImpl)super.setFlushMode(flushMode);
    }

    @Override
    public EJBQueryImpl setMaxResults(int maxResult) {
        return (EJBQueryImpl)super.setMaxResults(maxResult);
    }

    @Override
    public TypedQuery setParameter(int position, Calendar value, TemporalType temporalType) {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        return this.setParameter(position, this.convertTemporalType(value, temporalType));
    }

    @Override
    public TypedQuery setParameter(int position, Date value, TemporalType temporalType) {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        return this.setParameter(position, this.convertTemporalType(value, temporalType));
    }

    @Override
    public TypedQuery setParameter(int position, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(position, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public TypedQuery setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        String position = EJBQueryImpl.getParameterId(param);
        ParameterExpressionImpl parameter = (ParameterExpressionImpl)this.getInternalParameters().get(position);
        if (parameter == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_NAME", new Object[]{param.toString(), this.databaseQuery}));
        }
        if (!parameter.getParameterType().equals(param.getParameterType())) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("INCORRECT_PARAMETER_TYPE", new Object[]{position, param.getParameterType()}));
        }
        return this.setParameter(position, value, temporalType);
    }

    @Override
    public TypedQuery setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        String position = EJBQueryImpl.getParameterId(param);
        ParameterExpressionImpl parameter = (ParameterExpressionImpl)this.getInternalParameters().get(position);
        if (parameter == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_NAME", new Object[]{param.toString(), this.databaseQuery}));
        }
        if (!parameter.getParameterType().equals(param.getParameterType())) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("INCORRECT_PARAMETER_TYPE", new Object[]{position, param.getParameterType()}));
        }
        return this.setParameter(position, value, temporalType);
    }

    @Override
    public <T> TypedQuery setParameter(Parameter<T> param, T value) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        String position = EJBQueryImpl.getParameterId(param);
        ParameterExpressionImpl parameter = (ParameterExpressionImpl)this.getInternalParameters().get(position);
        if (parameter == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_NAME", new Object[]{param.toString(), this.databaseQuery}));
        }
        if (!parameter.getParameterType().equals(param.getParameterType())) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("INCORRECT_PARAMETER_TYPE", new Object[]{position, param.getParameterType()}));
        }
        return this.setParameter(position, value);
    }

    @Override
    public TypedQuery setParameter(String name, Calendar value, TemporalType temporalType) {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        return this.setParameter(name, this.convertTemporalType(value, temporalType));
    }

    @Override
    public TypedQuery setParameter(String name, Date value, TemporalType temporalType) {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        return this.setParameter(name, this.convertTemporalType(value, temporalType));
    }

    @Override
    public TypedQuery setParameter(String name, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(name, value, false);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.databaseQuery + ")";
    }
}

