/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dbws;

import jakarta.activation.DataHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.persistence.internal.oxm.ByteArrayDataSource;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentMarshaller;

public class SOAPAttachmentHandler
implements XMLAttachmentMarshaller {
    private int count = 0;
    private HashMap<String, DataHandler> attachments = new HashMap();

    public boolean hasAttachments() {
        return this.attachments.size() > 0;
    }

    public Map<String, DataHandler> getAttachments() {
        return this.attachments;
    }

    @Override
    public String addSwaRefAttachment(DataHandler data) {
        ++this.count;
        String name = "cid:ref" + this.count;
        this.attachments.put(name, data);
        return name;
    }

    @Override
    public String addSwaRefAttachment(byte[] data, int start, int length) {
        ++this.count;
        String name = "cid:ref" + this.count;
        DataHandler dataHandler = new DataHandler(new ByteArrayDataSource(data, "application/octet-stream"));
        this.attachments.put(name, dataHandler);
        return name;
    }

    @Override
    public String addMtomAttachment(DataHandler data, String elementName, String namespace) {
        String name = "cid:" + UUID.randomUUID().toString();
        this.attachments.put(name, data);
        return name;
    }

    @Override
    public String addMtomAttachment(byte[] data, int start, int len, String mimeType, String elementName, String namespace) {
        String name = "cid:" + UUID.randomUUID().toString();
        DataHandler dataHandler = new DataHandler(new ByteArrayDataSource(data, "application/octet-stream"));
        this.attachments.put(name, dataHandler);
        return name;
    }

    @Override
    public boolean isXOPPackage() {
        return true;
    }
}

