/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.internal.codegen.AttributeDefinition;
import org.eclipse.persistence.internal.codegen.CodeDefinition;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.internal.codegen.MethodDefinition;

public class ClassDefinition
extends CodeDefinition {
    protected String packageName = "";
    protected Vector<String> imports = new Vector(3);
    protected int type = 1;
    public static final int CLASS_TYPE = 1;
    public static final int INTERFACE_TYPE = 2;
    protected String superClass;
    protected Vector<String> interfaces = new Vector(3);
    protected Vector<AttributeDefinition> attributes = new Vector();
    protected Vector<MethodDefinition> methods = new Vector();
    protected Vector<ClassDefinition> innerClasses = new Vector(3);

    public void addAttribute(AttributeDefinition attribute) {
        this.getAttributes().addElement(attribute);
    }

    public void addImport(String importStatement) {
        if (!this.getImports().contains(importStatement)) {
            this.getImports().addElement(importStatement);
        }
    }

    private void addImports(Map<String, Set<String>> typeNameMap) {
        for (Map.Entry<String, Set<String>> entry : typeNameMap.entrySet()) {
            String shortName = entry.getKey();
            Set<String> packageNames = entry.getValue();
            if (packageNames.size() > 1) continue;
            for (String packageName : packageNames) {
                if (packageName.equals("java.lang") || packageName.equals(this.getPackageName()) || packageName.equals("")) continue;
                this.addImport(packageName + "." + shortName);
            }
        }
        this.sortImports();
    }

    public void addInnerClass(ClassDefinition classDefinition) {
        this.getInnerClasses().add(classDefinition);
    }

    public void addInterface(String interfaceClassName) {
        this.getInterfaces().addElement(interfaceClassName);
    }

    public void addMethod(MethodDefinition method) {
        this.getMethods().addElement(method);
    }

    private void addTypeNamesToMap(HashMap<String, Set<String>> typeNameMap) {
        ClassDefinition.putTypeNameInMap(this.getSuperClass(), typeNameMap);
        Iterator<Object> i = this.getInterfaces().iterator();
        while (i.hasNext()) {
            ClassDefinition.putTypeNameInMap(i.next(), typeNameMap);
        }
        i = this.getAttributes().iterator();
        while (i.hasNext()) {
            ((AttributeDefinition)i.next()).putTypeNamesInMap(typeNameMap);
        }
        i = this.getMethods().iterator();
        while (i.hasNext()) {
            ((MethodDefinition)i.next()).putTypeNamesInMap(typeNameMap);
        }
    }

    private void adjustTypeNames(HashMap<String, Set<String>> typeNameMap) {
        this.setSuperClass(ClassDefinition.adjustTypeName(this.getSuperClass(), typeNameMap));
        for (String interfaceName : new Vector<String>(this.getInterfaces())) {
            this.replaceInterface(interfaceName, ClassDefinition.adjustTypeName(interfaceName, typeNameMap));
        }
        Iterator<Object> i = this.getAttributes().iterator();
        while (i.hasNext()) {
            ((AttributeDefinition)i.next()).adjustTypeNames(typeNameMap);
        }
        i = this.getMethods().iterator();
        while (i.hasNext()) {
            ((MethodDefinition)i.next()).adjustTypeNames(typeNameMap);
        }
    }

    public void calculateImports() {
        HashMap<String, Set<String>> typeNameMap = new HashMap<String, Set<String>>();
        this.addTypeNamesToMap(typeNameMap);
        this.adjustTypeNames(typeNameMap);
        this.addImports(typeNameMap);
    }

    public boolean containsMethod(MethodDefinition method) {
        return this.getMethods().contains(method);
    }

    protected Vector<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    protected Vector<String> getImports() {
        return this.imports;
    }

    protected Vector<ClassDefinition> getInnerClasses() {
        return this.innerClasses;
    }

    protected Vector<String> getInterfaces() {
        return this.interfaces;
    }

    protected Vector<MethodDefinition> getMethods() {
        return this.methods;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public int getType() {
        return this.type;
    }

    public boolean isInterface() {
        return this.getType() == 2;
    }

    protected void replaceInterface(String oldInterfaceName, String newInterfaceName) {
        if (!oldInterfaceName.equals(newInterfaceName)) {
            this.interfaces.remove(oldInterfaceName);
            this.interfaces.add(newInterfaceName);
        }
    }

    private void setImports(Vector<String> imports) {
        this.imports = imports;
    }

    private void setMethods(Vector<MethodDefinition> methods) {
        this.methods = methods;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public void setType(int type2) {
        this.type = type2;
    }

    protected void sortImports() {
        this.setImports(new Vector<String>(new TreeSet<String>(this.getImports())));
    }

    protected void sortMethods() {
        MethodDefinition[] methodArray = this.getMethods().toArray(new MethodDefinition[0]);
        Comparator<MethodDefinition> comparison = new Comparator<MethodDefinition>(){

            @Override
            public int compare(MethodDefinition first, MethodDefinition second) {
                if (first.isConstructor()) {
                    return -1;
                }
                if (second.isConstructor()) {
                    return 1;
                }
                return first.getName().compareTo(second.getName());
            }
        };
        Arrays.sort(methodArray, comparison);
        Vector<MethodDefinition> sortedMethods = new Vector<MethodDefinition>(this.getMethods().size());
        for (int index = 0; index < methodArray.length; ++index) {
            sortedMethods.addElement(methodArray[index]);
        }
        this.setMethods(sortedMethods);
    }

    @Override
    public void write(CodeGenerator generator) {
        if (this.getPackageName().length() > 0) {
            generator.write("package ");
            generator.write(this.getPackageName());
            generator.writeln(";");
            generator.cr();
        }
        Enumeration<String> importsEnum = this.getImports().elements();
        while (importsEnum.hasMoreElements()) {
            String importLine = importsEnum.nextElement();
            generator.write("import ");
            generator.write(importLine);
            generator.writeln(";");
        }
        if (!this.getImports().isEmpty()) {
            generator.cr();
        }
        super.write(generator);
    }

    @Override
    public void writeBody(CodeGenerator generator) {
        this.sortMethods();
        if (this.isInterface()) {
            generator.write("interface ");
        } else {
            generator.write("class ");
        }
        generator.write(this.getName());
        if (!this.isInterface() && this.getSuperClass() != null) {
            generator.write(" extends ");
            generator.writeType(this.getSuperClass());
        }
        boolean isFirst = true;
        Enumeration<String> interfacesEnum = this.getInterfaces().elements();
        while (interfacesEnum.hasMoreElements()) {
            String interfaceName = interfacesEnum.nextElement();
            if (isFirst) {
                if (this.isInterface()) {
                    generator.write(" extends");
                } else {
                    generator.write(" implements");
                }
                isFirst = false;
            } else {
                generator.write(",");
            }
            generator.write(" ");
            generator.write(interfaceName);
        }
        generator.writeln(" {");
        generator.cr();
        Enumeration<AttributeDefinition> attributesEnum = this.getAttributes().elements();
        while (attributesEnum.hasMoreElements()) {
            generator.tab();
            attributesEnum.nextElement().write(generator);
            generator.cr();
        }
        if (!this.getAttributes().isEmpty()) {
            generator.cr();
        }
        Enumeration<MethodDefinition> methodsEnum = this.getMethods().elements();
        while (methodsEnum.hasMoreElements()) {
            methodsEnum.nextElement().write(generator);
            generator.cr();
            generator.cr();
        }
        Enumeration<ClassDefinition> innerClassesEnum = this.getInnerClasses().elements();
        while (innerClassesEnum.hasMoreElements()) {
            innerClassesEnum.nextElement().write(generator);
            generator.cr();
            generator.cr();
        }
        generator.writeln("}");
    }
}

