/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePartDataSource;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class SendMailFactory
implements ObjectFactory {
    protected static final String DataSourceClassName = "jakarta.mail.internet.MimePartDataSource";

    @Override
    public Object getObjectInstance(Object RefObj, Name Nm, Context Ctx, Hashtable<?, ?> Env) throws Exception {
        final Reference Ref2 = (Reference)RefObj;
        if (Ref2.getClassName().equals(DataSourceClassName)) {
            return AccessController.doPrivileged(new PrivilegedAction<MimePartDataSource>(){

                @Override
                public MimePartDataSource run() {
                    Properties props = new Properties();
                    Enumeration<RefAddr> list = Ref2.getAll();
                    props.put("mail.transport.protocol", "smtp");
                    while (list.hasMoreElements()) {
                        RefAddr refaddr = list.nextElement();
                        props.put(refaddr.getType(), refaddr.getContent());
                    }
                    try {
                        MimeMessage message = new MimeMessage(Session.getInstance(props));
                        String from = (String)Ref2.get("mail.from").getContent();
                        message.setFrom(new InternetAddress(from));
                        message.setSubject("");
                        MimePartDataSource mds = new MimePartDataSource(message);
                        return mds;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        }
        return null;
    }
}

