/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.grizzly.http.util.DataChunk;

final class StandardWrapperValve
extends ValveBase {
    private static final java.util.logging.Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();

    StandardWrapperValve() {
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        block41: {
            StandardWrapper wrapper;
            Servlet servlet;
            Throwable throwable;
            block40: {
                block39: {
                    boolean unavailable = false;
                    throwable = null;
                    servlet = null;
                    wrapper = (StandardWrapper)this.getContainer();
                    Context context = (Context)wrapper.getParent();
                    HttpRequest hrequest = (HttpRequest)request;
                    RequestFacade requestFacade = (RequestFacade)request.getRequest(true);
                    HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
                    if (!context.getAvailable()) {
                        httpServletResponse.sendError(503);
                        response.setDetailMessage(rb.getString("AS-WEB-CORE-00274"));
                        unavailable = true;
                    }
                    if (!unavailable && wrapper.isUnavailable()) {
                        String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00275"), wrapper.getName());
                        this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00275"), wrapper.getName()));
                        if (httpServletResponse != null) {
                            long available = wrapper.getAvailable();
                            if (available > 0L && available < Long.MAX_VALUE) {
                                httpServletResponse.setDateHeader("Retry-After", available);
                                httpServletResponse.sendError(503);
                                response.setDetailMessage(msg);
                            } else if (available == Long.MAX_VALUE) {
                                httpServletResponse.sendError(404);
                                response.setDetailMessage(MessageFormat.format(rb.getString("AS-WEB-CORE-00276"), wrapper.getName()));
                            }
                        }
                        unavailable = true;
                    }
                    try {
                        if (!unavailable) {
                            servlet = wrapper.allocate();
                        }
                    }
                    catch (UnavailableException e) {
                        if (e.isPermanent()) {
                            httpServletResponse.sendError(404);
                            response.setDetailMessage(MessageFormat.format(rb.getString("AS-WEB-CORE-00276"), wrapper.getName()));
                        } else {
                            httpServletResponse.setDateHeader("Retry-After", e.getUnavailableSeconds());
                            httpServletResponse.sendError(503);
                            response.setDetailMessage(MessageFormat.format(rb.getString("AS-WEB-CORE-00275"), wrapper.getName()));
                        }
                    }
                    catch (ServletException e) {
                        this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00277"), wrapper.getName()));
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    catch (Throwable e) {
                        this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00277"), wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    try {
                        response.sendAcknowledgement();
                    }
                    catch (IOException e) {
                        this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00278"), wrapper.getName()));
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00278"), wrapper.getName()));
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    DataChunk requestPathMB = hrequest.getRequestPathMB();
                    requestFacade.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", requestPathMB);
                    ApplicationFilterChain filterChain = ApplicationFilterFactory.getInstance().createFilterChain((ServletRequest)((Object)request), wrapper, servlet);
                    try {
                        String jspFile = wrapper.getJspFile();
                        if (jspFile != null) {
                            requestFacade.setAttribute("org.apache.catalina.jsp_file", jspFile);
                        }
                        if (servlet != null) {
                            if (filterChain != null) {
                                filterChain.setWrapper(wrapper);
                                filterChain.doFilter(requestFacade, httpServletResponse);
                            } else {
                                wrapper.service(requestFacade, httpServletResponse, servlet);
                            }
                        }
                    }
                    catch (ClientAbortException e) {
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (IOException e) {
                        this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00090"), wrapper.getName()));
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (UnavailableException e) {
                        this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00090"), wrapper.getName()));
                        wrapper.unavailable(e);
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            httpServletResponse.setDateHeader("Retry-After", available);
                            httpServletResponse.sendError(503);
                            String msgServletUnavailable = MessageFormat.format(rb.getString("AS-WEB-CORE-00275"), wrapper.getName());
                            response.setDetailMessage(msgServletUnavailable);
                        } else if (available == Long.MAX_VALUE) {
                            httpServletResponse.sendError(404);
                            String msgServletNotFound = MessageFormat.format(rb.getString("AS-WEB-CORE-00276"), wrapper.getName());
                            response.setDetailMessage(msgServletNotFound);
                        }
                    }
                    catch (ServletException e) {
                        Throwable rootCause = StandardWrapper.getRootCause(e);
                        if (!(rootCause instanceof ClientAbortException)) {
                            this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00090"), wrapper.getName()), rootCause);
                        }
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00090"), wrapper.getName()));
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    try {
                        if (filterChain != null) {
                            filterChain.release();
                        }
                    }
                    catch (Throwable e) {
                        this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00280"), wrapper.getName()), e);
                        if (throwable != null) break block39;
                        throwable = e;
                        this.exception(request, response, e);
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00281"), wrapper.getName()), e);
                    if (throwable != null) break block40;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00272"), wrapper.getName()), e);
                if (throwable != null) break block41;
                this.exception(request, response, e);
            }
        }
        return 2;
    }

    @Override
    public void invoke(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        this.invoke((Request)request, (Response)response);
    }

    private void log(String message) {
        Logger logger2 = null;
        String containerName = null;
        if (this.container != null) {
            logger2 = this.container.getLogger();
            containerName = this.container.getName();
        }
        if (logger2 != null) {
            logger2.log("StandardWrapperValve[" + containerName + "]: " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "AS-WEB-CORE-00283", new Object[]{containerName, message});
        }
    }

    private void log(String message, Throwable t) {
        Logger logger2 = null;
        String containerName = null;
        if (this.container != null) {
            logger2 = this.container.getLogger();
            containerName = this.container.getName();
        }
        if (logger2 != null) {
            logger2.log("StandardWrapperValve[" + containerName + "]: " + message, t, 2);
        } else {
            log.log(Level.WARNING, MessageFormat.format(rb.getString("AS-WEB-CORE-00283"), containerName, message), t);
        }
    }

    private void exception(Request request, Response response, Throwable exception) {
        ServletRequest servletRequest = request.getRequest();
        servletRequest.setAttribute("jakarta.servlet.error.exception", exception);
        ServletResponse servletResponse = response.getResponse();
        ((HttpServletResponse)servletResponse).setStatus(500);
    }

    @Override
    public ObjectName createObjectName(String domain, ObjectName parent) throws MalformedObjectNameException {
        return null;
    }
}

