/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.apache.catalina.LogFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.security.SecurityUtil;

public class ResponseFacade
implements HttpServletResponse {
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    protected Response response;

    public ResponseFacade(Response response) {
        this.response = response;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void clear() {
        this.response = null;
    }

    public void finish() {
        this.checkResponseNull();
        this.response.setSuspended(true);
    }

    public boolean isFinished() {
        this.checkResponseNull();
        return this.response.isSuspended();
    }

    @Override
    public String getCharacterEncoding() {
        this.checkResponseNull();
        return this.response.getCharacterEncoding();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        this.checkResponseNull();
        ServletOutputStream sos = this.response.getOutputStream();
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return sos;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        this.checkResponseNull();
        try {
            PrintWriter writer = this.response.getWriter();
            if (this.isFinished()) {
                this.response.setSuspended(true);
            }
            return writer;
        }
        catch (UnsupportedCharsetException e) {
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException();
            unsupportedEncodingException.initCause(e);
            throw unsupportedEncodingException;
        }
    }

    @Override
    public void setContentLength(int len) {
        this.checkResponseNull();
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(len);
    }

    @Override
    public void setContentLengthLong(long len) {
        this.checkResponseNull();
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLengthLong(len);
    }

    @Override
    public void setContentType(String type2) {
        this.checkResponseNull();
        if (this.isCommitted()) {
            return;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new SetContentTypePrivilegedAction(type2));
        } else {
            this.response.setContentType(type2);
        }
    }

    @Override
    public void setBufferSize(int size) {
        this.checkResponseNull();
        this.checkCommitted();
        this.response.setBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        this.checkResponseNull();
        return this.response.getBufferSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void flushBuffer() throws IOException {
        this.checkResponseNull();
        if (this.isFinished()) {
            return;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        ResponseFacade.this.response.setAppCommitted(true);
                        ResponseFacade.this.response.flushBuffer();
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (!(ex instanceof IOException)) return;
                throw (IOException)ex;
            }
        } else {
            this.response.setAppCommitted(true);
            this.response.flushBuffer();
        }
    }

    @Override
    public void resetBuffer() {
        this.checkResponseNull();
        this.checkCommitted();
        this.response.resetBuffer();
    }

    @Override
    public boolean isCommitted() {
        this.checkResponseNull();
        return this.response.isAppCommitted();
    }

    @Override
    public void reset() {
        this.checkResponseNull();
        this.checkCommitted();
        this.response.reset();
    }

    @Override
    public void setLocale(Locale loc) {
        this.checkResponseNull();
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(loc);
    }

    @Override
    public Locale getLocale() {
        this.checkResponseNull();
        return this.response.getLocale();
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.checkResponseNull();
        if (this.isCommitted()) {
            return;
        }
        this.response.addCookie(cookie);
    }

    @Override
    public boolean containsHeader(String name) {
        this.checkResponseNull();
        return this.response.containsHeader(name);
    }

    @Override
    public String encodeURL(String url) {
        this.checkResponseNull();
        return this.response.encodeURL(url);
    }

    @Override
    public String encodeRedirectURL(String url) {
        this.checkResponseNull();
        return this.response.encodeRedirectURL(url);
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        this.checkResponseNull();
        this.checkCommitted();
        this.response.setAppCommitted(true);
        this.response.sendError(sc, msg);
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.checkResponseNull();
        this.checkCommitted();
        this.response.setAppCommitted(true);
        this.response.sendError(sc);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.checkResponseNull();
        this.checkCommitted();
        this.response.setAppCommitted(true);
        this.response.sendRedirect(location);
    }

    @Override
    public void setDateHeader(String name, long date) {
        this.checkResponseNull();
        if (this.isCommitted()) {
            return;
        }
        this.response.setDateHeader(name, date);
    }

    @Override
    public void addDateHeader(String name, long date) {
        this.checkResponseNull();
        if (this.isCommitted()) {
            return;
        }
        this.response.addDateHeader(name, date);
    }

    @Override
    public void setHeader(String name, String value) {
        this.checkResponseNull();
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.checkResponseNull();
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        this.checkResponseNull();
        if (this.isCommitted()) {
            return;
        }
        this.response.setIntHeader(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        this.checkResponseNull();
        if (this.isCommitted()) {
            return;
        }
        this.response.addIntHeader(name, value);
    }

    @Override
    public void setStatus(int sc) {
        this.checkResponseNull();
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(sc);
    }

    @Override
    public String getContentType() {
        this.checkResponseNull();
        return this.response.getContentType();
    }

    @Override
    public void setCharacterEncoding(String arg0) {
        this.checkResponseNull();
        this.response.setCharacterEncoding(arg0);
    }

    @Override
    public int getStatus() {
        this.checkResponseNull();
        return this.response.getStatus();
    }

    @Override
    public String getHeader(String name) {
        this.checkResponseNull();
        return this.response.getHeader(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        this.checkResponseNull();
        return this.response.getHeaders(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        this.checkResponseNull();
        return this.response.getHeaderNames();
    }

    @Override
    public Supplier<Map<String, String>> getTrailerFields() {
        this.checkResponseNull();
        return this.response.getTrailerFields();
    }

    @Override
    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        this.checkResponseNull();
        this.response.setTrailerFields(supplier);
    }

    private void checkResponseNull() {
        if (this.response == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00082"));
        }
    }

    private void checkCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
    }

    private final class SetContentTypePrivilegedAction
    implements PrivilegedAction<Void> {
        private String contentType;

        public SetContentTypePrivilegedAction(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public Void run() {
            ResponseFacade.this.response.setContentType(this.contentType);
            return null;
        }
    }
}

