/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.StateHolderSaver;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class AttachedObjectListHolder<T>
implements PartialStateHolder {
    private boolean initialState;
    private List<T> attachedObjects = new ArrayList<T>(2);

    AttachedObjectListHolder() {
    }

    @Override
    public void markInitialState() {
        if (!this.attachedObjects.isEmpty()) {
            for (T t : this.attachedObjects) {
                if (!(t instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)t).markInitialState();
            }
        }
        this.initialState = true;
    }

    @Override
    public boolean initialStateMarked() {
        return this.initialState;
    }

    @Override
    public void clearInitialState() {
        if (!this.attachedObjects.isEmpty()) {
            for (T t : this.attachedObjects) {
                if (!(t instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)t).clearInitialState();
            }
        }
        this.initialState = false;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.attachedObjects == null) {
            return null;
        }
        if (this.initialState) {
            Object[] attachedObjects = new Object[this.attachedObjects.size()];
            boolean stateWritten = false;
            int len = attachedObjects.length;
            for (int i = 0; i < len; ++i) {
                T attachedObject = this.attachedObjects.get(i);
                if (!(attachedObject instanceof StateHolder)) continue;
                StateHolder stateHolder = (StateHolder)attachedObject;
                if (!stateHolder.isTransient()) {
                    attachedObjects[i] = stateHolder.saveState(context);
                }
                if (attachedObjects[i] == null) continue;
                stateWritten = true;
            }
            return stateWritten ? attachedObjects : null;
        }
        Object[] attachedObjects = new Object[this.attachedObjects.size()];
        int len = attachedObjects.length;
        for (int i = 0; i < len; ++i) {
            attachedObjects[i] = UIComponentBase.saveAttachedState(context, this.attachedObjects.get(i));
        }
        return attachedObjects;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        block7: {
            Object[] attachedObjects;
            block6: {
                if (context == null) {
                    throw new NullPointerException();
                }
                if (state == null) {
                    return;
                }
                attachedObjects = (Object[])state;
                if (attachedObjects.length <= 0 || !(attachedObjects[0] instanceof StateHolderSaver)) break block6;
                if (this.attachedObjects != null) {
                    this.attachedObjects.clear();
                } else {
                    this.attachedObjects = new ArrayList<T>(2);
                }
                int len = attachedObjects.length;
                for (int i = 0; i < len; ++i) {
                    Object restored = ((StateHolderSaver)attachedObjects[i]).restore(context);
                    if (restored == null) continue;
                    this.add(restored);
                }
                break block7;
            }
            if (this.attachedObjects == null || this.attachedObjects.size() != attachedObjects.length) break block7;
            int len = attachedObjects.length;
            for (int i = 0; i < len; ++i) {
                T attachedObject = this.attachedObjects.get(i);
                if (!(attachedObject instanceof StateHolder)) continue;
                ((StateHolder)attachedObject).restoreState(context, attachedObjects[i]);
            }
        }
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
    }

    void add(T attachedObject) {
        this.clearInitialState();
        this.attachedObjects.add(attachedObject);
    }

    void remove(T attachedObject) {
        this.clearInitialState();
        this.attachedObjects.remove(attachedObject);
    }

    T[] asArray(Class<T> type2) {
        return new ArrayList<Object>(this.attachedObjects).toArray((Object[])Array.newInstance(type2, this.attachedObjects.size()));
    }

    Iterator<T> iterator() {
        return this.attachedObjects.iterator();
    }
}

