/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.security.integration.AppServSecurityContext;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.enterprise.web.WebModule;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.servlets.DefaultServlet;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.wasp.servlet.JspServlet;
import org.glassfish.web.LogFacade;

public final class EEInstanceListener
implements InstanceListener {
    private static final Logger _logger = LogFacade.getLogger();
    private static final ResourceBundle _rb = _logger.getResourceBundle();
    private static AuthPermission doAsPrivilegedPerm = new AuthPermission("doAsPrivileged");
    private InvocationManager invocationManager;
    private JavaEETransactionManager eeTransactionManager;
    private InjectionManager injectionManager;
    private AppServSecurityContext securityContext;
    private boolean initialized;

    @Override
    public void instanceEvent(InstanceEvent event) {
        Context context = (Context)event.getWrapper().getParent();
        if (!(context instanceof WebModule)) {
            return;
        }
        WebModule webModule = (WebModule)context;
        this.init(webModule);
        InstanceEvent.EventType eventType = event.getType();
        _logger.log(Level.FINEST, "AS-WEB-GLUE-00265", (Object)eventType);
        if (eventType.isBefore) {
            this.handleBeforeEvent(event, eventType);
        } else {
            this.handleAfterEvent(event, eventType);
        }
    }

    private synchronized void init(WebModule webModule) {
        if (this.initialized) {
            return;
        }
        ServerContext serverContext = webModule.getServerContext();
        if (serverContext == null) {
            throw new IllegalStateException(MessageFormat.format(_rb.getString("AS-WEB-GLUE-00269"), webModule.getName()));
        }
        ServiceLocator services = serverContext.getDefaultServices();
        this.invocationManager = services.getService(InvocationManager.class, new Annotation[0]);
        this.eeTransactionManager = this.getJavaEETransactionManager(services);
        this.injectionManager = services.getService(InjectionManager.class, new Annotation[0]);
        this.securityContext = services.getService(AppServSecurityContext.class, new Annotation[0]);
        if (this.securityContext != null) {
            _logger.log(Level.FINE, "AS-WEB-GLUE-00266", this.securityContext);
        } else {
            _logger.log(Level.FINE, "AS-WEB-GLUE-00267");
        }
        this.initialized = true;
    }

    private void handleBeforeEvent(InstanceEvent event, InstanceEvent.EventType eventType) {
        ServletRequest request;
        Context context = (Context)event.getWrapper().getParent();
        if (!(context instanceof WebModule)) {
            return;
        }
        WebModule webModule = (WebModule)context;
        Object instance = eventType == InstanceEvent.EventType.BEFORE_FILTER_EVENT ? event.getFilter() : event.getServlet();
        Realm realm = context.getRealm();
        if (realm != null && (request = event.getRequest()) instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            Principal principal = httpServletRequest.getUserPrincipal();
            Principal basePrincipal = this.getBasePrincipal(httpServletRequest, principal);
            if (principal != null && principal == basePrincipal && principal.getClass().getName().equals("com.sun.enterprise.security.ee.web.integration.WebPrincipal")) {
                this.securityContext.setSecurityContextWithPrincipal(principal);
            } else if (principal != basePrincipal && principal != this.getCurrentCallerPrincipal()) {
                EEInstanceListener.checkObjectForDoAsPermission(httpServletRequest);
                this.securityContext.setSecurityContextWithPrincipal(principal);
            }
        }
        WebComponentInvocation componentInvocation = eventType == InstanceEvent.EventType.BEFORE_INIT_EVENT ? new WebComponentInvocation(webModule, instance, event.getWrapper().getName()) : new WebComponentInvocation(webModule, instance);
        try {
            this.invocationManager.preInvoke(componentInvocation);
            if (eventType == InstanceEvent.EventType.BEFORE_SERVICE_EVENT) {
                webModule.beforeServiceEvent(event.getWrapper().getName());
                if (this.eeTransactionManager != null) {
                    this.eeTransactionManager.enlistComponentResources();
                }
            }
        }
        catch (Exception ex) {
            this.invocationManager.postInvoke(componentInvocation);
            throw new RuntimeException(MessageFormat.format(_rb.getString("AS-WEB-GLUE-00268"), new Object[]{eventType, webModule}), ex);
        }
    }

    private Principal getBasePrincipal(HttpServletRequest baseHttpServletRequest, Principal principal) {
        Principal basePrincipal = principal;
        boolean wrapped = false;
        while (principal != null) {
            ServletRequest servletRequest;
            if (baseHttpServletRequest instanceof ServletRequestWrapper && (servletRequest = ((ServletRequestWrapper)((Object)baseHttpServletRequest)).getRequest()) instanceof HttpServletRequest) {
                baseHttpServletRequest = (HttpServletRequest)servletRequest;
                wrapped = true;
                continue;
            }
            if (wrapped) {
                basePrincipal = baseHttpServletRequest.getUserPrincipal();
                break;
            }
            if (baseHttpServletRequest instanceof RequestFacade) {
                if (baseHttpServletRequest.getClass() == RequestFacade.class) break;
                basePrincipal = ((RequestFacade)baseHttpServletRequest).getUnwrappedCoyoteRequest().getUserPrincipal();
                break;
            }
            basePrincipal = baseHttpServletRequest.getUserPrincipal();
            break;
        }
        return basePrincipal;
    }

    private Principal getCurrentCallerPrincipal() {
        AppServSecurityContext currentSecurityContext = this.securityContext.getCurrentSecurityContext();
        if (currentSecurityContext == null) {
            return null;
        }
        return currentSecurityContext.getCallerPrincipal();
    }

    private static void checkObjectForDoAsPermission(final Object o) throws AccessControlException {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (!Policy.getPolicy().implies(o.getClass().getProtectionDomain(), doAsPrivilegedPerm)) {
                        throw new AccessControlException("permission required to override getUserPrincipal", doAsPrivilegedPerm);
                    }
                    return null;
                }
            });
        }
    }

    private void handleAfterEvent(InstanceEvent event, InstanceEvent.EventType eventType) {
        WebComponentInvocation componentInvocation;
        Object instance;
        WebModule webModule;
        Context context;
        Wrapper wrapper;
        block41: {
            wrapper = event.getWrapper();
            context = (Context)wrapper.getParent();
            if (!(context instanceof WebModule)) {
                return;
            }
            webModule = (WebModule)context;
            instance = eventType == InstanceEvent.EventType.AFTER_FILTER_EVENT ? event.getFilter() : event.getServlet();
            if (instance == null) {
                return;
            }
            if (instance instanceof Servlet) {
                if (eventType == InstanceEvent.EventType.AFTER_INIT_EVENT) {
                    webModule.servletInitializedEvent(wrapper.getName());
                } else if (eventType == InstanceEvent.EventType.AFTER_DESTROY_EVENT) {
                    webModule.servletDestroyedEvent(wrapper.getName());
                }
            }
            try {
                if (eventType == InstanceEvent.EventType.AFTER_DESTROY_EVENT && !DefaultServlet.class.equals(instance.getClass()) && !JspServlet.class.equals(instance.getClass())) {
                    this.injectionManager.destroyManagedObject(instance, false);
                }
            }
            catch (InjectionException ie) {
                _logger.log(Level.SEVERE, MessageFormat.format(_rb.getString("AS-WEB-GLUE-00268"), new Object[]{eventType, webModule}), ie);
            }
            componentInvocation = new WebComponentInvocation(webModule, instance);
            try {
                this.invocationManager.postInvoke(componentInvocation);
                if (eventType != InstanceEvent.EventType.AFTER_DESTROY_EVENT) break block41;
                if (this.eeTransactionManager != null) {
                    this.eeTransactionManager.componentDestroyed(instance, componentInvocation);
                }
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException(MessageFormat.format(_rb.getString("AS-WEB-GLUE-00268"), new Object[]{eventType, webModule}), ex);
                }
                catch (Throwable throwable) {
                    if (eventType == InstanceEvent.EventType.AFTER_DESTROY_EVENT) {
                        if (this.eeTransactionManager != null) {
                            this.eeTransactionManager.componentDestroyed(instance, componentInvocation);
                        }
                    } else if (Utility.isOneOf(eventType, InstanceEvent.EventType.AFTER_FILTER_EVENT, InstanceEvent.EventType.AFTER_SERVICE_EVENT)) {
                        if (eventType == InstanceEvent.EventType.AFTER_SERVICE_EVENT) {
                            ServletResponse response = event.getResponse();
                            int status = -1;
                            if (response instanceof HttpServletResponse) {
                                status = ((HttpServletResponse)response).getStatus();
                            }
                            webModule.afterServiceEvent(wrapper.getName(), status);
                        }
                        if (this.invocationManager.getCurrentInvocation() == null) {
                            try {
                                Realm realm = context.getRealm();
                                if (realm instanceof RealmInitializer) {
                                    ((RealmInitializer)((Object)realm)).logout();
                                }
                            }
                            catch (Exception ex2) {
                                _logger.log(Level.SEVERE, MessageFormat.format(_rb.getString("AS-WEB-GLUE-00268"), new Object[]{eventType, webModule}), ex2);
                            }
                            if (this.eeTransactionManager != null) {
                                try {
                                    if (this.eeTransactionManager.getTransaction() != null) {
                                        this.eeTransactionManager.rollback();
                                    }
                                    this.eeTransactionManager.cleanTxnTimeout();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if (this.eeTransactionManager != null) {
                            this.eeTransactionManager.componentDestroyed(instance, componentInvocation);
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (Utility.isOneOf(eventType, InstanceEvent.EventType.AFTER_FILTER_EVENT, InstanceEvent.EventType.AFTER_SERVICE_EVENT)) {
            if (eventType == InstanceEvent.EventType.AFTER_SERVICE_EVENT) {
                ServletResponse response = event.getResponse();
                int status = -1;
                if (response instanceof HttpServletResponse) {
                    status = ((HttpServletResponse)response).getStatus();
                }
                webModule.afterServiceEvent(wrapper.getName(), status);
            }
            if (this.invocationManager.getCurrentInvocation() == null) {
                try {
                    Realm realm = context.getRealm();
                    if (realm instanceof RealmInitializer) {
                        ((RealmInitializer)((Object)realm)).logout();
                    }
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, MessageFormat.format(_rb.getString("AS-WEB-GLUE-00268"), new Object[]{eventType, webModule}), ex);
                }
                if (this.eeTransactionManager != null) {
                    try {
                        if (this.eeTransactionManager.getTransaction() != null) {
                            this.eeTransactionManager.rollback();
                        }
                        this.eeTransactionManager.cleanTxnTimeout();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if (this.eeTransactionManager != null) {
                this.eeTransactionManager.componentDestroyed(instance, componentInvocation);
            }
        }
    }

    private JavaEETransactionManager getJavaEETransactionManager(ServiceLocator services) {
        ServiceHandle<JavaEETransactionManager> serviceHandle = services.getServiceHandle(JavaEETransactionManager.class, new Annotation[0]);
        if (serviceHandle != null && serviceHandle.isActive()) {
            return serviceHandle.getService();
        }
        return null;
    }
}

