/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypedCollections {
    private static boolean checkCollectionMembers(Collection<?> c, Class<?> type2) {
        for (Object element : c) {
            if (element == null || type2.isInstance(element)) continue;
            return false;
        }
        return true;
    }

    public static <E, TypedC extends Collection<E>> TypedC dynamicallyCastCollection(Collection<?> c, Class<E> type2, Class<TypedC> collectionType) {
        if (c == null) {
            return null;
        }
        if (!collectionType.isInstance(c)) {
            throw new ClassCastException(c.getClass().getName());
        }
        assert (TypedCollections.checkCollectionMembers(c, type2)) : "The collection contains members with a type other than " + type2.getName();
        return (TypedC)((Collection)collectionType.cast(c));
    }

    public static <E> List<E> dynamicallyCastList(List<?> list, Class<E> type2) {
        return TypedCollections.dynamicallyCastCollection(list, type2, List.class);
    }

    public static <E> Set<E> dynamicallyCastSet(Set<?> set, Class<E> type2) {
        return TypedCollections.dynamicallyCastCollection(set, type2, Set.class);
    }

    public static <K, V> Map<K, V> dynamicallyCastMap(Map<?, ?> map, Class<K> keyType, Class<V> valueType) {
        if (map == null) {
            return null;
        }
        assert (TypedCollections.checkCollectionMembers(map.keySet(), keyType)) : "The map contains keys with a type other than " + keyType.getName();
        assert (TypedCollections.checkCollectionMembers(map.values(), valueType)) : "The map contains values with a type other than " + valueType.getName();
        return map;
    }
}

