/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import jakarta.json.stream.JsonGenerator;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;

public class Json {
    private static final String ERROR_INVALID_BEAN = "Cannot introspect object of type '%s' as bean.";
    private static final String ERROR_INVALID_GETTER = "Cannot invoke getter of property '%s' of bean '%s'.";

    public static String encode(Object object, Option ... options) {
        StringWriter writer = new StringWriter();
        Json.encode(object, writer, options);
        return writer.toString();
    }

    public static void encode(Object object, Writer writer, Option ... options) {
        try (JsonGenerator generator = jakarta.json.Json.createGenerator(writer);){
            generator.writeStartObject();
            Json.encode("data", object, generator, options.length == 0 ? EnumSet.noneOf(Option.class) : EnumSet.copyOf(Arrays.asList(options)));
            generator.writeEnd();
        }
    }

    private static void encode(String name, Object object, JsonGenerator generator, EnumSet<Option> options) {
        if (object == null) {
            Json.encodeNull(name, generator);
        } else if (object instanceof Boolean) {
            Json.encodeBoolean(name, (Boolean)object, generator);
        } else if (object instanceof BigDecimal) {
            Json.encodeBigDecimal(name, (BigDecimal)object, generator);
        } else if (object instanceof Double) {
            Json.encodeDouble(name, (Double)object, generator);
        } else if (object instanceof BigInteger) {
            Json.encodeBigInteger(name, (BigInteger)object, generator);
        } else if (object instanceof Integer) {
            Json.encodeInteger(name, (Integer)object, generator);
        } else if (object instanceof Number) {
            Json.encodeLong(name, ((Number)object).longValue(), generator);
        } else if (object instanceof Character) {
            Json.encodeString(name, ((Character)object).toString(), generator);
        } else if (object instanceof CharSequence) {
            Json.encodeString(name, ((CharSequence)object).toString(), generator);
        } else if (object instanceof Date) {
            Json.encodeInstant(name, ((Date)object).toInstant().atZone(ZoneOffset.UTC).toInstant(), generator, options);
        } else if (object instanceof LocalDate) {
            Json.encodeInstant(name, ((LocalDate)object).atStartOfDay(ZoneOffset.UTC).toInstant(), generator, options);
        } else if (object instanceof Instant) {
            Json.encodeInstant(name, (Instant)object, generator, options);
        } else if (object.getClass().isArray()) {
            Json.encodeArray(name, object, generator, options);
        } else if (object instanceof Collection) {
            Json.encodeCollection(name, (Collection)object, generator, options);
        } else if (object instanceof Map) {
            Json.encodeMap(name, (Map)object, generator, options);
        } else {
            Json.encodeBean(name, object, generator, options);
        }
    }

    private static void encodeNull(String name, JsonGenerator generator) {
        if (name == null) {
            generator.writeNull();
        } else {
            generator.writeNull(name);
        }
    }

    private static void encodeBoolean(String name, Boolean value, JsonGenerator generator) {
        if (name == null) {
            generator.write(value);
        } else {
            generator.write(name, value);
        }
    }

    private static void encodeBigDecimal(String name, BigDecimal value, JsonGenerator generator) {
        if (name == null) {
            generator.write(value);
        } else {
            generator.write(name, value);
        }
    }

    private static void encodeDouble(String name, double value, JsonGenerator generator) {
        if (name == null) {
            generator.write(value);
        } else {
            generator.write(name, value);
        }
    }

    private static void encodeBigInteger(String name, BigInteger value, JsonGenerator generator) {
        if (name == null) {
            generator.write(value);
        } else {
            generator.write(name, value);
        }
    }

    private static void encodeInteger(String name, int value, JsonGenerator generator) {
        if (name == null) {
            generator.write(value);
        } else {
            generator.write(name, value);
        }
    }

    private static void encodeLong(String name, long value, JsonGenerator generator) {
        if (name == null) {
            generator.write(value);
        } else {
            generator.write(name, value);
        }
    }

    private static void encodeString(String name, String value, JsonGenerator generator) {
        if (name == null) {
            generator.write(value);
        } else {
            generator.write(name, value);
        }
    }

    private static void encodeInstant(String name, Instant value, JsonGenerator generator, EnumSet<Option> options) {
        Json.encodeString(name, (options.contains((Object)Option.USE_RFC1123_DATE) ? DateTimeFormatter.RFC_1123_DATE_TIME : DateTimeFormatter.ISO_INSTANT).format(value), generator);
    }

    private static void encodeArray(String name, Object array, JsonGenerator generator, EnumSet<Option> options) {
        if (name == null) {
            generator.writeStartArray();
        } else {
            generator.writeStartArray(name);
        }
        boolean skipNullValues = options.contains((Object)Option.SKIP_NULL_VALUES);
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object value = Array.get(array, i);
            if (value == null && skipNullValues) continue;
            Json.encode(null, value, generator, options);
        }
        generator.writeEnd();
    }

    private static void encodeCollection(String name, Collection<?> collection, JsonGenerator generator, EnumSet<Option> options) {
        if (name == null) {
            generator.writeStartArray();
        } else {
            generator.writeStartArray(name);
        }
        boolean skipNullValues = options.contains((Object)Option.SKIP_NULL_VALUES);
        for (Object value : collection) {
            if (value == null && skipNullValues) continue;
            Json.encode(null, value, generator, options);
        }
        generator.writeEnd();
    }

    private static void encodeMap(String name, Map<?, ?> map, JsonGenerator generator, EnumSet<Option> options) {
        if (name == null) {
            generator.writeStartObject();
        } else {
            generator.writeStartObject(name);
        }
        boolean skipNullValues = options.contains((Object)Option.SKIP_NULL_VALUES);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null && skipNullValues) continue;
            Json.encode(String.valueOf(entry.getKey()), value, generator, options);
        }
        generator.writeEnd();
    }

    private static void encodeBean(String name, Object bean, JsonGenerator generator, EnumSet<Option> options) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_BEAN, bean.getClass()), e);
        }
        if (name == null) {
            generator.writeStartObject();
        } else {
            generator.writeStartObject(name);
        }
        boolean skipNullValues = options.contains((Object)Option.SKIP_NULL_VALUES);
        for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
            Object value;
            if (property.getReadMethod() == null || "class".equals(property.getName())) continue;
            try {
                value = property.getReadMethod().invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_GETTER, property.getName(), bean.getClass()), e);
            }
            if (value == null && skipNullValues) continue;
            Json.encode(property.getName(), value, generator, options);
        }
        generator.writeEnd();
    }

    public static enum Option {
        SKIP_NULL_VALUES,
        USE_RFC1123_DATE;

    }
}

