/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.flow.FlowCDIEventFireHelperImpl;
import com.sun.faces.flow.FlowHandlerImpl;
import com.sun.faces.util.Util;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.FlowHandler;
import jakarta.faces.flow.FlowScoped;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FlowCDIContext
implements Context,
Serializable {
    private static final long serialVersionUID = -7144653402477623609L;
    private static final String FLOW_SCOPE_MAP_KEY = "com.sun.faces.FLOW_SCOPE_MAP";
    private transient Map<Contextual<?>, FlowBeanInfo> flowIds;
    private static final String PER_SESSION_BEAN_MAP_LIST = FlowCDIContext.class.getPackage().getName() + ".PER_SESSION_BEAN_MAP_LIST";
    private static final String PER_SESSION_CREATIONAL_LIST = FlowCDIContext.class.getPackage().getName() + ".PER_SESSION_CREATIONAL_LIST";

    FlowCDIContext(Map<Contextual<?>, FlowBeanInfo> flowIds) {
        this.flowIds = new ConcurrentHashMap(flowIds);
    }

    private static void ensureBeanMapCleanupOnSessionDestroyed(Map<String, Object> sessionMap, String flowBeansForClientWindow) {
        ArrayList<String> beanMapList = (ArrayList<String>)sessionMap.get(PER_SESSION_BEAN_MAP_LIST);
        if (beanMapList == null) {
            beanMapList = new ArrayList<String>();
            sessionMap.put(PER_SESSION_BEAN_MAP_LIST, beanMapList);
        }
        beanMapList.add(flowBeansForClientWindow);
    }

    private static void ensureCreationalCleanupOnSessionDestroyed(Map<String, Object> sessionMap, String creationalForClientWindow) {
        ArrayList<String> beanMapList = (ArrayList<String>)sessionMap.get(PER_SESSION_CREATIONAL_LIST);
        if (beanMapList == null) {
            beanMapList = new ArrayList<String>();
            sessionMap.put(PER_SESSION_CREATIONAL_LIST, beanMapList);
        }
        beanMapList.add(creationalForClientWindow);
    }

    private final void assertNotReleased() {
        if (!this.isActive()) {
            throw new IllegalStateException();
        }
    }

    private Flow getCurrentFlow() {
        return FlowCDIContext.getCurrentFlow(FacesContext.getCurrentInstance());
    }

    private static Flow getCurrentFlow(FacesContext context) {
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (flowHandler == null) {
            return null;
        }
        return flowHandler.getCurrentFlow(context);
    }

    public static void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        List creationalList;
        HttpSession session = httpSessionEvent.getSession();
        List beanMapList = (List)session.getAttribute(PER_SESSION_BEAN_MAP_LIST);
        if (beanMapList != null) {
            for (String beanMapName : beanMapList) {
                Map beanMap = (Map)session.getAttribute(beanMapName);
                beanMap.clear();
                session.removeAttribute(beanMapName);
            }
            session.removeAttribute(PER_SESSION_BEAN_MAP_LIST);
            beanMapList.clear();
        }
        if ((creationalList = (List)session.getAttribute(PER_SESSION_CREATIONAL_LIST)) != null) {
            for (String creationalName : creationalList) {
                Map creationalMap = (Map)session.getAttribute(creationalName);
                creationalMap.clear();
                session.removeAttribute(creationalName);
            }
            session.removeAttribute(PER_SESSION_CREATIONAL_LIST);
            creationalList.clear();
        }
    }

    static Map<Object, Object> getCurrentFlowScopeAndUpdateSession() {
        return FlowCDIContext.getCurrentFlowScopeAndUpdateSession(new FlowScopeMapHelper(FacesContext.getCurrentInstance()));
    }

    private static Map<Object, Object> getCurrentFlowScopeAndUpdateSession(FlowScopeMapHelper mapHelper) {
        Map<String, Object> flowScopedBeanMap = mapHelper.getFlowScopedBeanMapForCurrentFlow();
        ConcurrentHashMap result = null;
        if (mapHelper.isFlowExists() && (result = (ConcurrentHashMap)flowScopedBeanMap.get(FLOW_SCOPE_MAP_KEY)) == null) {
            result = new ConcurrentHashMap();
            flowScopedBeanMap.put(FLOW_SCOPE_MAP_KEY, result);
        }
        mapHelper.updateSession();
        return result;
    }

    static void flowExited(Flow currentFlow, int depth) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FlowScopeMapHelper mapHelper = new FlowScopeMapHelper(facesContext, currentFlow, depth);
        Map<String, Object> flowScopedBeanMap = mapHelper.getFlowScopedBeanMapForCurrentFlow();
        Map<String, CreationalContext<?>> creationalMap = mapHelper.getFlowScopedCreationalMapForCurrentFlow();
        BeanManager beanManager = Util.getCdiBeanManager(facesContext);
        for (Map.Entry<String, Object> entry : flowScopedBeanMap.entrySet()) {
            String passivationCapableId = entry.getKey();
            if (FLOW_SCOPE_MAP_KEY.equals(passivationCapableId)) continue;
            Bean<?> owner = beanManager.getPassivationCapableBean(passivationCapableId);
            Object bean = entry.getValue();
            CreationalContext<?> creational = creationalMap.get(passivationCapableId);
            owner.destroy(bean, creational);
        }
        flowScopedBeanMap.clear();
        creationalMap.clear();
        mapHelper.updateSession();
        CdiUtils.getBeanReference(beanManager, FlowCDIEventFireHelperImpl.class, new Annotation[0]).fireDestroyedEvent(currentFlow);
    }

    static void flowEntered() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FlowScopeMapHelper mapHelper = new FlowScopeMapHelper(facesContext);
        mapHelper.createMaps();
        FlowCDIContext.getCurrentFlowScopeAndUpdateSession(mapHelper);
        CdiUtils.getBeanReference(facesContext, FlowCDIEventFireHelperImpl.class, new Annotation[0]).fireInitializedEvent(FlowCDIContext.getCurrentFlow(facesContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creational) {
        this.assertNotReleased();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FlowScopeMapHelper mapHelper = new FlowScopeMapHelper(facesContext);
        Object contextualInstance = this.get(mapHelper, contextual);
        if (contextualInstance == null) {
            Map<String, Object> flowScopedBeanMap = mapHelper.getFlowScopedBeanMapForCurrentFlow();
            Map<String, CreationalContext<?>> creationalMap = mapHelper.getFlowScopedCreationalMapForCurrentFlow();
            String passivationCapableId = ((PassivationCapable)((Object)contextual)).getId();
            Map<String, Object> map = flowScopedBeanMap;
            synchronized (map) {
                contextualInstance = flowScopedBeanMap.get(passivationCapableId);
                if (contextualInstance == null) {
                    FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
                    if (flowHandler == null) {
                        return null;
                    }
                    FlowBeanInfo flowBeanInfo = this.flowIds.get(contextual);
                    if (flowBeanInfo != null && !flowHandler.isActive(facesContext, flowBeanInfo.definingDocumentId, flowBeanInfo.id)) {
                        throw new ContextNotActiveException("Request to activate bean in flow '" + flowBeanInfo + "', but that flow is not active.");
                    }
                    contextualInstance = contextual.create(creational);
                    if (contextualInstance != null) {
                        flowScopedBeanMap.put(passivationCapableId, contextualInstance);
                        creationalMap.put(passivationCapableId, creational);
                        mapHelper.updateSession();
                    }
                }
            }
        }
        return contextualInstance;
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        this.assertNotReleased();
        if (!(contextual instanceof PassivationCapable)) {
            throw new IllegalArgumentException("FlowScoped bean " + contextual.toString() + " must be PassivationCapable, but is not.");
        }
        return this.get(new FlowScopeMapHelper(FacesContext.getCurrentInstance()), contextual);
    }

    private <T> T get(FlowScopeMapHelper mapHelper, Contextual<T> contextual) {
        this.assertNotReleased();
        if (!(contextual instanceof PassivationCapable)) {
            throw new IllegalArgumentException("FlowScoped bean " + contextual.toString() + " must be PassivationCapable, but is not.");
        }
        String passivationCapableId = ((PassivationCapable)((Object)contextual)).getId();
        return (T)mapHelper.getFlowScopedBeanMapForCurrentFlow().get(passivationCapableId);
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return FlowScoped.class;
    }

    @Override
    public boolean isActive() {
        return this.getCurrentFlow() != null;
    }

    void beforeShutdown(@Observes BeforeShutdown event, BeanManager beanManager) {
    }

    private static class FlowScopeMapHelper {
        private transient String flowBeansForClientWindowKey;
        private transient String creationalForClientWindowKey;
        private final transient Map<String, Object> sessionMap;

        private FlowScopeMapHelper(FacesContext facesContext) {
            ExternalContext extContext = facesContext.getExternalContext();
            this.sessionMap = extContext.getSessionMap();
            Flow currentFlow = FlowCDIContext.getCurrentFlow(facesContext);
            int currentFlowDepth = FlowHandlerImpl.getFlowStack(facesContext).getCurrentFlowDepth();
            this.generateKeyForCDIBeansBelongToAFlow(facesContext, currentFlow, currentFlowDepth);
        }

        private FlowScopeMapHelper(FacesContext facesContext, Flow flow, int flowDepth) {
            ExternalContext extContext = facesContext.getExternalContext();
            this.sessionMap = extContext.getSessionMap();
            this.generateKeyForCDIBeansBelongToAFlow(facesContext, flow, flowDepth);
        }

        private void generateKeyForCDIBeansBelongToAFlow(FacesContext facesContext, Flow flow, int flowDepth) {
            if (null != flow) {
                ClientWindow curWindow = facesContext.getExternalContext().getClientWindow();
                if (null == curWindow) {
                    throw new IllegalStateException("Unable to obtain current ClientWindow.  Is the ClientWindow feature enabled?");
                }
                String clientWindow = flow.getClientWindowFlowId(curWindow);
                this.flowBeansForClientWindowKey = clientWindow + ":" + flowDepth + "_beans";
                this.creationalForClientWindowKey = clientWindow + ":" + flowDepth + "_creational";
            } else {
                this.creationalForClientWindowKey = null;
                this.flowBeansForClientWindowKey = null;
            }
        }

        private void createMaps() {
            this.getFlowScopedBeanMapForCurrentFlow();
            this.getFlowScopedCreationalMapForCurrentFlow();
        }

        private boolean isFlowExists() {
            return null != this.flowBeansForClientWindowKey && null != this.creationalForClientWindowKey;
        }

        public String getCreationalForClientWindowKey() {
            return this.creationalForClientWindowKey;
        }

        public String getFlowBeansForClientWindowKey() {
            return this.flowBeansForClientWindowKey;
        }

        private Map<String, Object> getFlowScopedBeanMapForCurrentFlow() {
            if (null == this.flowBeansForClientWindowKey && null == this.creationalForClientWindowKey) {
                return Collections.emptyMap();
            }
            ConcurrentHashMap result = (ConcurrentHashMap)this.sessionMap.get(this.flowBeansForClientWindowKey);
            if (null == result) {
                result = new ConcurrentHashMap();
                this.sessionMap.put(this.flowBeansForClientWindowKey, result);
                FlowCDIContext.ensureBeanMapCleanupOnSessionDestroyed(this.sessionMap, this.flowBeansForClientWindowKey);
            }
            return result;
        }

        private Map<String, CreationalContext<?>> getFlowScopedCreationalMapForCurrentFlow() {
            if (null == this.flowBeansForClientWindowKey && null == this.creationalForClientWindowKey) {
                return Collections.emptyMap();
            }
            ConcurrentHashMap result = (ConcurrentHashMap)this.sessionMap.get(this.creationalForClientWindowKey);
            if (null == result) {
                result = new ConcurrentHashMap();
                this.sessionMap.put(this.creationalForClientWindowKey, result);
                FlowCDIContext.ensureCreationalCleanupOnSessionDestroyed(this.sessionMap, this.creationalForClientWindowKey);
            }
            return result;
        }

        private void updateSession() {
            if (this.flowBeansForClientWindowKey == null && this.creationalForClientWindowKey == null) {
                return;
            }
            this.sessionMap.put(this.flowBeansForClientWindowKey, this.getFlowScopedBeanMapForCurrentFlow());
            this.sessionMap.put(this.creationalForClientWindowKey, this.getFlowScopedCreationalMapForCurrentFlow());
            Object obj = this.sessionMap.get(PER_SESSION_BEAN_MAP_LIST);
            if (obj != null) {
                this.sessionMap.put(PER_SESSION_BEAN_MAP_LIST, obj);
            }
            if ((obj = this.sessionMap.get(PER_SESSION_CREATIONAL_LIST)) != null) {
                this.sessionMap.put(PER_SESSION_CREATIONAL_LIST, obj);
            }
        }
    }

    static class FlowBeanInfo {
        String definingDocumentId;
        String id;

        public FlowBeanInfo(String definingDocumentId, String id) {
            this.definingDocumentId = definingDocumentId;
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlowBeanInfo other = (FlowBeanInfo)obj;
            if (this.definingDocumentId == null ? other.definingDocumentId != null : !this.definingDocumentId.equals(other.definingDocumentId)) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.definingDocumentId != null ? this.definingDocumentId.hashCode() : 0);
            hash = 79 * hash + (this.id != null ? this.id.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return "FlowBeanInfo{definingDocumentId=" + this.definingDocumentId + ", id=" + this.id + "}";
        }
    }
}

