/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.faces.core;

import com.sun.faces.facelets.tag.faces.core.ActionListenerHandlerBase;
import com.sun.faces.facelets.util.ReflectionUtil;
import jakarta.el.ValueExpression;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.view.ActionSource2AttachedObjectHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import jakarta.faces.view.facelets.TagConfig;
import java.io.Serializable;

public final class ActionListenerHandler
extends ActionListenerHandlerBase
implements ActionSource2AttachedObjectHandler {
    private final TagAttribute binding = this.getAttribute("binding");
    private String listenerType;
    private final TagAttribute typeAttribute = this.getAttribute("type");

    public ActionListenerHandler(TagConfig config) {
        super(config);
        if (null != this.typeAttribute) {
            String stringType = null;
            if (!this.typeAttribute.isLiteral()) {
                FacesContext context = FacesContext.getCurrentInstance();
                FaceletContext ctx = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
                stringType = (String)this.typeAttribute.getValueExpression(ctx, String.class).getValue(ctx);
            } else {
                stringType = this.typeAttribute.getValue();
            }
            this.checkType(stringType);
            this.listenerType = stringType;
        } else {
            this.listenerType = null;
        }
    }

    @Override
    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        ActionSource as = (ActionSource)((Object)parent);
        ValueExpression b = null;
        if (this.binding != null) {
            b = this.binding.getValueExpression(ctx, ActionListener.class);
        }
        LazyActionListener listener = new LazyActionListener(this.listenerType, b);
        as.addActionListener(listener);
    }

    private void checkType(String type2) {
        try {
            ReflectionUtil.forName(type2);
        }
        catch (ClassNotFoundException e) {
            throw new TagAttributeException(this.typeAttribute, "Couldn't qualify ActionListener", (Throwable)e);
        }
    }

    private static final class LazyActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -9202120013153262119L;
        private final String type;
        private final ValueExpression binding;

        public LazyActionListener(String type2, ValueExpression binding) {
            this.type = type2;
            this.binding = binding;
        }

        @Override
        public void processAction(ActionEvent event) throws AbortProcessingException {
            ActionListener instance = null;
            FacesContext faces = FacesContext.getCurrentInstance();
            if (faces == null) {
                return;
            }
            if (this.binding != null) {
                instance = (ActionListener)this.binding.getValue(faces.getELContext());
            }
            if (instance == null && this.type != null) {
                try {
                    instance = (ActionListener)ReflectionUtil.newInstance(this.type);
                }
                catch (Exception e) {
                    throw new AbortProcessingException("Could not instantiate ActionListener of type " + this.type, e);
                }
                if (this.binding != null) {
                    this.binding.setValue(faces.getELContext(), instance);
                }
            }
            if (instance != null) {
                instance.processAction(event);
            }
        }
    }
}

