/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.RIConstants;
import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ResolversRegistry;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.el.FacesCompositeELResolver;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Util;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class ELUtils {
    private static final HashMap<String, Boolean> compositeComponentEvaluationCache = new HashMap();
    private static final int compositeComponentEvaluationCacheMaxSize = 1000;
    private static final LinkedList<String> evaluationCacheFifoQueue = new LinkedList();
    private static final Boolean IS_COMPOSITE_COMPONENT = Boolean.TRUE;
    private static final Boolean IS_NOT_A_COMPOSITE_COMPONENT = Boolean.FALSE;
    private static final Pattern COMPOSITE_COMPONENT_EXPRESSION = Pattern.compile(".(?:[ ]+|[\\[{,(])cc[.].+[}]");
    private static final Pattern COMPOSITE_COMPONENT_LOOKUP_WITH_ARGS = Pattern.compile("(?:[ ]+|[\\[{,(])cc[.]attrs[.]\\w+[(].+[)]");
    private static final Pattern METHOD_EXPRESSION_LOOKUP = Pattern.compile(".[{]cc[.]attrs[.]\\w+[}]");

    private ELUtils() {
        throw new IllegalStateException();
    }

    public static boolean isCompositeComponentExpr(String expression) {
        Boolean evaluationResult = compositeComponentEvaluationCache.get(expression);
        if (evaluationResult != null) {
            return evaluationResult;
        }
        boolean returnValue = COMPOSITE_COMPONENT_EXPRESSION.matcher(expression).find();
        ELUtils.rememberEvaluationResult(expression, returnValue);
        return returnValue;
    }

    public static boolean isCompositeComponentMethodExprLookup(String expression) {
        return METHOD_EXPRESSION_LOOKUP.matcher(expression).matches();
    }

    public static boolean isCompositeComponentLookupWithArgs(String expression) {
        return COMPOSITE_COMPONENT_LOOKUP_WITH_ARGS.matcher(expression).find();
    }

    public static void buildFacesResolver(FacesCompositeELResolver composite, ApplicationAssociate associate) {
        ELUtils.checkNotNull(composite, associate);
        ELUtils.addCDIELResolver(composite);
        ResolversRegistry elRegistry = associate.getGlobalResolversRegistry();
        composite.add(elRegistry.FLASH_RESOLVER);
        composite.add(elRegistry.COMPOSITE_COMPONENT_EL_RESOLVER);
        composite.addPropertyELResolver(elRegistry.COMPOSITE_COMPONENT_ATTRIBUTES_EL_RESOLVER);
        ELUtils.addELResolvers(composite, associate.getELResolversFromFacesConfig());
        composite.add(associate.getApplicationELResolvers());
        if (WebConfiguration.getInstance().isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.InterpretEmptyStringSubmittedValuesAsNull)) {
            composite.addPropertyELResolver(elRegistry.EMPTY_STRING_TO_NULL_RESOLVER);
        }
        composite.addPropertyELResolver(elRegistry.RESOURCE_RESOLVER);
        composite.addPropertyELResolver(elRegistry.BUNDLE_RESOLVER);
        composite.addRootELResolver(elRegistry.FACES_BUNDLE_RESOLVER);
        ELUtils.addEL3_0_Resolvers(composite, associate);
        composite.addPropertyELResolver(elRegistry.MAP_RESOLVER);
        composite.addPropertyELResolver(elRegistry.LIST_RESOLVER);
        composite.addPropertyELResolver(elRegistry.ARRAY_RESOLVER);
        composite.addPropertyELResolver(elRegistry.BEAN_RESOLVER);
        composite.addRootELResolver(elRegistry.SCOPED_RESOLVER);
    }

    private static void checkNotNull(FacesCompositeELResolver composite, ApplicationAssociate associate) {
        if (associate == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "associate"));
        }
        if (composite == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "composite"));
        }
    }

    private static void addCDIELResolver(FacesCompositeELResolver composite) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        BeanManager beanManager = Util.getCdiBeanManager(facesContext);
        composite.add(beanManager.getELResolver());
    }

    private static void addEL3_0_Resolvers(FacesCompositeELResolver composite, ApplicationAssociate associate) {
        ExpressionFactory expressionFactory = associate.getExpressionFactory();
        Method getStreamELResolverMethod = ReflectionUtils.lookupMethod(ExpressionFactory.class, "getStreamELResolver", RIConstants.EMPTY_CLASS_ARGS);
        if (getStreamELResolverMethod != null) {
            try {
                ELResolver streamELResolver = (ELResolver)getStreamELResolverMethod.invoke((Object)expressionFactory, (Object[])null);
                if (streamELResolver != null) {
                    composite.addRootELResolver(streamELResolver);
                    composite.addRootELResolver((ELResolver)ReflectionUtils.newInstance("jakarta.el.StaticFieldELResolver"));
                }
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    public static Object evaluateValueExpression(ValueExpression expression, ELContext elContext) {
        if (expression.isLiteralText()) {
            return expression.getExpressionString();
        }
        return expression.getValue(elContext);
    }

    public static ValueExpression createValueExpression(String expression) {
        return ELUtils.createValueExpression(expression, Object.class);
    }

    public static ValueExpression createValueExpression(String expression, Class<?> expectedType) {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), expression, expectedType);
    }

    public static Object coerce(Object value, Class<?> toType) {
        return FacesContext.getCurrentInstance().getApplication().getExpressionFactory().coerceToType(value, toType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rememberEvaluationResult(String expression, boolean isCompositeComponent) {
        HashMap<String, Boolean> hashMap = compositeComponentEvaluationCache;
        synchronized (hashMap) {
            if (compositeComponentEvaluationCache.size() >= 1000) {
                String oldestExpression = evaluationCacheFifoQueue.removeFirst();
                compositeComponentEvaluationCache.remove(oldestExpression);
            }
            if (isCompositeComponent) {
                compositeComponentEvaluationCache.put(expression, IS_COMPOSITE_COMPONENT);
            } else {
                compositeComponentEvaluationCache.put(expression, IS_NOT_A_COMPOSITE_COMPONENT);
            }
            evaluationCacheFifoQueue.add(expression);
        }
    }

    private static void addELResolvers(CompositeELResolver target, List<ELResolver> resolvers) {
        if (resolvers != null && !resolvers.isEmpty()) {
            for (ELResolver resolver : resolvers) {
                target.add(resolver);
            }
        }
    }

    public static ExpressionFactory getDefaultExpressionFactory(FacesContext facesContext) {
        if (facesContext == null) {
            return null;
        }
        ExternalContext extContext = facesContext.getExternalContext();
        if (extContext == null) {
            return null;
        }
        return ELUtils.getDefaultExpressionFactory(ApplicationAssociate.getInstance(extContext), facesContext);
    }

    public static ExpressionFactory getDefaultExpressionFactory(ApplicationAssociate associate, FacesContext facesContext) {
        if (associate == null) {
            return null;
        }
        return associate.getExpressionFactory();
    }
}

