/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.cdi.FacesContextProducer;
import com.sun.faces.el.ELContextImpl;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import jakarta.el.ELContext;
import jakarta.el.ELContextEvent;
import jakarta.el.ELContextListener;
import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.PartialViewContext;
import jakarta.faces.context.PartialViewContextFactory;
import jakarta.faces.context.ResponseStream;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.PhaseId;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class FacesContextImpl
extends FacesContext {
    private static final String POST_BACK_MARKER = FacesContextImpl.class.getName() + "_POST_BACK";
    private static final ThreadLocal<FacesContext> DEFAULT_FACES_CONTEXT = new ThreadLocal();
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private boolean released;
    private ResponseStream responseStream = null;
    private ResponseWriter responseWriter = null;
    private ExternalContext externalContext = null;
    private Lifecycle lifecycle;
    private Application application = null;
    private UIViewRoot viewRoot = null;
    private ELContext elContext = null;
    private RenderKitFactory rkFactory;
    private RenderKit lastRk;
    private String lastRkId;
    private FacesMessage.Severity maxSeverity;
    private boolean renderResponse = false;
    private boolean responseComplete = false;
    private boolean validationFailed = false;
    private Map<Object, Object> attributes;
    private List<String> resourceLibraryContracts;
    private PhaseId currentPhaseId;
    private PartialViewContext partialViewContext = null;
    private ExceptionHandler exceptionHandler = null;
    private Map<String, List<FacesMessage>> componentMessageLists;

    public FacesContextImpl(ExternalContext ec, Lifecycle lifecycle) {
        Util.notNull("ec", ec);
        Util.notNull("lifecycle", lifecycle);
        this.externalContext = ec;
        this.lifecycle = lifecycle;
        FacesContextImpl.setCurrentInstance(this);
        DEFAULT_FACES_CONTEXT.set(this);
        this.rkFactory = (RenderKitFactory)FactoryFinder.getFactory("jakarta.faces.render.RenderKitFactory");
    }

    @Override
    public Lifecycle getLifecycle() {
        this.assertNotReleased();
        return this.lifecycle;
    }

    @Override
    public ExternalContext getExternalContext() {
        this.assertNotReleased();
        return this.externalContext;
    }

    @Override
    public Application getApplication() {
        this.assertNotReleased();
        if (null != this.application) {
            return this.application;
        }
        ApplicationFactory aFactory = (ApplicationFactory)FactoryFinder.getFactory("jakarta.faces.application.ApplicationFactory");
        this.application = aFactory.getApplication();
        assert (null != this.application);
        return this.application;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public PartialViewContext getPartialViewContext() {
        this.assertNotReleased();
        if (this.partialViewContext == null) {
            PartialViewContextFactory f = (PartialViewContextFactory)FactoryFinder.getFactory("jakarta.faces.context.PartialViewContextFactory");
            this.partialViewContext = f.getPartialViewContext(FacesContext.getCurrentInstance());
        }
        return this.partialViewContext;
    }

    @Override
    public boolean isPostback() {
        this.assertNotReleased();
        Boolean postback = (Boolean)this.getAttributes().get(POST_BACK_MARKER);
        if (postback == null) {
            RenderKit rk = this.getRenderKit();
            if (rk != null) {
                postback = rk.getResponseStateManager().isPostback(this);
            } else {
                ViewHandler vh = this.getApplication().getViewHandler();
                String rkId = vh.calculateRenderKitId(this);
                postback = RenderKitUtils.getResponseStateManager(this, rkId).isPostback(this);
            }
            this.getAttributes().put(POST_BACK_MARKER, postback);
        }
        return postback;
    }

    @Override
    public boolean isReleased() {
        return this.released;
    }

    @Override
    public Map<Object, Object> getAttributes() {
        this.assertNotReleased();
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>();
        }
        return this.attributes;
    }

    @Override
    public ELContext getELContext() {
        this.assertNotReleased();
        if (this.elContext == null) {
            this.elContext = new ELContextImpl(FacesContext.getCurrentInstance());
            ELContextListener[] listeners = this.getApplication().getELContextListeners();
            if (listeners.length > 0) {
                ELContextEvent event = new ELContextEvent(this.elContext);
                for (ELContextListener listener : listeners) {
                    listener.contextCreated(event);
                }
            }
        }
        return this.elContext;
    }

    @Override
    public Iterator<String> getClientIdsWithMessages() {
        this.assertNotReleased();
        return this.componentMessageLists == null ? Collections.emptyList().iterator() : this.componentMessageLists.keySet().iterator();
    }

    @Override
    public FacesMessage.Severity getMaximumSeverity() {
        this.assertNotReleased();
        FacesMessage.Severity result = null;
        if (this.componentMessageLists != null && !this.componentMessageLists.isEmpty()) {
            ComponentMessagesIterator i = new ComponentMessagesIterator(this.componentMessageLists);
            while (i.hasNext()) {
                FacesMessage.Severity severity = ((FacesMessage)i.next()).getSeverity();
                if (result == null || severity.compareTo(result) > 0) {
                    result = severity;
                }
                if (result != FacesMessage.SEVERITY_FATAL) continue;
                break;
            }
        }
        return result;
    }

    @Override
    public List<FacesMessage> getMessageList() {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
        ArrayList<FacesMessage> messages = new ArrayList<FacesMessage>();
        for (List<FacesMessage> list : this.componentMessageLists.values()) {
            messages.addAll(list);
        }
        return Collections.unmodifiableList(messages);
    }

    @Override
    public List<FacesMessage> getMessageList(String clientId) {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
        List<FacesMessage> list = this.componentMessageLists.get(clientId);
        return Collections.unmodifiableList(list != null ? list : Collections.emptyList());
    }

    @Override
    public Iterator<FacesMessage> getMessages() {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        if (this.componentMessageLists.size() > 0) {
            return new ComponentMessagesIterator(this.componentMessageLists);
        }
        List emptyList = Collections.emptyList();
        return emptyList.iterator();
    }

    @Override
    public Iterator<FacesMessage> getMessages(String clientId) {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        List<FacesMessage> list = this.componentMessageLists.get(clientId);
        if (list == null) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        return list.iterator();
    }

    @Override
    public RenderKit getRenderKit() {
        this.assertNotReleased();
        UIViewRoot vr = this.getViewRoot();
        if (vr == null) {
            return null;
        }
        String renderKitId = vr.getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        if (renderKitId.equals(this.lastRkId)) {
            return this.lastRk;
        }
        this.lastRk = this.rkFactory.getRenderKit(this, renderKitId);
        if (this.lastRk == null && LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, "Unable to locate renderkit instance for render-kit-id {0}.  Using {1} instead.", new String[]{renderKitId, "HTML_BASIC"});
        }
        this.lastRkId = renderKitId;
        return this.lastRk;
    }

    @Override
    public ResponseStream getResponseStream() {
        this.assertNotReleased();
        return this.responseStream;
    }

    @Override
    public void setResponseStream(ResponseStream responseStream) {
        this.assertNotReleased();
        Util.notNull("responseStrean", responseStream);
        this.responseStream = responseStream;
    }

    @Override
    public UIViewRoot getViewRoot() {
        this.assertNotReleased();
        return this.viewRoot;
    }

    @Override
    public void setViewRoot(UIViewRoot root) {
        this.assertNotReleased();
        Util.notNull("root", root);
        if (this.viewRoot != null && !this.viewRoot.equals(root)) {
            Map<String, Object> viewMap = this.viewRoot.getViewMap(false);
            if (viewMap != null) {
                viewMap.clear();
            }
            RequestStateManager.clearAttributesOnChangeOfView(this);
        }
        this.viewRoot = root;
    }

    @Override
    public ResponseWriter getResponseWriter() {
        this.assertNotReleased();
        return this.responseWriter;
    }

    @Override
    public void setResponseWriter(ResponseWriter responseWriter) {
        this.assertNotReleased();
        Util.notNull("responseWriter", responseWriter);
        this.responseWriter = responseWriter;
    }

    @Override
    public void addMessage(String clientId, FacesMessage message) {
        List<FacesMessage> list;
        this.assertNotReleased();
        Util.notNull("message", message);
        if (this.maxSeverity == null) {
            this.maxSeverity = message.getSeverity();
        } else {
            FacesMessage.Severity sev = message.getSeverity();
            if (sev.getOrdinal() > this.maxSeverity.getOrdinal()) {
                this.maxSeverity = sev;
            }
        }
        if (this.componentMessageLists == null) {
            this.componentMessageLists = new LinkedHashMap<String, List<FacesMessage>>();
        }
        if ((list = this.componentMessageLists.get(clientId)) == null) {
            list = new ArrayList<FacesMessage>();
            this.componentMessageLists.put(clientId, list);
        }
        list.add(message);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding Message[sourceId=" + (clientId != null ? clientId : "<<NONE>>") + ",summary=" + message.getSummary() + ")");
        }
    }

    @Override
    public PhaseId getCurrentPhaseId() {
        this.assertNotReleased();
        return this.currentPhaseId;
    }

    @Override
    public void setCurrentPhaseId(PhaseId currentPhaseId) {
        this.assertNotReleased();
        this.currentPhaseId = currentPhaseId;
    }

    @Override
    public void release() {
        BeanManager beanManager = Util.getCdiBeanManager(this);
        this.released = true;
        if (this.externalContext != null) {
            this.externalContext.release();
        }
        this.lifecycle = null;
        this.externalContext = null;
        this.responseStream = null;
        this.responseWriter = null;
        this.componentMessageLists = null;
        this.renderResponse = false;
        this.responseComplete = false;
        this.validationFailed = false;
        this.viewRoot = null;
        this.maxSeverity = null;
        this.application = null;
        this.currentPhaseId = null;
        if (this.attributes != null) {
            this.attributes.clear();
            this.attributes = null;
        }
        if (null != this.resourceLibraryContracts) {
            this.resourceLibraryContracts.clear();
            this.resourceLibraryContracts = null;
        }
        if (this.partialViewContext != null) {
            this.partialViewContext.release();
        }
        this.partialViewContext = null;
        this.exceptionHandler = null;
        this.elContext = null;
        this.rkFactory = null;
        this.lastRk = null;
        this.lastRkId = null;
        FacesContextImpl.setCurrentInstance(null);
        DEFAULT_FACES_CONTEXT.remove();
        Set beans = beanManager.getBeans((Type)((Object)FacesContext.class), new Annotation[0]).stream().filter(bean -> bean.getTypes().contains(FacesContextProducer.class)).collect(Collectors.toSet());
        Bean bean2 = beanManager.resolve(beans);
        ((AlterableContext)beanManager.getContext(bean2.getScope())).destroy(bean2);
    }

    @Override
    public void renderResponse() {
        this.assertNotReleased();
        this.renderResponse = true;
    }

    @Override
    public void responseComplete() {
        this.assertNotReleased();
        this.responseComplete = true;
    }

    @Override
    public void validationFailed() {
        this.assertNotReleased();
        this.validationFailed = true;
    }

    @Override
    public boolean getRenderResponse() {
        this.assertNotReleased();
        return this.renderResponse;
    }

    @Override
    public List<String> getResourceLibraryContracts() {
        this.assertNotReleased();
        return null == this.resourceLibraryContracts ? Collections.emptyList() : this.resourceLibraryContracts;
    }

    @Override
    public void setResourceLibraryContracts(List<String> contracts) {
        this.assertNotReleased();
        if (null == contracts || contracts.isEmpty()) {
            if (null != this.resourceLibraryContracts) {
                this.resourceLibraryContracts.clear();
                this.resourceLibraryContracts = null;
            }
        } else {
            this.resourceLibraryContracts = new ArrayList<String>(contracts);
        }
    }

    @Override
    public boolean getResponseComplete() {
        this.assertNotReleased();
        return this.responseComplete;
    }

    @Override
    public boolean isValidationFailed() {
        this.assertNotReleased();
        return this.validationFailed;
    }

    public static FacesContext getDefaultFacesContext() {
        return DEFAULT_FACES_CONTEXT.get();
    }

    private void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException();
        }
    }

    private static final class ComponentMessagesIterator
    implements Iterator<FacesMessage> {
        private Map<String, List<FacesMessage>> messages;
        private int outerIndex = -1;
        private int messagesSize;
        private Iterator<FacesMessage> inner;
        private Iterator<String> keys;

        ComponentMessagesIterator(Map<String, List<FacesMessage>> messages) {
            this.messages = messages;
            this.messagesSize = messages.size();
            this.keys = messages.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.outerIndex == -1) {
                ++this.outerIndex;
                this.inner = this.messages.get(this.keys.next()).iterator();
            }
            while (!this.inner.hasNext()) {
                ++this.outerIndex;
                if (this.outerIndex < this.messagesSize) {
                    this.inner = this.messages.get(this.keys.next()).iterator();
                    continue;
                }
                return false;
            }
            return this.inner.hasNext();
        }

        @Override
        public FacesMessage next() {
            if (this.outerIndex >= this.messagesSize) {
                throw new NoSuchElementException();
            }
            if (this.inner != null && this.inner.hasNext()) {
                return this.inner.next();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.inner.next();
        }

        @Override
        public void remove() {
            if (this.outerIndex == -1) {
                throw new IllegalStateException();
            }
            this.inner.remove();
        }
    }
}

