/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.ViewScopeContext;
import com.sun.faces.application.view.ViewScopedCDIEventFireHelperImpl;
import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.util.FacesLogger;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.faces.view.ViewScoped;
import java.util.logging.Logger;

public class ViewScopeExtension
implements Extension {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();

    public ViewScopeExtension() {
        LOGGER.finest("Constructor @ViewScoped CDI Extension called");
    }

    public void beforeBean(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        CdiUtils.addAnnotatedTypes(beforeBeanDiscovery, beanManager, ViewScopedCDIEventFireHelperImpl.class);
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        event.addScope(ViewScoped.class, true, true);
    }

    public void processBean(@Observes ProcessBean<?> event) {
        ViewScoped viewScoped = event.getAnnotated().getAnnotation(ViewScoped.class);
        if (viewScoped != null) {
            LOGGER.finest("Processing occurrence of @ViewScoped");
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        LOGGER.finest("Adding @ViewScoped context to CDI runtime");
        event.addContext(new ViewScopeContext());
    }
}

