/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.logger;

import jakarta.servlet.ServletException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Logger;

abstract class LoggerBase
implements Logger {
    protected Container container = null;
    protected static final String info = "com.sun.enterprise.web.logger.LoggerBase/1.0";
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    LoggerBase() {
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int getVerbosity() {
        return -1;
    }

    @Override
    public void setVerbosity(int verbosity) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void log(String msg) {
        this.write(msg, 4);
    }

    @Override
    public void log(Exception exception, String msg) {
        this.log(msg, exception);
    }

    @Override
    public void log(String msg, Throwable throwable) {
        this.write(msg, throwable, 1);
    }

    @Override
    public void log(String message, int verbosity) {
        this.write(message, verbosity);
    }

    @Override
    public void log(String message, Throwable throwable, int verbosity) {
        this.write(message, throwable, verbosity);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    protected void write(String msg, Throwable throwable, int verbosity) {
        CharArrayWriter buf = new CharArrayWriter();
        PrintWriter writer = new PrintWriter(buf);
        writer.println(msg);
        throwable.printStackTrace(writer);
        Throwable rootCause = null;
        if (throwable instanceof LifecycleException) {
            rootCause = ((LifecycleException)throwable).getCause();
        } else if (throwable instanceof ServletException) {
            rootCause = ((ServletException)throwable).getRootCause();
        }
        if (rootCause != null) {
            writer.println("----- Root Cause -----");
            rootCause.printStackTrace(writer);
        }
        this.write(buf.toString(), verbosity);
    }

    protected abstract void write(String var1, int var2);
}

