/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.web.cache.CacheManager;
import com.sun.enterprise.container.common.spi.CDIService;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.util.net.JarURIPattern;
import com.sun.enterprise.web.CacheModule;
import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.jsp.JspProbeEmitterImpl;
import com.sun.enterprise.web.jsp.ResourceInjectorImpl;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.web.TldProvider;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.Populator;
import org.glassfish.hk2.api.PopulatorPostProcessor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.ClasspathDescriptorFileFinder;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.web.LogFacade;
import org.glassfish.web.deployment.runtime.SunWebAppImpl;
import org.glassfish.web.deployment.runtime.WebProperty;
import org.glassfish.web.deployment.util.WebValidatorWithCL;

final class WebModuleListener
implements LifecycleListener {
    private static final Logger _logger = LogFacade.getLogger();
    private final WebBundleDescriptor webBundleDescriptor;
    private final WebContainer webContainer;
    private boolean includeInitialized;
    private List<String> includeJars;

    WebModuleListener(WebContainer webContainer, WebBundleDescriptor wbd) {
        this.webContainer = webContainer;
        this.webBundleDescriptor = wbd;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        WebModule webModule;
        try {
            webModule = (WebModule)event.getLifecycle();
        }
        catch (ClassCastException e) {
            _logger.log(Level.WARNING, "AS-WEB-GLUE-00259", event.getLifecycle());
            return;
        }
        if (event.getType().equals("start")) {
            if (this.webBundleDescriptor != null && this.webBundleDescriptor.getApplication() != null && this.webBundleDescriptor.getApplication().isVirtual()) {
                this.webBundleDescriptor.setClassLoader(webModule.getLoader().getClassLoader());
                this.webBundleDescriptor.visit(new WebValidatorWithCL());
            }
            this.configureDefaultServlet(webModule);
            this.configureJsp(webModule);
            this.startCacheManager(webModule);
        } else if (event.getType().equals("stop")) {
            this.stopCacheManager(webModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureJsp(WebModule webModule) {
        ServletContext servletContext = webModule.getServletContext();
        servletContext.setAttribute("org.glassfish.jsp.isStandaloneWebapp", webModule.isStandalone());
        List<URI> appLibUris = webModule.getDeployAppLibs();
        HashMap<URI, List<String>> appLibTldMap = new HashMap<URI, List<String>>();
        if (appLibUris != null && appLibUris.size() > 0) {
            Pattern pattern = Pattern.compile("META-INF/.*\\.tld");
            for (URI uRI : appLibUris) {
                List<String> list = JarURIPattern.getJarEntries(uRI, pattern);
                if (list == null || list.size() <= 0) continue;
                appLibTldMap.put(uRI, list);
            }
        }
        Collection<TldProvider> tldProviders = this.webContainer.getTldProviders();
        HashMap<URI, List<String>> tldMap = new HashMap<URI, List<String>>();
        for (TldProvider tldProvider : tldProviders) {
            Map<URI, List<String>> tmap;
            if ("jsfTld".equals(tldProvider.getName()) && !webModule.isJsfApplication() || (tmap = tldProvider.getTldMap()) == null) continue;
            tldMap.putAll(tmap);
        }
        tldMap.putAll(appLibTldMap);
        servletContext.setAttribute("com.sun.appserv.tld.map", tldMap);
        HashMap<URI, List<String>> hashMap = new HashMap<URI, List<String>>();
        for (TldProvider tldProvider : tldProviders) {
            Map<URI, List<String>> tmap;
            if ("jsfTld".equals(tldProvider.getName()) && !webModule.isJsfApplication() || (tmap = tldProvider.getTldListenerMap()) == null) continue;
            hashMap.putAll(tmap);
        }
        hashMap.putAll(appLibTldMap);
        servletContext.setAttribute("com.sun.appserv.tldlistener.map", hashMap);
        ServiceLocator serviceLocator = this.webContainer.getServerContext().getDefaultServices();
        if (webModule.isSystemApplication()) {
            servletContext.setAttribute("org.glassfish.servlet.habitat", this.createWebAppServices(webModule, serviceLocator));
        } else {
            servletContext.setAttribute("org.glassfish.servlet.habitat", serviceLocator);
        }
        SunWebAppImpl bean = webModule.getIasWebAppConfigBean();
        Wrapper wrapper = (Wrapper)webModule.findChild("jsp");
        if (wrapper == null) {
            return;
        }
        if (webModule.getTldValidation()) {
            wrapper.addInitParameter("enableTldValidation", "true");
        }
        if (bean != null && bean.getJspConfig() != null) {
            WebProperty[] props;
            for (WebProperty prop : props = bean.getJspConfig().getWebProperty()) {
                String pname = (String)prop.getValue("name");
                String pvalue = (String)prop.getValue("value");
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "AS-WEB-GLUE-00260", "[" + webModule.getID() + "] is [" + pname + "] = [" + pvalue + "]");
                }
                wrapper.addInitParameter(pname, pvalue);
            }
        }
        wrapper.addInitParameter("logVerbosityLevel", this.getWaspLogLevel());
        ResourceInjectorImpl resourceInjector = new ResourceInjectorImpl(webModule);
        servletContext.setAttribute("com.sun.appserv.jsp.resource.injector", resourceInjector);
        String sysClassPath = ASClassLoaderUtil.getModuleClassPath(serviceLocator, webModule.getID(), null);
        Boolean useMyFaces = (Boolean)servletContext.getAttribute("com.sun.faces.useMyFaces");
        if (useMyFaces != null && useMyFaces.booleanValue()) {
            sysClassPath = sysClassPath.replace("jakarta.faces.jar", "$disabled$.raj");
            sysClassPath = sysClassPath.replace("jsf-connector.jar", "$disabled$.raj");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "AS-WEB-GLUE-00261", webModule.getID() + " is " + sysClassPath);
        }
        if (sysClassPath.isEmpty()) {
            sysClassPath = System.getProperty("java.class.path");
        }
        sysClassPath = this.trimSysClassPath(sysClassPath);
        wrapper.addInitParameter("com.sun.appserv.jsp.classpath", sysClassPath);
        servletContext.setAttribute("org.glassfish.jsp.monitor.probeEmitter", new JspProbeEmitterImpl(webModule));
        InvocationManager invocationManager = this.webContainer.getInvocationManager();
        WebComponentInvocation webComponentInvocation = new WebComponentInvocation(webModule);
        try {
            invocationManager.preInvoke(webComponentInvocation);
            CDIService cdiService = serviceLocator.getService(CDIService.class, new Annotation[0]);
            if (cdiService != null && cdiService.isCurrentModuleCDIEnabled()) {
                cdiService.setELResolver(servletContext);
            }
        }
        catch (NamingException e) {
            _logger.log(Level.CONFIG, "Setting the ELResolver failed. Ignoring the exception.", e);
        }
        finally {
            invocationManager.postInvoke(webComponentInvocation);
        }
    }

    private ServiceLocator createWebAppServices(WebModule webModule, ServiceLocator defaultServices) {
        ServiceLocator webAppServices = ServiceLocatorFactory.getInstance().create(webModule.getComponentId(), defaultServices);
        WebModuleListener.initializeServicesFromClassLoader(webAppServices, Thread.currentThread().getContextClassLoader());
        return webAppServices;
    }

    private static void initializeServicesFromClassLoader(ServiceLocator serviceLocator, ClassLoader classLoader) {
        DynamicConfigurationService dcs = serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        Populator populator = dcs.getPopulator();
        try {
            populator.populate(new ClasspathDescriptorFileFinder(classLoader), new PopulatorPostProcessor[0]);
        }
        catch (IOException | MultiException ex) {
            _logger.log(Level.SEVERE, ex, ex::getMessage);
        }
    }

    private void initIncludeJars() {
        if (this.includeInitialized) {
            return;
        }
        String includeJarsString = null;
        for (WebComponentDescriptor wcd : this.webBundleDescriptor.getWebComponentDescriptors()) {
            InitializationParameter initp;
            if (!"jsp".equals(wcd.getCanonicalName()) || (initp = wcd.getInitializationParameterByName("system-jar-includes")) == null) continue;
            includeJarsString = initp.getValue();
            break;
        }
        this.includeInitialized = true;
        if (includeJarsString == null) {
            this.includeJars = null;
            return;
        }
        this.includeJars = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(includeJarsString);
        while (tokenizer.hasMoreElements()) {
            this.includeJars.add(tokenizer.nextToken());
        }
    }

    private boolean included(String path) {
        for (String item : this.includeJars) {
            if (!path.contains(item)) continue;
            return true;
        }
        return false;
    }

    private String trimSysClassPath(String sysClassPath) {
        if (sysClassPath == null || sysClassPath.isEmpty()) {
            return "";
        }
        this.initIncludeJars();
        if (this.includeJars == null || this.includeJars.size() == 0) {
            return sysClassPath;
        }
        StringBuilder ret = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(sysClassPath, File.pathSeparator);
        String mySep = "";
        while (tokenizer.hasMoreElements()) {
            String path = tokenizer.nextToken();
            if (!this.included(path)) continue;
            ret.append(mySep);
            ret.append(path);
            mySep = File.pathSeparator;
        }
        return ret.toString();
    }

    private String getWaspLogLevel() {
        Level level = _logger.getLevel();
        if (level == null) {
            return "warning";
        }
        if (level.equals(Level.WARNING)) {
            return "warning";
        }
        if (level.equals(Level.FINE)) {
            return "information";
        }
        if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            return "debug";
        }
        return "warning";
    }

    private void startCacheManager(WebModule webModule) {
        SunWebAppImpl bean = webModule.getIasWebAppConfigBean();
        if (bean != null) {
            CacheManager cm = null;
            try {
                cm = CacheModule.configureResponseCache(webModule, bean);
            }
            catch (Exception ee) {
                _logger.log(Level.WARNING, "AS-WEB-GLUE-00262", ee);
            }
            if (cm != null) {
                try {
                    cm.start();
                    _logger.log(Level.FINE, "AS-WEB-GLUE-00263");
                    ServletContext ctxt = webModule.getServletContext();
                    ctxt.setAttribute("com.sun.appserv.web.CacheManager", cm);
                }
                catch (LifecycleException ee) {
                    _logger.log(Level.WARNING, ee.getMessage(), ee.getCause());
                }
            }
        }
    }

    private void stopCacheManager(WebModule webModule) {
        ServletContext ctxt = webModule.getServletContext();
        CacheManager cm = (CacheManager)ctxt.getAttribute("com.sun.appserv.web.CacheManager");
        if (cm != null) {
            try {
                cm.stop();
                _logger.log(Level.FINE, "AS-WEB-GLUE-00264");
                ctxt.removeAttribute("com.sun.appserv.web.CacheManager");
            }
            catch (LifecycleException ee) {
                _logger.log(Level.WARNING, ee.getMessage(), ee.getCause());
            }
        }
    }

    private void configureDefaultServlet(WebModule webModule) {
        Wrapper wrapper = (Wrapper)webModule.findChild("default");
        if (wrapper == null) {
            return;
        }
        String servletClass = wrapper.getServletClassName();
        if (servletClass == null || !servletClass.equals(Globals.DEFAULT_SERVLET_CLASS_NAME)) {
            return;
        }
        String fileEncoding = webModule.getFileEncoding();
        if (fileEncoding != null) {
            wrapper.addInitParameter("fileEncoding", fileEncoding);
        }
    }
}

