/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.web.cache.CacheManager;
import com.sun.appserv.web.cache.mapping.Field;
import com.sun.appserv.web.cache.mapping.ValueConstraint;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.web.WebModule;
import jakarta.servlet.DispatcherType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.glassfish.web.LogFacade;
import org.glassfish.web.deployment.runtime.Cache;
import org.glassfish.web.deployment.runtime.CacheHelper;
import org.glassfish.web.deployment.runtime.CacheMapping;
import org.glassfish.web.deployment.runtime.ConstraintField;
import org.glassfish.web.deployment.runtime.DefaultHelper;
import org.glassfish.web.deployment.runtime.SunWebAppImpl;
import org.glassfish.web.deployment.runtime.WebProperty;

public final class CacheModule {
    public static final String CACHING_FILTER_CLASSNAME = "com.sun.appserv.web.cache.filter.CachingFilter";
    public static final String DEFAULT_CACHE_HELPER_CLASSNAME = "com.sun.appserv.web.cache.DefaultCacheHelper";
    public static final Logger logger = LogFacade.getLogger();

    private static String trim(String str) {
        if (str != null) {
            return str.trim();
        }
        return str;
    }

    public static CacheManager configureResponseCache(WebModule app, SunWebApp bean) throws Exception {
        int i;
        String name;
        Cache cacheConfig = ((SunWebAppImpl)bean).getCache();
        if (cacheConfig == null) {
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AS-WEB-GLUE-00062", app.getPath());
        }
        CacheManager manager = new CacheManager();
        String value = cacheConfig.getAttributeValue("Enabled");
        if (value != null) {
            boolean enabled = ConfigBeansUtilities.toBoolean(value);
            manager.setEnabled(enabled);
        }
        if ((value = cacheConfig.getAttributeValue("MaxEntries")) != null) {
            try {
                int maxEntries = Integer.parseInt(value.trim());
                manager.setMaxEntries(maxEntries);
            }
            catch (NumberFormatException e) {
                throw new Exception("invalid max-entries", e);
            }
        }
        if ((value = cacheConfig.getAttributeValue("TimeoutInSeconds")) != null) {
            try {
                int defaultTimeout = Integer.parseInt(value.trim());
                manager.setDefaultTimeout(defaultTimeout);
            }
            catch (NumberFormatException e) {
                throw new Exception("invalid timeout", e);
            }
        }
        WebProperty[] props = cacheConfig.getWebProperty();
        for (int i2 = 0; i2 < props.length; ++i2) {
            name = props[i2].getAttributeValue("name");
            value = props[i2].getAttributeValue("value");
            manager.addProperty(name, value);
        }
        DefaultHelper defHelperConfig = cacheConfig.getDefaultHelper();
        HashMap<String, String> map = new HashMap<String, String>();
        if (defHelperConfig != null) {
            props = defHelperConfig.getWebProperty();
            for (i = 0; i < props.length; ++i) {
                name = props[i].getAttributeValue("name");
                value = props[i].getAttributeValue("value");
                map.put(name, value);
            }
        }
        manager.setDefaultHelperProps(map);
        for (i = 0; i < cacheConfig.sizeCacheHelper(); ++i) {
            CacheHelper helperConfig = cacheConfig.getCacheHelper(i);
            String helperName = helperConfig.getAttributeValue("Name");
            HashMap<String, String> helperProps = new HashMap<String, String>();
            props = helperConfig.getWebProperty();
            for (int j = 0; j < props.length; ++j) {
                name = props[i].getAttributeValue("name");
                value = props[i].getAttributeValue("value");
                helperProps.put(name, value);
            }
            helperProps.put("class-name", helperConfig.getAttributeValue("ClassName"));
            manager.addCacheHelperDef(helperName, helperProps);
        }
        for (i = 0; i < cacheConfig.sizeCacheMapping(); ++i) {
            CacheMapping mapConfig = cacheConfig.getCacheMapping(i);
            com.sun.appserv.web.cache.mapping.CacheMapping mapping = new com.sun.appserv.web.cache.mapping.CacheMapping();
            CacheModule.configureCacheMapping(mapConfig, mapping, logger);
            String filterName = CACHING_FILTER_CLASSNAME + i;
            manager.addCacheMapping(filterName, mapping);
            FilterDef filterDef = new FilterDef();
            filterDef.setFilterName(filterName);
            filterDef.setFilterClassName(CACHING_FILTER_CLASSNAME);
            if (mapping.getServletName() != null) {
                filterDef.addInitParameter("servletName", mapping.getServletName());
            }
            if (mapping.getURLPattern() != null) {
                filterDef.addInitParameter("URLPattern", mapping.getURLPattern());
            }
            app.addFilterDef(filterDef);
            FilterMap filterMap = new FilterMap();
            filterMap.setServletName(mapping.getServletName());
            filterMap.setURLPattern(mapping.getURLPattern());
            String[] dispatchers = mapConfig.getDispatcher();
            if (dispatchers != null) {
                EnumSet<DispatcherType> dispatcherTypes = null;
                for (String dispatcher : dispatchers) {
                    if (dispatcherTypes == null) {
                        dispatcherTypes = EnumSet.of(Enum.valueOf(DispatcherType.class, dispatcher));
                        continue;
                    }
                    dispatcherTypes.add(Enum.valueOf(DispatcherType.class, dispatcher));
                }
                filterMap.setDispatcherTypes(dispatcherTypes);
            }
            filterMap.setFilterName(filterName);
            app.addFilterMap(filterMap);
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "AS-WEB-GLUE-00063", new Object[]{mapping.getServletName(), mapping.getURLPattern()});
        }
        manager.setServletContext(app.getServletContext());
        return manager;
    }

    private static void configureCacheMapping(CacheMapping mapConfig, com.sun.appserv.web.cache.mapping.CacheMapping mapping, Logger logger2) throws Exception {
        int i;
        String scope;
        String name;
        mapping.setServletName(CacheModule.trim(mapConfig.getServletName()));
        mapping.setURLPattern(CacheModule.trim(mapConfig.getURLPattern()));
        String helperRef = mapConfig.getCacheHelperRef();
        if (helperRef == null) {
            helperRef = "default";
        }
        mapping.setHelperNameRef(helperRef);
        String value = mapConfig.getTimeout();
        if (value != null) {
            try {
                mapping.setTimeout(Integer.parseInt(value.trim()));
            }
            catch (NumberFormatException e) {
                throw new Exception("invalid timeout", e);
            }
        } else {
            name = mapConfig.getAttributeValue("Timeout", "Name");
            scope = mapConfig.getAttributeValue("Timeout", "Scope");
            if (name != null && scope != null) {
                mapping.setTimeoutField(new Field(name, scope));
            }
        }
        name = mapConfig.getAttributeValue("RefreshField", "Name");
        scope = mapConfig.getAttributeValue("RefreshField", "Scope");
        if (name != null && scope != null) {
            Field refreshField = new Field(name, scope);
            mapping.setRefreshField(refreshField);
        }
        if (mapConfig.sizeHttpMethod() > 0) {
            mapping.setMethods(mapConfig.getHttpMethod());
        }
        for (i = 0; i < mapConfig.sizeKeyField(); ++i) {
            name = mapConfig.getAttributeValue("KeyField", i, "Name");
            scope = mapConfig.getAttributeValue("KeyField", i, "Scope");
            if (name == null || scope == null) continue;
            mapping.addKeyField(new Field(name, scope));
            if (!logger2.isLoggable(Level.FINE)) continue;
            logger2.log(Level.FINE, "AS-WEB-GLUE-00064", new Object[]{name, scope});
        }
        for (i = 0; i < mapConfig.sizeConstraintField(); ++i) {
            ConstraintField fieldConfig = mapConfig.getConstraintField(i);
            name = fieldConfig.getAttributeValue("Name");
            scope = fieldConfig.getAttributeValue("Scope");
            com.sun.appserv.web.cache.mapping.ConstraintField constraintField = new com.sun.appserv.web.cache.mapping.ConstraintField(name, scope);
            value = fieldConfig.getAttributeValue("CacheOnMatch");
            if (value != null) {
                constraintField.setCacheOnMatch(ConfigBeansUtilities.toBoolean(value));
            }
            if ((value = fieldConfig.getAttributeValue("CacheOnMatchFailure")) != null) {
                constraintField.setCacheOnMatchFailure(ConfigBeansUtilities.toBoolean(value));
            }
            for (int j = 0; j < fieldConfig.sizeValue(); ++j) {
                value = fieldConfig.getValue(j).trim();
                String expr = fieldConfig.getAttributeValue("Value", j, "MatchExpr");
                ValueConstraint constraint = new ValueConstraint(value, expr);
                value = fieldConfig.getAttributeValue("Value", j, "CacheOnMatch");
                if (value != null) {
                    constraint.setCacheOnMatch(ConfigBeansUtilities.toBoolean(value));
                }
                if ((value = fieldConfig.getAttributeValue("Value", j, "CacheOnMatchFailure")) != null) {
                    constraint.setCacheOnMatchFailure(ConfigBeansUtilities.toBoolean(value));
                }
                constraintField.addConstraint(constraint);
                if (!logger2.isLoggable(Level.FINE)) continue;
                logger2.log(Level.FINE, "AS-WEB-GLUE-00065", constraint.toString());
            }
            mapping.addConstraintField(constraintField);
            if (!logger2.isLoggable(Level.FINE)) continue;
            logger2.log(Level.FINE, "AS-WEB-GLUE-00066", new Object[]{name, scope, constraintField.getCacheOnMatch(), constraintField.getCacheOnMatchFailure()});
        }
    }
}

