/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import com.sun.enterprise.v3.common.ActionReporter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="json")
@PerLookup
public class JsonActionReporter
extends ActionReporter {
    private boolean top = true;

    @Override
    public void writeReport(OutputStream os) throws IOException {
        PrintWriter writer = new PrintWriter(os);
        this.write(this.topMessage, writer);
        if (this.exception != null) {
            writer.println("Exception raised during operation : <br>");
            this.exception.printStackTrace(writer);
        }
        if (this.subActions.size() > 0) {
            writer.println(this.quote(", number_subactions") + ":" + this.quote("" + this.subActions.size()));
        }
        writer.flush();
    }

    private void write(ActionReport.MessagePart part, PrintWriter writer) {
        writer.println("{ " + this.quote("name") + ":" + this.quote(part.getMessage()));
        if (this.top) {
            writer.println(", " + this.quote("command") + ":" + this.quote(this.actionDescription));
            writer.println(", " + this.quote("exit_code") + ":" + this.quote(String.valueOf((Object)this.exitCode)));
            this.top = false;
        }
        this.writeProperties(part.getProps(), writer);
        boolean first = true;
        for (ActionReport.MessagePart child : part.getChildren()) {
            if (first) {
                writer.println(", " + this.quote("result") + " : [");
            } else {
                writer.println(",");
            }
            first = false;
            this.write(child, writer);
        }
        if (!first) {
            writer.println("]");
        }
        writer.println("}");
    }

    private void writeProperties(Properties props, PrintWriter writer) {
        if (props == null || props.size() == 0) {
            return;
        }
        StringBuilder result = new StringBuilder(",");
        result.append(this.quote("properties")).append(" : {");
        String sep = "";
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String line = this.quote(String.valueOf(entry.getKey())) + " : ";
            Object value = entry.getValue();
            line = value instanceof List ? line + this.encodeList((List)value) : (value instanceof Map ? line + this.encodeMap((Map)value) : line + this.quote(value.toString()));
            result.append(sep).append(line);
            sep = ",";
        }
        writer.println(result.append("}").toString());
    }

    private String encodeList(List list) {
        StringBuilder result = new StringBuilder("[");
        String sep = "";
        for (Object entry : list) {
            if (entry instanceof List) {
                result.append(sep).append(this.encodeList((List)entry));
            } else if (entry instanceof Map) {
                result.append(sep).append(this.encodeMap((Map)entry));
            } else {
                result.append(sep).append(this.quote(entry.toString()));
            }
            sep = ",";
        }
        return result.append("]").toString();
    }

    private String encodeMap(Map map) {
        StringBuilder result = new StringBuilder("{");
        String sep = "";
        for (Map.Entry entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            result.append(sep).append(this.quote(key)).append(":");
            if (value instanceof List) {
                result.append(this.encodeList((List)value));
            } else if (value instanceof Map) {
                result.append(this.encodeMap((Map)value));
            } else {
                result.append(this.quote(value.toString()));
            }
            sep = ",";
        }
        return result.append("}").toString();
    }

    private String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }
}

