/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="_update-node")
@I18n(value="update.node")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Node.class, opType=RestEndpoint.OpType.POST, path="_update-node", description="Update Node", params={@RestParam(name="name", value="$parent")})})
public class UpdateNodeCommand
implements AdminCommand {
    @Inject
    Nodes nodes;
    @Inject
    Domain domain;
    @Param(name="name", primary=true)
    String name;
    @Param(name="nodedir", optional=true)
    String nodedir;
    @Param(name="nodehost", optional=true)
    String nodehost;
    @Param(name="installdir", optional=true)
    String installdir;
    @Param(name="sshport", optional=true)
    String sshport;
    @Param(name="sshuser", optional=true)
    String sshuser;
    @Param(name="sshnodehost", optional=true)
    String sshnodehost;
    @Param(name="sshkeyfile", optional=true)
    String sshkeyfile;
    @Param(name="sshpassword", optional=true, password=true)
    String sshpassword;
    @Param(name="sshkeypassphrase", optional=true, password=true)
    String sshkeypassphrase;
    @Param(name="windowsdomain", optional=true)
    String windowsdomain;
    @Param(name="type", optional=true)
    String type;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        Node node = this.nodes.getNode(this.name);
        if (node == null) {
            String msg = Strings.get("noSuchNode", this.name);
            logger2.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (StringUtils.ok(this.nodehost) && NetUtils.isThisHostLocal(this.nodehost) && StringUtils.ok(this.installdir)) {
            TokenResolver resolver = null;
            HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
            resolver = new TokenResolver(systemPropsMap);
            Path resolvedInstallDir = new File(resolver.resolve(this.installdir)).toPath();
            Path actualInstallDir = resolvedInstallDir.resolve(NodeUtils.LANDMARK_FILE);
            if (!actualInstallDir.toFile().exists()) {
                report.setMessage(Strings.get("invalid.installdir", this.installdir));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (node.nodeInUse()) {
            String badparam = null;
            String configNodedir = node.getNodeDir();
            String configInstalldir = node.getInstallDir();
            if (!UpdateNodeCommand.allowableChange(this.nodedir, configNodedir)) {
                badparam = "nodedir";
            }
            if (!UpdateNodeCommand.allowableChange(this.installdir, configInstalldir)) {
                badparam = "installdir";
            }
            if (StringUtils.ok(badparam)) {
                String msg = Strings.get("noUpdate.nodeInUse", this.name, badparam);
                logger2.warning(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(msg);
                return;
            }
        }
        try {
            this.updateNodeElement(this.name);
        }
        catch (TransactionFailure e) {
            logger2.warning("failed.to.update.node " + this.name);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
    }

    public void updateNodeElement(final String nodeName) throws TransactionFailure {
        ConfigSupport.apply(new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction(param);
                if (t != null) {
                    Nodes nodes = ((Domain)param).getNodes();
                    Node node = nodes.getNode(nodeName);
                    Node writeableNode = t.enroll(node);
                    if (UpdateNodeCommand.this.windowsdomain != null) {
                        writeableNode.setWindowsDomain(UpdateNodeCommand.this.windowsdomain);
                    }
                    if (UpdateNodeCommand.this.nodedir != null) {
                        writeableNode.setNodeDir(UpdateNodeCommand.this.nodedir);
                    }
                    if (UpdateNodeCommand.this.nodehost != null) {
                        writeableNode.setNodeHost(UpdateNodeCommand.this.nodehost);
                    }
                    if (UpdateNodeCommand.this.installdir != null) {
                        writeableNode.setInstallDir(UpdateNodeCommand.this.installdir);
                    }
                    if (UpdateNodeCommand.this.type != null) {
                        writeableNode.setType(UpdateNodeCommand.this.type);
                    }
                    if (UpdateNodeCommand.this.sshport != null || UpdateNodeCommand.this.sshnodehost != null || UpdateNodeCommand.this.sshuser != null || UpdateNodeCommand.this.sshkeyfile != null) {
                        SshConnector sshC = writeableNode.getSshConnector();
                        sshC = sshC == null ? writeableNode.createChild(SshConnector.class) : t.enroll(sshC);
                        if (UpdateNodeCommand.this.sshport != null) {
                            sshC.setSshPort(UpdateNodeCommand.this.sshport);
                        }
                        if (UpdateNodeCommand.this.sshnodehost != null) {
                            sshC.setSshHost(UpdateNodeCommand.this.sshnodehost);
                        }
                        if (UpdateNodeCommand.this.sshuser != null || UpdateNodeCommand.this.sshkeyfile != null || UpdateNodeCommand.this.sshpassword != null || UpdateNodeCommand.this.sshkeypassphrase != null) {
                            SshAuth sshA = sshC.getSshAuth();
                            sshA = sshA == null ? sshC.createChild(SshAuth.class) : t.enroll(sshA);
                            if (UpdateNodeCommand.this.sshuser != null) {
                                sshA.setUserName(UpdateNodeCommand.this.sshuser);
                            }
                            if (UpdateNodeCommand.this.sshkeyfile != null) {
                                sshA.setKeyfile(UpdateNodeCommand.this.sshkeyfile);
                            }
                            if (UpdateNodeCommand.this.sshpassword != null) {
                                sshA.setPassword(UpdateNodeCommand.this.sshpassword);
                            }
                            if (UpdateNodeCommand.this.sshkeypassphrase != null) {
                                sshA.setKeyPassphrase(UpdateNodeCommand.this.sshkeypassphrase);
                            }
                            sshC.setSshAuth(sshA);
                        }
                        writeableNode.setSshConnector(sshC);
                    }
                }
                return Boolean.TRUE;
            }
        }, this.domain);
    }

    private static boolean allowableChange(String newvalue, String currentvalue) {
        if (newvalue == null) {
            return true;
        }
        if (!StringUtils.ok(currentvalue)) {
            return true;
        }
        if (newvalue.equals(currentvalue)) {
            return true;
        }
        if (newvalue.contains("$") || currentvalue.contains("$")) {
            HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
            TokenResolver resolver = new TokenResolver(systemPropsMap);
            newvalue = resolver.resolve(newvalue);
            currentvalue = resolver.resolve(currentvalue);
            return newvalue.equals(currentvalue);
        }
        return false;
    }
}

