/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ClusterExecutor;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="GlassFishClusterExecutor")
public class GlassFishClusterExecutor
implements ClusterExecutor,
PostConstruct {
    @Inject
    private Domain domain;
    @Inject
    private ExecutorService threadExecutor;
    @Inject
    private InstanceStateService instanceState;
    @Inject
    private Target targetService;
    @Inject
    private ServiceLocator habitat;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(GlassFishClusterExecutor.class);

    @Override
    public void postConstruct() {
    }

    @Override
    public ActionReport.ExitCode execute(String commandName, AdminCommand command, AdminCommandContext context, ParameterMap parameters) {
        CommandModel model = command instanceof CommandModelProvider ? ((CommandModelProvider)((Object)command)).getModel() : new CommandModelImpl(command.getClass());
        ExecuteOn clAnnotation = model.getClusteringAttributes();
        ArrayList<RuntimeType> runtimeTypes = new ArrayList<RuntimeType>();
        if (clAnnotation == null) {
            @ExecuteOn
            final class DefaultExecuteOn {
                DefaultExecuteOn() {
                }
            }
            clAnnotation = DefaultExecuteOn.class.getAnnotation(ExecuteOn.class);
        }
        if (clAnnotation.value().length == 0) {
            runtimeTypes.add(RuntimeType.DAS);
            runtimeTypes.add(RuntimeType.INSTANCE);
        } else {
            runtimeTypes.addAll(Arrays.asList(clAnnotation.value()));
        }
        String targetName = (String)parameters.getOne("target");
        if (targetName == null) {
            targetName = "server";
        }
        if (runtimeTypes.contains((Object)RuntimeType.ALL) || !CommandTarget.DAS.isValid(this.habitat, targetName) && !CommandTarget.DOMAIN.isValid(this.habitat, targetName)) {
            String dynRecfg;
            if (this.targetService.isCluster(targetName) && !runtimeTypes.contains((Object)RuntimeType.ALL) && Boolean.FALSE.equals(Boolean.valueOf(dynRecfg = this.targetService.getClusterConfig(targetName).getDynamicReconfigurationEnabled()))) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                aReport.setActionExitCode(ActionReport.ExitCode.WARNING);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.dynrecfgdisabled", "WARNING: The command was not replicated to all cluster instances because the dynamic-reconfig-enabled flag is set to false for cluster {0}", targetName));
                for (Server s : this.targetService.getInstances(targetName)) {
                    this.instanceState.setState(s.getName(), InstanceState.StateType.RESTART_REQUIRED, false);
                    this.instanceState.addFailedCommandToInstance(s.getName(), commandName, parameters);
                }
                return ActionReport.ExitCode.WARNING;
            }
            List<Object> instancesForReplication = new ArrayList();
            if (runtimeTypes.contains((Object)RuntimeType.ALL)) {
                List<Server> allInstances = this.targetService.getAllInstances();
                HashSet<String> clusterNoReplication = new HashSet<String>();
                for (Server s : allInstances) {
                    String dynRecfg2 = s.getConfig().getDynamicReconfigurationEnabled();
                    if (Boolean.TRUE.equals(Boolean.valueOf(dynRecfg2))) {
                        instancesForReplication.add(s);
                        continue;
                    }
                    clusterNoReplication.add(s.getCluster().getName());
                    this.instanceState.setState(s.getName(), InstanceState.StateType.RESTART_REQUIRED, false);
                    this.instanceState.addFailedCommandToInstance(s.getName(), commandName, parameters);
                }
                if (!clusterNoReplication.isEmpty()) {
                    ActionReport aReport = context.getActionReport().addSubActionsReport();
                    aReport.setActionExitCode(ActionReport.ExitCode.WARNING);
                    aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.dynrecfgdisabled", "WARNING: The command was not replicated to all cluster instances because the dynamic-reconfiguration-enabled flag is set to false for cluster(s) {0}", clusterNoReplication));
                }
            } else {
                instancesForReplication = this.targetService.getInstances(targetName);
            }
            if (instancesForReplication.isEmpty()) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                aReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.notargets", "Did not find any suitable instances for target {0}; command executed on DAS only", targetName));
                return ActionReport.ExitCode.SUCCESS;
            }
            return ClusterOperationUtil.replicateCommand(commandName, clAnnotation.ifFailure(), clAnnotation.ifOffline(), clAnnotation.ifNeverStarted(), instancesForReplication, context, parameters, this.habitat);
        }
        return ActionReport.ExitCode.SUCCESS;
    }
}

