/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="_list-descriptors")
@PerLookup
@I18n(value="list.commands")
@AccessRequired(resource={"domain"}, action={"dump"})
public class ListCommandDescriptorsCommand
implements AdminCommand {
    @Inject
    ServiceLocator habitat;
    private List<AdminCommand> adminCmds;
    private List<CLICommand> cliCmds = new LinkedList<CLICommand>();
    private static final String EOL = "%%%EOL%%%";

    @Override
    public void execute(AdminCommandContext context) {
        this.setAdminCommands();
        this.sort();
        for (AdminCommand cmd : this.adminCmds) {
            this.cliCmds.add(this.reflect(cmd));
        }
        ActionReport report = context.getActionReport();
        StringBuilder sb = new StringBuilder();
        sb.append("ALL COMMANDS: ").append(EOL);
        for (CLICommand cli : this.cliCmds) {
            sb.append(cli.toString()).append(EOL);
        }
        report.setMessage(sb.toString());
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private CLICommand reflect(AdminCommand cmd) {
        CLICommand cliCmd = new CLICommand(cmd);
        for (Field field : cmd.getClass().getDeclaredFields()) {
            Param param = field.getAnnotation(Param.class);
            if (param == null) continue;
            Option option = new Option(param, field);
            cliCmd.options.add(option);
        }
        return cliCmd;
    }

    private void setAdminCommands() {
        this.adminCmds = new ArrayList<AdminCommand>();
        for (AdminCommand command : this.habitat.getAllServices(AdminCommand.class, new Annotation[0])) {
            this.adminCmds.add(command);
        }
    }

    private void sort() {
        Collections.sort(this.adminCmds, new Comparator<AdminCommand>(){

            @Override
            public int compare(AdminCommand c1, AdminCommand c2) {
                Service service1 = c1.getClass().getAnnotation(Service.class);
                Service service2 = c2.getClass().getAnnotation(Service.class);
                String name1 = service1 != null ? service1.name() : "";
                String name2 = service2 != null ? service2.name() : "";
                return name1.compareTo(name2);
            }
        });
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }

    private static class CLICommand {
        AdminCommand adminCommand;
        String name;
        List<Option> options = new LinkedList<Option>();

        CLICommand(AdminCommand adminCommand) {
            this.adminCommand = adminCommand;
            Service service = adminCommand.getClass().getAnnotation(Service.class);
            this.name = service != null ? service.name() : "";
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("CLI Command: name=").append(this.name);
            sb.append(" class=").append(this.adminCommand.getClass().getName()).append(ListCommandDescriptorsCommand.EOL);
            for (Option opt : this.options) {
                sb.append(opt.toString()).append(ListCommandDescriptorsCommand.EOL);
            }
            return sb.toString();
        }
    }

    private static class Option {
        private boolean required;
        private boolean operand;
        private String name;
        private String defaultValue;
        private Class<?> type;

        Option(Param p, Field f) {
            Class<?> ftype = f.getType();
            this.name = p.name();
            if (!ListCommandDescriptorsCommand.ok(this.name)) {
                this.name = f.getName();
            }
            this.required = !p.optional();
            this.operand = p.primary();
            this.defaultValue = p.defaultValue();
            this.type = ftype;
        }

        public String toString() {
            String s = "   Option: name=" + this.name + " required=" + this.required + " operand=" + this.operand + " defaultValue=" + this.defaultValue + " type=" + this.type.getName();
            return s;
        }
    }
}

