/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.v3.admin.CLIUtil;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Service(name="delete-system-property")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.STANDALONE_INSTANCE})
@I18n(value="delete.system.property")
public class DeleteSystemProperty
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteSystemProperty.class);
    @Param(optional=true, defaultValue="server")
    String target;
    @Param(name="property_name", primary=true)
    String propName;
    @Inject
    Domain domain;
    private SystemPropertyBag spb;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.spb = CLIUtil.chooseTarget(this.domain, this.target);
        if (this.spb == null) {
            ActionReport report = context.getActionReport();
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target:{0}. Valid targets types are domain, config, cluster, default server, clustered instance, stand alone instance", this.target);
            report.setMessage(msg);
            return false;
        }
        return true;
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList result = new ArrayList();
        result.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy(this.spb), "update"));
        return result;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Property domainProp = this.domain.getProperty("administrative.domain.name");
        String domainName = domainProp.getValue();
        if (!this.spb.containsProperty(this.propName)) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("no.such.property", "System Property named {0} does not exist at the given target {1}", this.propName, this.target);
            report.setMessage(msg);
            return;
        }
        if (this.definitions(this.propName) == 1) {
            ArrayList<String> refs = new ArrayList<String>();
            ArrayList<Dom> doms = new ArrayList<Dom>();
            if ("domain".equals(this.target) || this.target.equals(domainName)) {
                for (Server s : this.domain.getServers().getServer()) {
                    Iterator<Cluster> config = s.getConfig();
                    Cluster cluster = s.getCluster();
                    if (s.containsProperty(this.propName) || config.containsProperty(this.propName)) continue;
                    if (cluster != null) {
                        if (cluster.containsProperty(this.propName)) continue;
                        doms.add(Dom.unwrap(s));
                        continue;
                    }
                    doms.add(Dom.unwrap(s));
                }
            } else {
                Config config = this.domain.getConfigNamed(this.target);
                if (config != null) {
                    String configRef;
                    doms.add(Dom.unwrap(config));
                    String configName = config.getName();
                    for (Server s : this.domain.getServers().getServer()) {
                        configRef = s.getConfigRef();
                        if (!configRef.equals(configName) || s.containsProperty(this.propName)) continue;
                        doms.add(Dom.unwrap(s));
                    }
                    for (Cluster c : this.domain.getClusters().getCluster()) {
                        configRef = c.getConfigRef();
                        if (!configRef.equals(configName) || c.containsProperty(this.propName)) continue;
                        doms.add(Dom.unwrap(c));
                    }
                } else {
                    Cluster cluster = this.domain.getClusterNamed(this.target);
                    if (cluster != null) {
                        doms.add(Dom.unwrap(cluster));
                        Config clusterConfig = this.domain.getConfigNamed(cluster.getConfigRef());
                        doms.add(Dom.unwrap(clusterConfig));
                        for (Server s : cluster.getInstances()) {
                            if (s.containsProperty(this.propName)) continue;
                            doms.add(Dom.unwrap(s));
                        }
                    } else {
                        Server server = this.domain.getServerNamed(this.target);
                        doms.add(Dom.unwrap(server));
                        doms.add(Dom.unwrap(this.domain.getConfigNamed(server.getConfigRef())));
                    }
                }
            }
            String sysPropName = SystemPropertyConstants.getPropertyAsValue(this.propName);
            for (Dom d : doms) {
                DeleteSystemProperty.listRefs(d, sysPropName, refs);
            }
            if (!refs.isEmpty()) {
                String msg = localStrings.getLocalString("cant.delete.referenced.property", "System Property {0} is referenced by {1} in the configuration. Please remove the references first.", this.propName, Arrays.toString(refs.toArray()));
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<SystemPropertyBag>(){

                @Override
                public Object run(SystemPropertyBag param) throws PropertyVetoException, TransactionFailure {
                    param.getSystemProperty().remove(param.getSystemProperty(DeleteSystemProperty.this.propName));
                    return param;
                }
            }, this.spb);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            String msg = localStrings.getLocalString("delete.sysprops.ok", "System Property named {0} deleted from given target {1}. Make sure you check its references.", this.propName, this.target);
            report.setMessage(msg);
        }
        catch (TransactionFailure tf) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tf);
        }
    }

    private int definitions(String propName) {
        int defs = 0;
        PropertyBag bag = this.domain;
        if (bag.containsProperty(propName)) {
            ++defs;
        }
        if ((bag = this.domain.getServerNamed(this.target)) != null && bag.containsProperty(propName)) {
            ++defs;
            Server server = (Server)bag;
            Cluster cluster = server.getCluster();
            if (cluster != null && cluster.containsProperty(propName)) {
                ++defs;
            }
            if (server.getConfig().containsProperty(propName)) {
                ++defs;
            }
        }
        if ((bag = this.domain.getClusterNamed(this.target)) != null && bag.containsProperty(propName)) {
            ++defs;
            Cluster c = (Cluster)bag;
            Config clusterConfig = this.domain.getConfigNamed(c.getConfigRef());
            if (clusterConfig.containsProperty(propName)) {
                ++defs;
            }
        }
        if ((bag = this.domain.getConfigNamed(this.target)) != null && bag.containsProperty(propName)) {
            ++defs;
        }
        return defs;
    }

    private static void listRefs(Dom dom, String value, List<String> refs) {
        for (String aname : dom.getAttributeNames()) {
            String raw = dom.rawAttribute(aname);
            if (raw == null || !raw.equals(value)) continue;
            refs.add(dom.model.getTagName() + ":" + aname);
        }
        for (String ename : dom.getElementNames()) {
            List<Dom> nodes = null;
            try {
                nodes = dom.nodeElements(ename);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nodes == null) continue;
            for (Dom node : nodes) {
                DeleteSystemProperty.listRefs(node, value, refs);
            }
        }
    }
}

