/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.JavaEETransactionImpl;
import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.TransactionImport;
import jakarta.inject.Inject;
import jakarta.resource.spi.XATerminator;
import jakarta.resource.spi.work.WorkException;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.rmi.RemoteException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={TransactionManagerHelper.class, TransactionManager.class})
public class TransactionManagerHelper
implements TransactionManager,
TransactionImport {
    @Inject
    private transient JavaEETransactionManager transactionManager;
    @Inject
    private transient InvocationManager invocationManager;

    @Override
    public void begin() throws NotSupportedException, SystemException {
        this.transactionManager.begin();
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.transactionManager.commit();
    }

    @Override
    public int getStatus() throws SystemException {
        return this.transactionManager.getStatus();
    }

    @Override
    public Transaction getTransaction() throws SystemException {
        return this.transactionManager.getTransaction();
    }

    @Override
    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.transactionManager.resume(tobj);
        this.preInvokeTx(false);
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.transactionManager.rollback();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.transactionManager.setRollbackOnly();
    }

    @Override
    public void setTransactionTimeout(int seconds) throws SystemException {
        this.transactionManager.setTransactionTimeout(seconds);
    }

    @Override
    public Transaction suspend() throws SystemException {
        this.postInvokeTx(true, false);
        return this.transactionManager.suspend();
    }

    @Override
    public void recreate(Xid xid, long timeout) {
        JavaEETransactionManager tm = this.transactionManager;
        try {
            tm.recreate(xid, timeout);
        }
        catch (WorkException ex) {
            throw new IllegalStateException(ex);
        }
        this.preInvokeTx(true);
    }

    @Override
    public void release(Xid xid) {
        JavaEETransactionManager tm = this.transactionManager;
        this.postInvokeTx(false, true);
        try {
            tm.release(xid);
        }
        catch (WorkException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (tm instanceof JavaEETransactionManagerSimplified) {
                ((JavaEETransactionManagerSimplified)tm).clearThreadTx();
            }
        }
    }

    @Override
    public XATerminator getXATerminator() {
        return this.transactionManager.getXATerminator();
    }

    public void preInvokeTx(boolean checkServletInvocation) {
        Object inv = this.invocationManager.getCurrentInvocation();
        if (!(inv == null || checkServletInvocation && ((ComponentInvocation)inv).getInvocationType() != ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION)) {
            try {
                this.transactionManager.enlistComponentResources();
            }
            catch (RemoteException re) {
                throw new IllegalStateException(re);
            }
        }
    }

    public void postInvokeTx(boolean suspend, boolean checkServletInvocation) {
        Object inv = this.invocationManager.getCurrentInvocation();
        if (!(inv == null || checkServletInvocation && ((ComponentInvocation)inv).getInvocationType() != ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION)) {
            try {
                this.transactionManager.delistComponentResources(suspend);
            }
            catch (RemoteException re) {
                throw new IllegalStateException(re);
            }
            finally {
                ((ComponentInvocation)inv).setTransaction(null);
            }
        }
    }

    @Override
    public int getTransactionRemainingTimeout() throws SystemException {
        int timeout = 0;
        Transaction txn = this.getTransaction();
        if (txn == null) {
            throw new IllegalStateException("no current transaction");
        }
        if (txn instanceof JavaEETransactionImpl) {
            timeout = ((JavaEETransactionImpl)txn).getRemainingTimeout();
        }
        return timeout;
    }

    @Override
    public void registerRecoveryResourceHandler(XAResource xaResource) {
        this.transactionManager.registerRecoveryResourceHandler(xaResource);
    }
}

