/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.server.logging.LogManagerService;
import com.sun.enterprise.server.logging.commands.SetLogLevel;
import com.sun.enterprise.server.logging.commands.TargetInfo;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.validation.ValidationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.main.jul.cfg.GlassFishLogManagerProperty;
import org.glassfish.main.jul.cfg.LogProperty;
import org.glassfish.main.jul.formatter.GlassFishLogFormatter;
import org.glassfish.main.jul.formatter.ODLLogFormatter;
import org.glassfish.main.jul.formatter.OneLineFormatter;
import org.glassfish.main.jul.formatter.UniformLogFormatter;
import org.glassfish.main.jul.handler.ConsoleHandlerProperty;
import org.glassfish.main.jul.handler.FileHandlerProperty;
import org.glassfish.main.jul.handler.GlassFishLogHandler;
import org.glassfish.main.jul.handler.GlassFishLogHandlerProperty;
import org.glassfish.main.jul.handler.HandlerConfigurationHelper;
import org.glassfish.main.jul.handler.SimpleLogHandler;
import org.glassfish.main.jul.handler.SyslogHandler;
import org.glassfish.main.jul.handler.SyslogHandlerProperty;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@CommandLock(value=CommandLock.LockType.NONE)
@Service(name="set-log-attributes")
@PerLookup
@I18n(value="set.log.attributes")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-log-attributes", description="set-log-attributes")})
public class SetLogAttributes
implements AdminCommand {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final Logger LOG = Logger.getLogger(SetLogAttributes.class.getName());
    private static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(SetLogLevel.class);
    private static final Set<String> VALID_ATTRIBUTES;
    @Param(name="name_value", primary=true, separator=58)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true, defaultValue="true")
    boolean validate;
    @Inject
    LoggingConfigImpl loggingConfig;
    @Inject
    private LogManagerService logManager;
    @Inject
    Domain domain;
    @Inject
    Servers servers;
    @Inject
    Clusters clusters;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        StringBuilder sbfSuccessMsg = new StringBuilder(LINE_SEP);
        boolean success = false;
        boolean invalidAttribute = false;
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            for (Object key : this.properties.keySet()) {
                String att_name = (String)key;
                String att_value = (String)this.properties.get(att_name);
                if (this.validate) {
                    boolean vlAttribute = this.isValid(att_name, att_value, report);
                    if (vlAttribute) {
                        m.put(att_name, att_value);
                        sbfSuccessMsg.append(LOCAL_STRINGS.getLocalString("set.log.attribute.properties", "{0} logging attribute set with value {1}.", att_name, att_value)).append(LINE_SEP);
                        continue;
                    }
                    invalidAttribute = true;
                    break;
                }
                m.put(att_name, att_value);
                sbfSuccessMsg.append(LOCAL_STRINGS.getLocalString("set.log.attribute.properties", "{0} logging attribute set with value {1}.", att_name, att_value)).append(LINE_SEP);
            }
            if (invalidAttribute) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            TargetInfo targetInfo = new TargetInfo(this.domain, this.target);
            String targetConfigName = targetInfo.getConfigName();
            boolean isDas = targetInfo.isDas();
            this.loggingConfig.updateLoggingProperties(m, targetConfigName);
            success = true;
            if (!success) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                String msg = LOCAL_STRINGS.getLocalString("invalid.target.sys.props", "Invalid target: {0}. Valid default target is a server named ''server'' (default) or cluster name.", this.target);
                report.setMessage(msg);
                return;
            }
            String effectiveTarget = isDas ? "server" : targetConfigName;
            sbfSuccessMsg.append(LOCAL_STRINGS.getLocalString("set.log.attribute.success", "These logging attributes are set for {0}.", effectiveTarget)).append(LINE_SEP);
            report.setMessage(sbfSuccessMsg.toString());
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (IOException e) {
            report.setMessage(LOCAL_STRINGS.getLocalString("set.log.attribute.failed", "Could not set logging attributes for {0}.", this.target));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private boolean isValid(String att_name, String att_value, ActionReport report) {
        for (String attrName : VALID_ATTRIBUTES) {
            if (!attrName.equals(att_name)) continue;
            try {
                this.logManager.validateLoggingProperty(att_name, att_value);
                return true;
            }
            catch (ValidationException e) {
                if (e.getMessage() == null) continue;
                report.setMessage(e.getMessage() + "\n");
                return false;
            }
        }
        report.appendMessage(LOCAL_STRINGS.getLocalString("set.log.attribute.invalid", "Invalid logging attribute name {0} or value {1}.", att_name, att_value));
        return false;
    }

    static {
        HashSet<String> properties = new HashSet<String>();
        Arrays.stream(GlassFishLogManagerProperty.values()).forEach(p -> properties.add(p.getPropertyName()));
        Class[] formatters = new Class[]{UniformLogFormatter.class, ODLLogFormatter.class, OneLineFormatter.class};
        Arrays.stream(GlassFishLogHandlerProperty.values()).forEach(p -> properties.add(p.getPropertyFullName(GlassFishLogHandler.class)));
        Arrays.stream(SimpleLogHandler.SimpleLogHandlerProperty.values()).forEach(p -> properties.add(p.getPropertyFullName(SimpleLogHandler.class)));
        Arrays.stream(SyslogHandlerProperty.values()).forEach(p -> properties.add(p.getPropertyFullName(SyslogHandler.class)));
        Arrays.stream(UniformLogFormatter.UniformFormatterProperty.values()).forEach(p -> properties.add(p.getPropertyFullName(UniformLogFormatter.class)));
        Arrays.stream(ODLLogFormatter.ODLFormatterProperty.values()).forEach(p -> properties.add(p.getPropertyFullName(ODLLogFormatter.class)));
        Arrays.stream(OneLineFormatter.OneLineFormatterProperty.values()).forEach(p -> properties.add(p.getPropertyFullName(OneLineFormatter.class)));
        for (Class formatter : formatters) {
            Arrays.stream(GlassFishLogFormatter.GlassFishLogFormatterProperty.values()).forEach(p -> properties.add(p.getPropertyFullName(formatter)));
        }
        Class[] handlersWithFormatter = new Class[]{GlassFishLogHandler.class, SimpleLogHandler.class};
        HashSet formatterParameters = new HashSet();
        Arrays.stream(UniformLogFormatter.UniformFormatterProperty.values()).forEach(formatterParameters::add);
        Arrays.stream(ODLLogFormatter.ODLFormatterProperty.values()).forEach(formatterParameters::add);
        Arrays.stream(OneLineFormatter.OneLineFormatterProperty.values()).forEach(formatterParameters::add);
        Arrays.stream(GlassFishLogFormatter.GlassFishLogFormatterProperty.values()).forEach(formatterParameters::add);
        Arrays.stream(FileHandlerProperty.values()).forEach(formatterParameters::add);
        for (LogProperty logProperty : formatterParameters) {
            for (Class handler : handlersWithFormatter) {
                String formatterPrefix = HandlerConfigurationHelper.FORMATTER.getPropertyFullName(handler);
                properties.add(logProperty.getPropertyFullName(formatterPrefix));
            }
        }
        properties.add(ConsoleHandlerProperty.ENCODING.getPropertyFullName());
        properties.add(ConsoleHandlerProperty.FILTER.getPropertyFullName());
        properties.add(ConsoleHandlerProperty.FORMATTER.getPropertyFullName());
        properties.add(ConsoleHandlerProperty.LEVEL.getPropertyFullName());
        properties.add("java.util.logging.SimpleFormatter.format");
        VALID_ATTRIBUTES = Collections.unmodifiableSet(properties);
        LOG.log(Level.FINE, "Acceptable logging properties for the set-log-attribute command (except loggers): {0}", VALID_ATTRIBUTES);
    }
}

