/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.logviewer.backend.LogFilterForInstance;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS})
@Service(name="collect-log-files")
@PerLookup
@I18n(value="collect.log.files")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="collect-log-files", description="collect-log-files")})
public class CollectLogFiles
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CollectLogFiles.class);
    private static final Logger LOGGER = LogFacade.LOGGING_LOGGER;
    @Param(optional=true)
    String target = "server";
    @Param(name="retrieve", optional=true, defaultValue="false")
    boolean retrieve;
    @Param(primary=true, optional=true, defaultValue=".")
    private String retrieveFilePath;
    @Inject
    ServerEnvironment env;
    @Inject
    Domain domain;
    @Inject
    private ServiceLocator habitat;
    @Inject
    LoggingConfigImpl loggingConfig;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Properties props = this.initFileXferProps();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (targetServer != null && targetServer.isDas()) {
            String logFileDetails;
            try {
                logFileDetails = this.loggingConfig.getLoggingFileDetails();
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.errGettingLogFiles", "Error while getting log file attribute for {0}.", this.target);
                report.setMessage(errorMsg);
                report.setFailureCause(ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            File targetDir = this.makingDirectoryOnDas(targetServer.getName(), report);
            try {
                Path sourceDir = logFileDetails.contains("${com.sun.aas.instanceRoot}/logs") ? this.env.getInstanceRoot().toPath().resolve("logs") : new File(logFileDetails).toPath().getParent();
                this.copyLogFilesForLocalhost(sourceDir, targetDir.getAbsolutePath(), report, targetServer.getName());
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from {0}.", this.target);
                report.setMessage(errorMsg);
                report.setFailureCause(ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            String zipFile = null;
            try {
                String zipFilePath = this.getZipFilePath().getAbsolutePath();
                zipFile = this.loggingConfig.createZipFile(zipFilePath);
                if (zipFile == null) {
                    String errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file {0}.", zipFilePath);
                    report.setMessage(errorMsg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            catch (Exception e) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file {0}.", zipFile);
                report.setMessage(errorMsg);
                report.setFailureCause(e);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.retrieve) {
                this.retrieveFile(zipFile, this.getZipFilePath(), props, report);
                report.setMessage(localStrings.getLocalString("collectlogfiles.instance.success", "Created Zip file under {0}.", this.retrieveFilePath + File.separator + new File(zipFile).getName()));
            } else {
                report.setMessage(localStrings.getLocalString("collectlogfiles.instance.success", "Created Zip file under {0}.", zipFile));
            }
        } else if (targetServer != null && targetServer.isInstance()) {
            String logFileDetails;
            String instanceName = targetServer.getName();
            String serverNode = targetServer.getNodeRef();
            Node node = this.domain.getNodes().getNode(serverNode);
            String zipFile = "";
            File targetDir = null;
            try {
                logFileDetails = this.getInstanceLogFileDirectory(targetServer);
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.errGettingLogFiles", "Error while getting log file attribute for {0}.", this.target);
                report.setMessage(errorMsg);
                report.setFailureCause(ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            targetDir = this.makingDirectoryOnDas(targetServer.getName(), report);
            try {
                if (node.isLocal()) {
                    Path sourceDir = this.getLogDirForLocalNode(logFileDetails, node, serverNode, instanceName);
                    this.copyLogFilesForLocalhost(sourceDir, targetDir.getAbsolutePath(), report, instanceName);
                } else {
                    new LogFilterForInstance().downloadAllInstanceLogFiles(this.habitat, targetServer, this.domain, LOGGER, instanceName, targetDir.toPath(), logFileDetails);
                }
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from {0}.", instanceName);
                report.setMessage(errorMsg);
                report.setFailureCause(ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                String zipFilePath = this.getZipFilePath().getAbsolutePath();
                zipFile = this.loggingConfig.createZipFile(zipFilePath);
                if (zipFile == null || new File(zipFile) == null) {
                    String errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file {0}.", zipFilePath);
                    report.setMessage(errorMsg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file {0}.", zipFile);
                report.setMessage(errorMsg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.retrieve) {
                this.retrieveFile(zipFile, this.getZipFilePath(), props, report);
                report.setMessage(localStrings.getLocalString("collectlogfiles.instance.success", "Created Zip file under {0}.", this.retrieveFilePath + File.separator + new File(zipFile).getName()));
            } else {
                report.setMessage(localStrings.getLocalString("collectlogfiles.instance.success", "Created Zip file under {0}.", zipFile));
            }
        } else {
            String logFileDetails;
            Object finalMessage = "";
            String zipFile = "";
            File targetDir = null;
            try {
                logFileDetails = this.loggingConfig.getLoggingFileDetails();
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.errGettingLogFiles", "Error while getting log file attribute for {0}.", this.target);
                report.setMessage(errorMsg);
                report.setFailureCause(ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            targetDir = this.makingDirectoryOnDas("server", report);
            try {
                Path sourceDir = logFileDetails.contains("${com.sun.aas.instanceRoot}/logs") ? this.env.getInstanceRoot().toPath().resolve("logs") : new File(logFileDetails).toPath().getParent();
                this.copyLogFilesForLocalhost(sourceDir, targetDir.getAbsolutePath(), report, "server");
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from {0}.", this.target);
                report.setMessage(errorMsg);
                report.setFailureCause(ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            Cluster cluster = this.domain.getClusterNamed(this.target);
            List<Server> instances = cluster.getInstances();
            int instanceCount = 0;
            int errorCount = 0;
            for (Server instance : instances) {
                String errorMsg;
                String logFile;
                String instanceName = instance.getName();
                String serverNode = instance.getNodeRef();
                Node node = this.domain.getNodes().getNode(serverNode);
                boolean errorOccur = false;
                ++instanceCount;
                try {
                    logFile = this.getInstanceLogFileDirectory(this.domain.getServerNamed(instanceName));
                }
                catch (Exception ex) {
                    errorMsg = localStrings.getLocalString("collectlogfiles.errGettingLogFiles", "Error while getting log file attribute for {0}.", this.target);
                    report.setMessage(errorMsg);
                    report.setFailureCause(ex);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                try {
                    targetDir = this.makingDirectoryOnDas(instanceName, report);
                    if (node.isLocal()) {
                        Path sourceDir = this.getLogDirForLocalNode(logFile, node, serverNode, instanceName);
                        this.copyLogFilesForLocalhost(sourceDir, targetDir.getAbsolutePath(), report, instanceName);
                    } else {
                        new LogFilterForInstance().downloadAllInstanceLogFiles(this.habitat, instance, this.domain, LOGGER, instanceName, targetDir.toPath(), logFile);
                    }
                }
                catch (Exception ex) {
                    ++errorCount;
                    errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from {0}.", instanceName);
                    errorOccur = true;
                    finalMessage = (String)finalMessage + errorMsg + "\n";
                }
                if (errorOccur) continue;
                String successMsg = localStrings.getLocalString("collectlogfiles.successInstanceDownloading", "Log files are downloaded for {0}.", instanceName);
                finalMessage = (String)finalMessage + successMsg + "\n";
            }
            report.setMessage((String)finalMessage);
            if (instanceCount != errorCount) {
                String errorMsg;
                try {
                    String zipFilePath = this.getZipFilePath().getAbsolutePath();
                    zipFile = this.loggingConfig.createZipFile(zipFilePath);
                    if (zipFile == null) {
                        errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file {0}.", zipFilePath);
                        report.setMessage(errorMsg);
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        return;
                    }
                }
                catch (Exception ex) {
                    errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file {0}.", zipFile);
                    report.setMessage(errorMsg);
                    report.setFailureCause(ex);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                if (this.retrieve) {
                    this.retrieveFile(zipFile, this.getZipFilePath(), props, report);
                    report.setMessage(localStrings.getLocalString("collectlogfiles.cluster.success", "{0} Created Zip file under {1}.", finalMessage, this.retrieveFilePath + File.separator + new File(zipFile).getName()));
                } else {
                    report.setMessage(localStrings.getLocalString("collectlogfiles.cluster.success", "{0} Created Zip file under {1}.", finalMessage, zipFile));
                }
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            } else if (instanceCount == 0) {
                report.setMessage(localStrings.getLocalString("collectlogfiles.noinstance", "No instances are defined as part of {0}. So there are no files to zip.", this.target));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        }
        this.deleteDir(new File(String.valueOf(this.env.getInstanceRoot()) + File.separator + "collected-logs" + File.separator + "logs"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyLogFilesForLocalhost(Path sourceDir, String targetDir, ActionReport report, String instanceName) throws IOException {
        File logsDir = sourceDir.toFile();
        File[] allLogFileNames = logsDir.listFiles();
        if (allLogFileNames == null) {
            throw new IOException("");
        }
        for (File logFile : allLogFileNames) {
            if (!logFile.isFile()) continue;
            File toFile = new File(targetDir, logFile.getName());
            FileInputStream from = null;
            FileOutputStream to = null;
            try {
                int bytesRead;
                from = new FileInputStream(logFile);
                to = new FileOutputStream(toFile);
                byte[] buffer = new byte[4096];
                while ((bytesRead = from.read(buffer)) != -1) {
                    to.write(buffer, 0, bytesRead);
                }
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log file from {0}.", instanceName);
                report.setMessage(errorMsg);
                report.setFailureCause(ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            finally {
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (Exception exception) {}
                }
                if (to != null) {
                    try {
                        to.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (toFile.exists()) continue;
            String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log file from {0}.", instanceName);
            report.setMessage(errorMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    private Properties initFileXferProps() {
        Properties props = new Properties();
        props.setProperty("file-xfer-root", this.retrieveFilePath.replace("\\", "/"));
        return props;
    }

    private void retrieveFile(String zipFileName, File tempDirectory, Properties props, ActionReport report) {
        PayloadImpl.Outbound outboundPayload = PayloadImpl.Outbound.newInstance();
        try {
            ArrayList<File> files = new ArrayList<File>(Arrays.asList(tempDirectory.listFiles()));
            for (int i = 0; i < files.size(); ++i) {
                File file = (File)files.get(i);
                if (file.isDirectory()) {
                    files.addAll(Arrays.asList(file.listFiles()));
                    continue;
                }
                if (file.getAbsolutePath().contains(".zip")) continue;
                outboundPayload.attachFile("application/octet-stream", tempDirectory.toURI().relativize(file.toURI()), "files", props, file);
            }
            File targetLocalFile = new File(this.retrieveFilePath, new File(zipFileName).getName()).getAbsoluteFile();
            if (targetLocalFile.exists()) {
                throw new Exception("File exists");
            }
            if (!targetLocalFile.getParentFile().exists()) {
                throw new Exception("Parent directory does not exist");
            }
            try (FileOutputStream targetStream = new FileOutputStream(targetLocalFile);){
                outboundPayload.writeTo(targetStream);
                targetStream.flush();
            }
        }
        catch (Exception ex) {
            String errorMsg = localStrings.getLocalString("collectlogfiles.copyingZip", "Error while copying zip file to {0}.", this.retrieveFilePath);
            report.setMessage(errorMsg);
            report.setFailureCause(ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    public boolean deleteDir(File dir) {
        boolean ret = true;
        for (File f : dir.listFiles()) {
            ret = f.isDirectory() ? ret && this.deleteDir(f) : ret && f.delete();
        }
        return ret && dir.delete();
    }

    private String getInstanceLogFileDirectory(Server targetServer) throws IOException {
        String logFileDetailsForServer = "";
        String targetConfigName = "";
        Cluster clusterForInstance = targetServer.getCluster();
        targetConfigName = clusterForInstance != null ? clusterForInstance.getConfigRef() : targetServer.getConfigRef();
        logFileDetailsForServer = this.loggingConfig.getLoggingFileDetails(targetConfigName);
        return logFileDetailsForServer;
    }

    private File makingDirectory(String path, ActionReport report, String errorMsg) {
        File targetDir = new File(path);
        boolean created = false;
        if (!targetDir.exists()) {
            created = targetDir.mkdir();
            if (!created) {
                report.setMessage(errorMsg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return null;
            }
            return targetDir;
        }
        return targetDir;
    }

    private File makingDirectory(File parent, String path, ActionReport report, String errorMsg) {
        File targetDir = new File(parent, path);
        boolean created = false;
        if (!targetDir.exists()) {
            created = targetDir.mkdir();
            if (!created) {
                report.setMessage(errorMsg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return null;
            }
            return targetDir;
        }
        return targetDir;
    }

    private Path getLogDirForLocalNode(String instanceLogFileDirectory, Node node, String serverNode, String instanceName) {
        Path loggingDir = new LogFilterForInstance().getLoggingDirectoryForNode(instanceLogFileDirectory, node, serverNode, instanceName);
        File[] allLogFileNames = loggingDir.toFile().listFiles();
        boolean noFileFound = true;
        if (allLogFileNames != null) {
            for (File file : allLogFileNames) {
                String fileName = file.getName();
                if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                noFileFound = false;
                break;
            }
        }
        if (noFileFound) {
            loggingDir = new LogFilterForInstance().getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDirectory, node, serverNode, instanceName);
        }
        return loggingDir;
    }

    private File makingDirectoryOnDas(String serverName, ActionReport report) {
        File tempDirectory = this.makingDirectory(this.env.getInstanceRoot(), "collected-logs", report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
        String targetDirPath = tempDirectory.getAbsolutePath() + File.separator + "logs";
        File targetDir = this.makingDirectory(targetDirPath, report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
        targetDirPath = targetDir.getAbsolutePath() + File.separator + serverName;
        targetDir = this.makingDirectory(targetDirPath, report, localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files."));
        return targetDir;
    }

    private File getZipFilePath() {
        return new File(String.valueOf(this.env.getInstanceRoot()) + File.separator + "collected-logs");
    }
}

