/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModuleChangeListener;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.server.logging.LoggerInfoData;
import com.sun.enterprise.server.logging.LoggerInfoMetadata;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class LoggerInfoMetadataService
implements LoggerInfoMetadata,
ModuleChangeListener {
    private static final System.Logger LOG = System.getLogger(LoggerInfoMetadataService.class.getName());
    private static final String RBNAME = "META-INF/loggerinfo/LoggerInfoMetadata";
    private static final Locale BASE_LOCALE = Locale.ROOT;
    @Inject
    ModulesRegistry modulesRegistry;
    private Map<Locale, LoggersInfoMap> metadataMaps;
    private Set<String> moduleNames;
    private boolean valid;

    private Set<String> currentModuleNames() {
        HashSet<String> currentNames = new HashSet<String>();
        for (HK2Module module : this.modulesRegistry.getModules()) {
            currentNames.add(module.getName());
        }
        if (this.moduleNames != null) {
            for (String name : this.moduleNames) {
                if (currentNames.contains(name)) continue;
                this.valid = false;
            }
            for (String name : currentNames) {
                if (this.moduleNames.contains(name)) continue;
                this.valid = false;
            }
        } else {
            this.valid = false;
        }
        return currentNames;
    }

    private boolean isValid() {
        return this.valid && this.metadataMaps != null;
    }

    private synchronized LoggersInfoMap getLoggersInfoMap(Locale locale) {
        LoggersInfoMap infos;
        this.moduleNames = this.currentModuleNames();
        if (!this.isValid()) {
            this.metadataMaps = new HashMap<Locale, LoggersInfoMap>();
        }
        if ((infos = this.metadataMaps.get(locale)) == null) {
            infos = new LoggersInfoMap(locale);
            this.metadataMaps.put(locale, infos);
        }
        this.valid = true;
        return infos;
    }

    @Override
    public String getDescription(String logger2) {
        LoggersInfoMap infos = this.getLoggersInfoMap(BASE_LOCALE);
        return infos.getDescription(logger2);
    }

    @Override
    public String getDescription(String logger2, Locale locale) {
        LoggersInfoMap infos = this.getLoggersInfoMap(locale);
        return infos.getDescription(logger2);
    }

    @Override
    public Set<String> getLoggerNames() {
        LoggersInfoMap infos = this.getLoggersInfoMap(BASE_LOCALE);
        return infos.getLoggerNames();
    }

    @Override
    public String getSubsystem(String logger2) {
        LoggersInfoMap infos = this.getLoggersInfoMap(BASE_LOCALE);
        return infos.getSubsystem(logger2);
    }

    @Override
    public boolean isPublished(String logger2) {
        LoggersInfoMap infos = this.getLoggersInfoMap(BASE_LOCALE);
        return infos.isPublished(logger2);
    }

    @Override
    public synchronized void changed(HK2Module sender) {
        this.valid = false;
    }

    private class LoggersInfoMap {
        private final Locale locale;
        private final Map<String, LoggerInfoData> map;

        LoggersInfoMap(Locale locale) {
            this.locale = locale;
            this.map = new HashMap<String, LoggerInfoData>();
            this.initialize();
        }

        public Set<String> getLoggerNames() {
            return this.map.keySet();
        }

        public String getDescription(String logger2) {
            LoggerInfoData info = this.map.get(logger2);
            return info != null ? info.getDescription() : null;
        }

        public String getSubsystem(String logger2) {
            LoggerInfoData info = this.map.get(logger2);
            return info != null ? info.getSubsystem() : null;
        }

        public boolean isPublished(String logger2) {
            LoggerInfoData info = this.map.get(logger2);
            return info != null ? info.isPublished() : false;
        }

        private void initialize() {
            for (HK2Module module : LoggerInfoMetadataService.this.modulesRegistry.getModules()) {
                int size;
                ModuleDefinition moduleDef = module.getModuleDefinition();
                URI[] uris = moduleDef.getLocations();
                int n = size = uris == null ? 0 : uris.length;
                if (size == 0) continue;
                URL[] urls = new URL[size];
                try {
                    ResourceBundle rb;
                    for (int i = 0; i < size; ++i) {
                        urls[i] = uris[i].toURL();
                    }
                    try (GlassfishUrlClassLoader loader = new GlassfishUrlClassLoader(urls, (ClassLoader)new NullClassLoader());){
                        rb = ResourceBundle.getBundle(LoggerInfoMetadataService.RBNAME, this.locale, loader);
                    }
                    for (String key : rb.keySet()) {
                        int index = key.lastIndexOf(46);
                        String loggerName = key.substring(0, index);
                        String attribute = key.substring(index + 1);
                        String value = rb.getString(key);
                        LoggerInfoData li = this.findOrCreateLoggerInfoMetadata(loggerName);
                        if (attribute.equals("description")) {
                            li.setDescription(value);
                            continue;
                        }
                        if (attribute.equals("publish")) {
                            li.setPublished(Boolean.parseBoolean(value));
                            continue;
                        }
                        if (!attribute.equals("subsystem")) continue;
                        li.setSubsystem(value);
                    }
                }
                catch (IOException e) {
                    LOG.log(System.Logger.Level.ERROR, "Initialization failed.", (Throwable)e);
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
        }

        private LoggerInfoData findOrCreateLoggerInfoMetadata(String loggerName) {
            LoggerInfoData loggerInfoData = null;
            if (this.map.containsKey(loggerName)) {
                loggerInfoData = this.map.get(loggerName);
            } else {
                loggerInfoData = new LoggerInfoData();
                this.map.put(loggerName, loggerInfoData);
            }
            return loggerInfoData;
        }
    }

    private static class NullClassLoader
    extends ClassLoader {
        private NullClassLoader() {
        }

        @Override
        protected URL findResource(String name) {
            return null;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return null;
        }

        @Override
        public URL getResource(String name) {
            return null;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException("Class not found: " + name);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            throw new ClassNotFoundException("Class not found: " + name);
        }
    }
}

