/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.perms;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deployment.PermissionsDescriptor;
import com.sun.enterprise.deployment.io.PermissionsDeploymentDescriptorFile;
import com.sun.enterprise.security.ee.perms.PermissionXMLParser;
import com.sun.enterprise.security.ee.perms.SMGlobalPolicyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.security.PermissionCollection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.xml.sax.SAXException;

public class XMLPermissionsHandler {
    private static final Logger LOG = Logger.getLogger("jakarta.enterprise.system.core.security");
    private static final String PERMISSIONS_XML = "META-INF/permissions.xml";
    private static ServiceLocator serviceLocator = Globals.getDefaultBaseServiceLocator();
    private DasConfig dasConfig;
    private PermissionCollection declaredPermXml;
    private final SMGlobalPolicyUtil.CommponentType compType;

    public XMLPermissionsHandler(File base, SMGlobalPolicyUtil.CommponentType type2) throws XMLStreamException, FileNotFoundException {
        this.compType = type2;
        this.configureAppDeclaredPermissions(base);
        this.checkServerRestrictedPermissions();
    }

    public XMLPermissionsHandler(InputStream restrictPermInput, InputStream allowedPermInput, SMGlobalPolicyUtil.CommponentType type2) throws XMLStreamException, FileNotFoundException {
        this.compType = type2;
        this.configureAppDeclaredPermissions(allowedPermInput);
        this.checkServerRestrictedPermissions();
    }

    public PermissionCollection getAppDeclaredPermissions() {
        return this.declaredPermXml;
    }

    private void configureAppDeclaredPermissions(File base) {
        File permissionsXml = new File(base.getAbsolutePath(), PERMISSIONS_XML);
        if (permissionsXml.exists()) {
            FileInputStream fi = null;
            try {
                PermissionsDeploymentDescriptorFile pddf = new PermissionsDeploymentDescriptorFile();
                if (serviceLocator != null) {
                    this.dasConfig = serviceLocator.getService(DasConfig.class, new Annotation[0]);
                    if (this.dasConfig != null) {
                        String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
                        if (xmlValidationLevel.equals("none")) {
                            pddf.setXMLValidation(false);
                        } else {
                            pddf.setXMLValidation(true);
                        }
                        pddf.setXMLValidationLevel(xmlValidationLevel);
                    }
                }
                fi = new FileInputStream(permissionsXml);
                PermissionsDescriptor pd = (PermissionsDescriptor)pddf.read(fi);
                this.declaredPermXml = pd.getDeclaredPermissions();
                LOG.log(Level.FINE, "App declared permission = {0}", this.declaredPermXml);
            }
            catch (IOException | SAXException e) {
                throw new SecurityException(e);
            }
            finally {
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void configureAppDeclaredPermissions(InputStream permInput) throws XMLStreamException, FileNotFoundException {
        if (permInput != null) {
            PermissionXMLParser parser = new PermissionXMLParser(permInput, null);
            this.declaredPermXml = parser.getPermissions();
            LOG.log(Level.FINE, "App declared permission = {0}", this.declaredPermXml);
        }
    }

    private void checkServerRestrictedPermissions() {
        if (this.declaredPermXml == null) {
            return;
        }
        if (this.compType == null) {
            return;
        }
        SMGlobalPolicyUtil.checkRestrictionOfComponentType(this.declaredPermXml, this.compType);
    }
}

