/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.perms;

import com.sun.enterprise.security.ee.perms.PermissionsProcessor;
import com.sun.enterprise.security.ee.perms.SMGlobalPolicyUtil;
import java.net.MalformedURLException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.deployment.DeploymentContext;

public class EarEEPermissionsProcessor
extends PermissionsProcessor {
    private static final Map<SMGlobalPolicyUtil.CommponentType, PermissionCollection> compTypeToEEGarntsMap = new HashMap<SMGlobalPolicyUtil.CommponentType, PermissionCollection>();

    public EarEEPermissionsProcessor(DeploymentContext dc) throws SecurityException {
        super(SMGlobalPolicyUtil.CommponentType.ear, dc);
        try {
            this.convertEEPermissionPaths(SMGlobalPolicyUtil.CommponentType.ejb);
            this.convertEEPermissionPaths(SMGlobalPolicyUtil.CommponentType.war);
            this.convertEEPermissionPaths(SMGlobalPolicyUtil.CommponentType.rar);
            this.convertEEPermissionPaths(SMGlobalPolicyUtil.CommponentType.car);
            this.combineAllEEPermisssonsForEar();
        }
        catch (MalformedURLException e) {
            throw new SecurityException(e);
        }
    }

    public PermissionCollection getAdjustedEEPermission(SMGlobalPolicyUtil.CommponentType type2) {
        return compTypeToEEGarntsMap.get((Object)type2);
    }

    public Map<SMGlobalPolicyUtil.CommponentType, PermissionCollection> getAllAdjustedEEPermission() {
        return compTypeToEEGarntsMap;
    }

    private void convertEEPermissionPaths(SMGlobalPolicyUtil.CommponentType cmpType) throws MalformedURLException {
        PermissionCollection defWarPc = SMGlobalPolicyUtil.getEECompGrantededPerms(cmpType);
        PermissionCollection eePc = EarEEPermissionsProcessor.processPermisssonsForPath(defWarPc, this.context);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Revised permissions = " + String.valueOf(eePc));
        }
        compTypeToEEGarntsMap.put(cmpType, eePc);
    }

    private PermissionCollection combineAllEEPermisssonsForEar() {
        if (compTypeToEEGarntsMap == null) {
            return null;
        }
        Permissions allEEPerms = new Permissions();
        this.addPermissions(allEEPerms, this.getAdjustedEEPermission(SMGlobalPolicyUtil.CommponentType.war));
        this.addPermissions(allEEPerms, this.getAdjustedEEPermission(SMGlobalPolicyUtil.CommponentType.ejb));
        this.addPermissions(allEEPerms, this.getAdjustedEEPermission(SMGlobalPolicyUtil.CommponentType.rar));
        compTypeToEEGarntsMap.put(SMGlobalPolicyUtil.CommponentType.ear, allEEPerms);
        return allEEPerms;
    }

    private void addPermissions(Permissions combined, PermissionCollection toAdd) {
        if (toAdd == null) {
            return;
        }
        Enumeration<Permission> enumAdd = toAdd.elements();
        while (enumAdd.hasMoreElements()) {
            Permission p = enumAdd.nextElement();
            combined.add(p);
        }
    }
}

