/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.jmac.callback;

import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.ee.jmac.callback.GlassFishBaseCallbackHandler;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.CertStoreCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import jakarta.security.auth.message.callback.PrivateKeyCallback;
import jakarta.security.auth.message.callback.SecretKeyCallback;
import jakarta.security.auth.message.callback.TrustStoreCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

public final class ServerContainerCallbackHandler
extends GlassFishBaseCallbackHandler {
    private String realmName;

    public ServerContainerCallbackHandler() {
    }

    public ServerContainerCallbackHandler(String realmName) {
        this.realmName = realmName;
    }

    @Override
    protected void handleSupportedCallbacks(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            this.processCallback(callback);
        }
    }

    @Override
    protected boolean isSupportedCallback(Callback callback) {
        boolean isSupported = false;
        if (callback instanceof CertStoreCallback || callback instanceof PasswordValidationCallback || callback instanceof CallerPrincipalCallback || callback instanceof GroupPrincipalCallback || callback instanceof SecretKeyCallback || callback instanceof PrivateKeyCallback || callback instanceof TrustStoreCallback) {
            isSupported = true;
        }
        return isSupported;
    }

    @Override
    protected void processPasswordValidation(PasswordValidationCallback pwdCallback) {
        String username = pwdCallback.getUsername();
        char[] password = pwdCallback.getPassword();
        try {
            LoginContextDriver.jmacLogin(pwdCallback.getSubject(), username, password, this.realmName);
            this.ditchPassword(password);
            pwdCallback.setResult(true);
        }
        catch (LoginException le) {
            pwdCallback.setResult(false);
        }
    }

    private void ditchPassword(char[] passwd) {
        if (passwd != null) {
            for (int i = 0; i < passwd.length; ++i) {
                passwd[i] = 32;
            }
        }
    }
}

